/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.jline.console.completer;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import scala.tools.jline.console.completer.Completer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringsCompleter
implements Completer {
    private final SortedSet<String> strings = new TreeSet<String>();

    public StringsCompleter() {
    }

    public StringsCompleter(Collection<String> collection) {
        assert (collection != null);
        this.getStrings().addAll(collection);
    }

    public StringsCompleter(String ... stringArray) {
        this(Arrays.asList(stringArray));
    }

    public Collection<String> getStrings() {
        return this.strings;
    }

    @Override
    public int complete(String string, int n, List<CharSequence> list) {
        assert (list != null);
        if (string == null) {
            list.addAll(this.strings);
        } else {
            String string2;
            Iterator iterator = this.strings.tailSet(string).iterator();
            while (iterator.hasNext() && (string2 = (String)iterator.next()).startsWith(string)) {
                list.add(string2);
            }
        }
        if (list.size() == 1) {
            list.set(0, list.get(0) + " ");
        }
        return list.isEmpty() ? -1 : 0;
    }
}

