/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil;

public final class TypeAttributes {
    public static final int VisibilityMask = 7;
    public static final int NotPublic = 0;
    public static final int Public = 1;
    public static final int NestedPublic = 2;
    public static final int NestedPrivate = 3;
    public static final int NestedFamily = 4;
    public static final int NestedAssembly = 5;
    public static final int NestedFamANDAssem = 6;
    public static final int NestedFamORAssem = 7;
    public static final int LayoutMask = 24;
    public static final int AutoLayout = 0;
    public static final int SequentialLayout = 8;
    public static final int ExplicitLayout = 16;
    public static final int ClassSemanticsMask = 32;
    public static final int Class = 0;
    public static final int Interface = 32;
    public static final int Abstract = 128;
    public static final int Sealed = 256;
    public static final int SpecialName = 1024;
    public static final int Import = 4096;
    public static final int Serializable = 8192;
    public static final int StringFormatMask = 196608;
    public static final int AnsiClass = 0;
    public static final int UnicodeClass = 65536;
    public static final int AutoClass = 131072;
    public static final int BeforeFieldInit = 0x100000;
    public static final int RTSpecialName = 2048;
    public static final int HasSecurity = 262144;

    public static String accessModsToString(int attrs) {
        switch (attrs & 7) {
            case 0: {
                return "private";
            }
            case 1: {
                return "public";
            }
            case 2: {
                return "nested public";
            }
            case 3: {
                return "nested private";
            }
            case 4: {
                return "nested family";
            }
            case 5: {
                return "nested assembly";
            }
            case 6: {
                return "nested famandassem";
            }
            case 7: {
                return "nested famorassem";
            }
        }
        throw new RuntimeException();
    }

    public static String toString(int attrs) {
        StringBuffer str = new StringBuffer(TypeAttributes.accessModsToString(attrs));
        switch (attrs & 0x18) {
            case 0: {
                str.append(" auto");
                break;
            }
            case 8: {
                str.append(" sequential");
                break;
            }
            case 16: {
                str.append(" explicit");
            }
        }
        switch (attrs & 0x30000) {
            case 0: {
                str.append(" ansi");
                break;
            }
            case 65536: {
                str.append(" unicode");
                break;
            }
            case 131072: {
                str.append(" autochar");
            }
        }
        if ((attrs & 0x20) != 0) {
            str.append(" interface");
        }
        if ((attrs & 0x80) != 0) {
            str.append(" abstract");
        }
        if ((attrs & 0x100) != 0) {
            str.append(" sealed");
        }
        if ((attrs & 0x100000) != 0) {
            str.append(" beforefieldinit");
        }
        if ((attrs & 0x2000) != 0) {
            str.append(" serializable");
        }
        if ((attrs & 0x400) != 0) {
            str.append(" specialname");
        }
        if ((attrs & 0x800) != 0) {
            str.append(" rtspecialname");
        }
        return str.toString();
    }

    public static final boolean isNested(int attrs) {
        switch (attrs & 7) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    private TypeAttributes() {
    }
}

