/*
 * Decompiled with CFR 0.152.
 */
package vizant;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import vizant.VizASType;
import vizant.VizAttr;
import vizant.VizAttrStmt;
import vizant.VizProject;
import vizant.VizReference;
import vizant.VizTarget;
import vizant.VizWriter;

public class VizPrinter {
    private Vector projects = new Vector();
    private Hashtable attrMap = this.getDefaultAttrMap();
    private Hashtable subgraphAttrMap = new Hashtable();
    private VizWriter out;
    private String graphid = "G";
    private boolean noCluster = false;
    private String targetFrom = "";
    private String targetTo = "";
    private IDTable idtable;
    private int indentLevel = 0;
    private final String indent;

    public VizPrinter() {
        this.indent = "    ";
    }

    private Hashtable getDefaultAttrMap() {
        Hashtable<VizASType, VizAttrStmt> hashtable = new Hashtable<VizASType, VizAttrStmt>();
        VizAttrStmt vizAttrStmt = new VizAttrStmt();
        vizAttrStmt.setType("graph");
        vizAttrStmt.addAttribute("rankdir", "LR");
        hashtable.put(vizAttrStmt.getType(), vizAttrStmt);
        return hashtable;
    }

    public void addProject(VizProject vizProject) {
        this.projects.addElement(vizProject);
    }

    public void setGraphid(String string) {
        this.graphid = string;
    }

    public void setNocluster(boolean bl) {
        this.noCluster = bl;
    }

    public void setFrom(String string) {
        this.targetFrom = string;
    }

    public void setTo(String string) {
        this.targetTo = string;
    }

    public void setWriter(VizWriter vizWriter) {
        this.out = vizWriter;
    }

    public void printIndent() {
        int n = 0;
        while (n < this.indentLevel) {
            this.out.print(this.indent);
            ++n;
        }
    }

    public void print(String string) {
        this.printIndent();
        this.out.print(string);
    }

    public void println(String string) {
        this.printIndent();
        this.out.println(string);
    }

    public void addAttributeStatement(VizAttrStmt vizAttrStmt) {
        this.addAttributeStatement(this.attrMap, vizAttrStmt);
    }

    public void addSubgraphAttributeStatement(VizAttrStmt vizAttrStmt) {
        this.addAttributeStatement(this.subgraphAttrMap, vizAttrStmt);
    }

    protected void addAttributeStatement(Hashtable hashtable, VizAttrStmt vizAttrStmt) {
        VizASType vizASType = vizAttrStmt.getType();
        VizAttrStmt vizAttrStmt2 = (VizAttrStmt)hashtable.get(vizASType);
        if (vizAttrStmt2 == null) {
            hashtable.put(vizASType, vizAttrStmt);
        } else {
            vizAttrStmt2.addAttribute(vizAttrStmt);
        }
    }

    private String escapeId(String string) {
        string = this.replace(string, "\\", "\\\\");
        string = this.replace(string, "\"", "\\\"");
        return string;
    }

    private String getQuotedId(String string) {
        return "\"" + this.escapeId(string) + "\"";
    }

    public void printAttrStmt(VizAttrStmt vizAttrStmt) {
        this.out.print(" [");
        Enumeration enumeration = vizAttrStmt.getAttributes();
        while (enumeration.hasMoreElements()) {
            VizAttr vizAttr = (VizAttr)enumeration.nextElement();
            this.out.print(this.getQuotedId(vizAttr.getName()) + "=\"" + vizAttr.getValue() + "\",");
        }
        this.out.print("]");
    }

    public boolean printAttrIfExists(Hashtable hashtable, VizASType vizASType) {
        if (hashtable.get(vizASType) != null) {
            this.printAttrStmt((VizAttrStmt)hashtable.get(vizASType));
            return true;
        }
        return false;
    }

    private void filterReferences() {
        VizTarget vizTarget;
        Vector vector;
        if (!"".equals(this.targetFrom)) {
            vector = new Vector();
            vizTarget = ((VizProject)this.projects.elementAt(0)).getTarget(this.targetFrom);
            if (vizTarget != null) {
                this.addReferredTargets(vizTarget, vector, false);
            }
            this.eraseNotContainsTargets(vector);
        }
        if (!"".equals(this.targetTo)) {
            vector = new Vector();
            vizTarget = ((VizProject)this.projects.elementAt(0)).getTarget(this.targetTo);
            if (vizTarget != null) {
                this.addReferredTargets(vizTarget, vector, true);
            }
            this.eraseNotContainsTargets(vector);
            this.filterReferences(vector);
        }
    }

    private void filterReferences(Vector vector) {
        Enumeration enumeration = this.projects.elements();
        while (enumeration.hasMoreElements()) {
            Enumeration enumeration2 = ((VizProject)enumeration.nextElement()).getOrderedTargets().elements();
            while (enumeration2.hasMoreElements()) {
                VizTarget vizTarget = (VizTarget)enumeration2.nextElement();
                vizTarget.filterReferences(vector);
            }
        }
    }

    private void eraseNotContainsTargets(Vector vector) {
        Vector<VizProject> vector2 = new Vector<VizProject>();
        Enumeration enumeration = this.projects.elements();
        while (enumeration.hasMoreElements()) {
            VizProject vizProject = (VizProject)enumeration.nextElement();
            VizProject vizProject2 = new VizProject();
            vizProject.copyAttributes(vizProject2);
            Enumeration enumeration2 = vizProject.getOrderedTargets().elements();
            while (enumeration2.hasMoreElements()) {
                VizTarget vizTarget = (VizTarget)enumeration2.nextElement();
                if (!vector.contains(vizTarget)) continue;
                vizTarget.setProject(vizProject2);
                vizProject2.appendTarget(vizTarget);
            }
            vector2.addElement(vizProject2);
        }
        this.projects = vector2;
    }

    private void addReferredTargets(VizTarget vizTarget, Vector vector, boolean bl) {
        if (vector.contains(vizTarget)) {
            return;
        }
        vector.addElement(vizTarget);
        Vector vector2 = bl ? vizTarget.getReferencesIn() : vizTarget.getReferencesOut();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            VizReference vizReference = (VizReference)enumeration.nextElement();
            VizTarget vizTarget2 = bl ? vizReference.getFrom() : vizReference.getTo();
            this.addReferredTargets(vizTarget2, vector, bl);
        }
    }

    protected void printBaseAttributes(Hashtable hashtable) {
        this.printAttributeStatement(hashtable, VizASType.GRAPH);
        this.printAttributeStatement(hashtable, VizASType.NODE);
        this.printAttributeStatement(hashtable, VizASType.EDGE);
    }

    public void printAttributeStatement(Hashtable hashtable, VizASType vizASType) {
        if (hashtable.get(vizASType) != null) {
            this.print(vizASType.getType());
            this.printAttrIfExists(hashtable, vizASType);
            this.out.println(";");
        }
    }

    public void printDefaultNodeAttributes(boolean bl) {
        if (bl && this.printAttrIfExists(this.subgraphAttrMap, VizASType.NODE_DEFAULT)) {
            return;
        }
        this.printAttrIfExists(this.attrMap, VizASType.NODE_DEFAULT);
    }

    public IDTable createIDTable(Vector vector) {
        return new IDTable(vector);
    }

    public void print() {
        this.filterReferences();
        this.idtable = this.createIDTable(this.projects);
        this.out.println("digraph " + this.getQuotedId(this.graphid) + " {");
        ++this.indentLevel;
        this.printBaseAttributes(this.attrMap);
        int n = 0;
        Vector vector = new Vector();
        Enumeration enumeration = this.projects.elements();
        while (enumeration.hasMoreElements()) {
            this.printProject((VizProject)enumeration.nextElement(), vector, n);
            ++n;
        }
        this.printClusterRefs(vector);
        --this.indentLevel;
        this.out.println("}");
    }

    private void printProject(VizProject vizProject, Vector vector, int n) {
        if (0 < n) {
            this.println("subgraph \"" + (this.noCluster ? "" : "cluster:") + n + "\" {");
            ++this.indentLevel;
            this.println("\"label\"=" + this.getQuotedId(vizProject.getDir() + " " + vizProject.getFile()) + ";");
            this.printBaseAttributes(this.subgraphAttrMap);
        }
        Enumeration enumeration = vizProject.getOrderedTargets().elements();
        while (enumeration.hasMoreElements()) {
            this.printTarget((VizTarget)enumeration.nextElement(), vizProject, vector, 0 < n);
        }
        if (0 < n) {
            --this.indentLevel;
            this.println("}");
        }
    }

    private void printTarget(VizTarget vizTarget, VizProject vizProject, Vector vector, boolean bl) {
        String string = this.idtable.getId(vizTarget);
        this.print(this.getQuotedId(string));
        String string2 = vizTarget.getId();
        String string3 = string2 = "".equals(string2) ? "(default)" : string2;
        if (bl && this.noCluster) {
            string2 = this.escapeId(vizProject.getDir() + " " + vizProject.getFile()) + "\\n" + this.escapeId(string2);
            this.out.print(" [\"label\"=\"" + string2 + "\"]");
        } else if (!string.equals(string2)) {
            this.out.print(" [\"label\"=" + this.getQuotedId(string2) + "]");
        }
        if (vizTarget.isDefault()) {
            this.printDefaultNodeAttributes(bl);
        }
        this.out.println(";");
        Enumeration enumeration = vizTarget.getReferencesOut().elements();
        while (enumeration.hasMoreElements()) {
            VizReference vizReference = (VizReference)enumeration.nextElement();
            if (vizReference.getType() == 2) {
                vector.addElement(vizReference);
                continue;
            }
            String string4 = this.idtable.getId(vizReference.getTo());
            this.print(this.getQuotedId(string) + " -> " + this.getQuotedId(string4));
            if (vizReference.getType() == 0) {
                this.printAttrIfExists(this.attrMap, VizASType.EDGE_DEPENDS);
            } else if (vizReference.getType() == 1) {
                this.printAttrIfExists(this.attrMap, VizASType.EDGE_ANTCALL);
            }
            this.out.println(";");
        }
    }

    private void printClusterRefs(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            VizReference vizReference = (VizReference)enumeration.nextElement();
            String string = this.idtable.getId(vizReference.getFrom());
            String string2 = this.idtable.getId(vizReference.getTo());
            this.print(this.getQuotedId(string) + " -> " + this.getQuotedId(string2));
            this.printAttrIfExists(this.attrMap, VizASType.EDGE_ANT);
            this.out.println(";");
        }
    }

    private String replace(String string, String string2, String string3) {
        if (string.length() == 0) {
            return "";
        }
        if (string2.length() == 0) {
            return string;
        }
        int n = 0;
        int n2 = -1;
        int n3 = string2.length();
        StringBuffer stringBuffer = new StringBuffer(string.length());
        while ((n2 = string.indexOf(string2, n)) != -1) {
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append(string3);
            n = n2 + n3;
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public class IDTable {
        private Hashtable ids;

        public IDTable(Vector vector) {
            this.ids = this.getIdTable(vector);
        }

        public String getId(VizTarget vizTarget) {
            return (String)this.ids.get(vizTarget);
        }

        public String toString() {
            return this.ids.toString();
        }

        private Hashtable getIdTable(Vector vector) {
            Hashtable<VizTarget, String> hashtable = new Hashtable<VizTarget, String>();
            Vector<String> vector2 = new Vector<String>();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                VizProject vizProject = (VizProject)enumeration.nextElement();
                Vector vector3 = vizProject.getOrderedTargets();
                Enumeration enumeration2 = vector3.elements();
                while (enumeration2.hasMoreElements()) {
                    VizTarget vizTarget = (VizTarget)enumeration2.nextElement();
                    String string = vizTarget.getId();
                    String string2 = string = "".equals(string) ? "(default)" : string;
                    int n = 0;
                    while (vector2.contains(string2)) {
                        string2 = string + "-" + ++n;
                    }
                    vector2.addElement(string2);
                    hashtable.put(vizTarget, string2);
                }
            }
            return hashtable;
        }
    }
}

