/*
 * Decompiled with CFR 0.152.
 */
package scala.xml.persistent;

import java.io.File;
import java.io.FileOutputStream;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.rmi.RemoteException;
import scala.Iterator;
import scala.Iterator$;
import scala.Predef$;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.StringBuilder;
import scala.io.Source;
import scala.io.Source$;
import scala.runtime.BoxesRunTime;
import scala.util.logging.Logged;
import scala.util.logging.Logged$class;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.TopScope$;
import scala.xml.XML$;
import scala.xml.parsing.ConstructingParser$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CachedFileStorage
extends Thread
implements Logged,
ScalaObject {
    private final int interval;
    private boolean dirty;
    private File theFile;
    private final File file2;
    private final File file1;

    public CachedFileStorage(File file1) {
        this.file1 = file1;
        Logged$class.$init$(this);
        this.file2 = new File(file1.getParent(), new StringBuilder().append((Object)file1.getName()).append((Object)"$").toString());
        this.theFile = null;
        this.dirty = false;
        this.interval = 1000;
    }

    private final /* synthetic */ boolean gd1$1() {
        return this.file1().lastModified() < this.file2().lastModified();
    }

    public void flush() {
        this.dirty_$eq(true);
        this.save();
    }

    @Override
    public void run() {
        this.log(new StringBuilder().append((Object)"[run]\nstarting storage thread, checking every ").append(BoxesRunTime.boxToInteger(this.interval())).append((Object)" ms").toString());
        while (true) {
            Thread.sleep(Predef$.MODULE$.int2long(this.interval()));
            this.save();
        }
    }

    private void save() {
        if (this.dirty()) {
            this.log(new StringBuilder().append((Object)"[save]\ndeleting ").append(this.theFile()).toString());
            this.theFile().delete();
            this.log(new StringBuilder().append((Object)"creating new ").append(this.theFile()).toString());
            this.theFile().createNewFile();
            FileOutputStream fos = new FileOutputStream(this.theFile());
            FileChannel c = fos.getChannel();
            TopScope$ topScope$ = Predef$.MODULE$.$scope();
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus(this.nodes().toList());
            Elem storageNode = new Elem(null, "nodes", Null$.MODULE$, topScope$, $buf);
            Writer w = Channels.newWriter((WritableByteChannel)c, "utf-8");
            XML$.MODULE$.write(w, storageNode, "utf-8", true, null);
            this.log(new StringBuilder().append((Object)"writing to ").append(this.theFile()).toString());
            w.close();
            c.close();
            fos.close();
            this.dirty_$eq(false);
            this.switch();
            this.log("[save done]");
        }
    }

    private Iterator<Node> load() {
        this.log(new StringBuilder().append((Object)"[load]\nloading ").append(this.theFile()).toString());
        Source src = Source$.MODULE$.fromFile(this.theFile());
        this.log(new StringBuilder().append((Object)"parsing ").append(this.theFile()).toString());
        Node res = ConstructingParser$.MODULE$.fromSource(src, false).document().docElem().apply(0);
        this.switch();
        this.log("[load done]");
        return res.child().elements();
    }

    public abstract void $minus$eq(Node var1);

    public abstract void $plus$eq(Node var1);

    public abstract Iterator<Node> nodes();

    /*
     * Enabled aggressive block sorting
     */
    public Iterator<Node> initialNodes() {
        Iterator<Node> iterator;
        boolean bl = this.file1().exists();
        boolean bl2 = this.file2().exists();
        if (!bl) {
            if (!bl2) {
                this.theFile_$eq(this.file1());
                iterator = (Iterator<Node>)Iterator$.MODULE$.empty();
                return iterator;
            }
        } else if (bl) {
            if (bl2 && this.gd1$1()) {
                this.theFile_$eq(this.file2());
                iterator = this.load();
                return iterator;
            }
            this.theFile_$eq(this.file1());
            iterator = this.load();
            return iterator;
        }
        this.theFile_$eq(this.file2());
        iterator = this.load();
        return iterator;
    }

    public int interval() {
        return this.interval;
    }

    public void dirty_$eq(boolean x$1) {
        this.dirty = x$1;
    }

    public boolean dirty() {
        return this.dirty;
    }

    private void switch() {
        File file = this.theFile();
        File file2 = this.file1();
        this.theFile_$eq(!(file != null ? !((Object)file).equals(file2) : file2 != null) ? this.file2() : this.file1());
    }

    private void theFile_$eq(File x$1) {
        this.theFile = x$1;
    }

    private File theFile() {
        return this.theFile;
    }

    private File file2() {
        return this.file2;
    }

    private File file1() {
        return this.file1;
    }

    @Override
    public int $tag() throws RemoteException {
        return ScalaObject$class.$tag(this);
    }

    @Override
    public void log(String x$1) {
        Logged$class.log(this, x$1);
    }
}

