/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldc.io.j2me.socket;

import com.sun.cldc.io.GeneralBase;
import com.sun.cldc.io.j2me.socket.Protocol;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

class PrivateInputStream
extends InputStream {
    protected Protocol parent;
    boolean eof = false;
    byte[] bytebuf;

    public PrivateInputStream(Protocol parent) throws IOException {
        this.parent = parent;
    }

    void ensureOpen() throws IOException {
        if (this.parent == null) {
            throw new IOException("Stream closed");
        }
    }

    public synchronized int read() throws IOException {
        int res;
        if (this.bytebuf == null) {
            this.bytebuf = new byte[1];
        }
        if ((res = this.read(this.bytebuf, 0, 1)) == 1) {
            return this.bytebuf[0] & 0xFF;
        }
        return res;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        if (this.eof) {
            return -1;
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (len == 0) {
            return 0;
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        while (true) {
            int count = this.read1(b, off, len);
            if (this.parent == null) {
                throw new InterruptedIOException();
            }
            if (count != 0) {
                if (count < 0) {
                    this.eof = true;
                }
                return count;
            }
            GeneralBase.iowait();
        }
    }

    protected int read1(byte[] b, int off, int len) throws IOException {
        if (this.parent != null) {
            return this.parent.read0(b, off, len);
        }
        return -1;
    }

    public synchronized int available() throws IOException {
        this.ensureOpen();
        return this.parent.available0();
    }

    public void close() throws IOException {
        if (this.parent != null) {
            this.ensureOpen();
            this.parent.realClose();
            this.parent.isopen = false;
            this.parent = null;
        }
    }
}

