/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import com.sun.midp.lcdui.Resource;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.TextField;

class TextEditor
extends TextBox
implements CommandListener {
    private boolean wasTyped;
    private int firstChar;
    private int savedNumChars;
    private char[] savedBuffer;
    private Screen returnScreen;
    private TextField textField;
    private static final Command BACK = new Command(Resource.getString("Back"), 3, 1);
    private static final Command SAVE = new Command(Resource.getString("Save"), 4, 1);

    TextEditor() {
        super(null, null, -1, -1);
        super.addCommandImpl(BACK);
        super.addCommandImpl(SAVE);
        super.setCommandListener(this);
    }

    void initializeTextBasic(int constraints, int maxSize, String text) {
    }

    boolean isEditScreen(Displayable d) {
        return d == this.returnScreen;
    }

    void invoke(Screen returnScreen, TextField textField, int keycode, boolean wasTyped) {
        this.firstChar = keycode;
        this.wasTyped = wasTyped;
        this.returnScreen = returnScreen;
        this.textField = textField;
        this.sD = textField.sD;
        this.setChild(this.sD.policy.height);
        this.setTitle(textField.getLabel());
        this.savedNumChars = this.sD.numChars;
        if (this.savedBuffer == null || this.savedBuffer.length < this.savedNumChars) {
            this.savedBuffer = new char[this.savedNumChars];
        }
        System.arraycopy(this.sD.buffer, 0, this.savedBuffer, 0, this.savedNumChars);
        returnScreen.currentDisplay.setCurrent(this);
    }

    public void commandAction(Command x, Displayable s) {
        Form form = null;
        TextField field = null;
        ItemStateListener isl = null;
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (x == SAVE) {
                field = this.textField;
                field.saveHeight(this.sD.policy.height);
                form = (Form)field.getOwner();
                isl = form.getItemStateListener();
            } else if (x == BACK) {
                this.sD.setChars(this.savedBuffer, 0, this.savedNumChars);
            }
            s.currentDisplay.setCurrent(this.returnScreen);
        }
        if (form != null) {
            Form.itemStateChanged(field, isl);
        }
    }

    Object getClientObject() {
        return this.textField;
    }

    void showNotifyImpl(Display d) {
        super.showNotifyImpl(d);
        if (this.firstChar != 0) {
            if (this.wasTyped) {
                this.keyTypedImpl((char)this.firstChar);
            } else {
                this.keyPressedImpl(this.firstChar);
            }
            this.firstChar = 0;
        }
    }
}

