/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kssl;

import com.sun.ksecurity.CryptoException;
import com.sun.ksecurity.Key;
import com.sun.ksecurity.MessageDigest;
import com.sun.kssl.Cipher;
import com.sun.kssl.Signature;

final class RSASig
extends Signature {
    byte alg;
    MessageDigest md = null;
    byte mode = 0;
    Key k = null;
    private static final byte[] PREFIX_MD5 = new byte[]{48, 32, 48, 12, 6, 8, 42, -122, 72, -122, -9, 13, 2, 5, 5, 0, 4, 16};
    private static final byte[] PREFIX_SHA1 = new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20};

    RSASig(byte a) {
        this.alg = a;
        try {
            if (this.alg == 1) {
                this.md = MessageDigest.getInstance((byte)1, false);
            } else if (this.alg == 2) {
                this.md = MessageDigest.getInstance((byte)2, false);
            }
        }
        catch (Exception e) {
            this.md = null;
        }
    }

    public byte getAlgorithm() {
        return this.alg;
    }

    public short getLength() {
        if (this.k == null) {
            return 0;
        }
        return (short)(this.k.getSize() >>> 3);
    }

    public void init(Key theKey, byte theMode) throws CryptoException {
        if (!(theMode == 1 && theKey.getType() == 2 || theMode == 2 && theKey.getType() == 1)) {
            throw new CryptoException(2);
        }
        this.k = theKey;
        this.mode = theMode;
    }

    public void init(Key theKey, byte theMode, byte[] b, int off, int len) throws CryptoException {
        throw new CryptoException(2);
    }

    public void update(byte[] inBuf, int inOff, int inLen) throws CryptoException {
        if (this.k == null) {
            throw new CryptoException(5);
        }
        if (this.md == null || this.mode != 1 && this.mode != 2) {
            throw new CryptoException(3);
        }
        this.md.update(inBuf, inOff, inLen);
    }

    public short sign(byte[] inBuf, int inOff, int inLen, byte[] sigBuf, int sigOff) throws CryptoException {
        if (this.k == null) {
            throw new CryptoException(5);
        }
        if (this.md == null || this.mode != 1) {
            throw new CryptoException(3);
        }
        byte[] prefix = null;
        prefix = this.alg == 1 ? PREFIX_MD5 : PREFIX_SHA1;
        byte[] data = new byte[prefix.length + this.md.getLength()];
        System.arraycopy(prefix, 0, data, 0, prefix.length);
        this.md.doFinal(inBuf, inOff, inLen, data, prefix.length);
        Cipher c = Cipher.getInstance((byte)2, false);
        c.init(this.k, (byte)1);
        return (short)c.doFinal(data, 0, data.length, sigBuf, sigOff);
    }

    public boolean verify(byte[] inBuf, int inOff, int inLen, byte[] sigBuf, int sigOff, short sigLen) throws CryptoException {
        int val;
        if (this.k == null) {
            throw new CryptoException(5);
        }
        if (this.md == null || this.mode != 2) {
            throw new CryptoException(3);
        }
        byte[] res = null;
        byte[] digest = new byte[this.md.getLength()];
        this.md.doFinal(inBuf, inOff, inLen, digest, 0);
        try {
            Cipher c = Cipher.getInstance((byte)2, false);
            c.init(this.k, (byte)2);
            res = new byte[this.k.getSize() >>> 3];
            val = c.doFinal(sigBuf, sigOff, sigLen, res, 0);
        }
        catch (Exception e) {
            return false;
        }
        byte[] prefix = null;
        int size = 0;
        if (this.alg == 1) {
            prefix = PREFIX_MD5;
            size = prefix.length + 16;
        } else {
            prefix = PREFIX_SHA1;
            size = prefix.length + 20;
        }
        if (val != size) {
            return false;
        }
        int i = 0;
        while (i < prefix.length) {
            if (res[i] != prefix[i]) {
                return false;
            }
            ++i;
        }
        int i2 = prefix.length;
        while (i2 < size) {
            if (res[i2] != digest[i2 - prefix.length]) {
                return false;
            }
            ++i2;
        }
        return true;
    }
}

