/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.CharsetDecoder;
import java.rmi.RemoteException;
import scala.ScalaObject;
import scala.StringBuilder;
import scala.tools.nsc.io.AbstractFile;
import scala.tools.nsc.io.PlainFile;
import scala.tools.nsc.io.SourceReader$;
import scala.tools.nsc.io.ZipArchive;
import scala.tools.nsc.reporters.Reporter;
import scala.tools.nsc.util.NoPosition$;

public class SourceReader
implements ScalaObject {
    private CharBuffer chars;
    private final ByteBuffer bytes;
    private final Reporter reporter;
    private final CharsetDecoder decoder;

    public SourceReader(CharsetDecoder decoder, Reporter reporter) {
        this.decoder = decoder;
        this.reporter = reporter;
        this.bytes = ByteBuffer.allocate(16384);
        this.chars = CharBuffer.allocate(16384);
    }

    /*
     * WARNING - void declaration
     */
    private char[] terminate(CharBuffer chars) {
        void var2_2;
        char[] result = new char[chars.length()];
        chars.get(result);
        this.chars_$eq(chars);
        return var2_2;
    }

    public char[] read(ReadableByteChannel input) {
        CharsetDecoder decoder = this.decoder.reset();
        ByteBuffer bytes = this.bytes();
        bytes.clear();
        CharBuffer chars = this.chars();
        chars.clear();
        boolean endOfInput = false;
        while (!endOfInput) {
            endOfInput = input.read(bytes) < 0;
            bytes.flip();
            chars = SourceReader$.MODULE$.decode(decoder, bytes, chars, endOfInput);
        }
        return this.terminate(SourceReader$.MODULE$.flush(decoder, chars));
    }

    public char[] read(AbstractFile file) {
        block4: {
            char[] cArray;
            block3: {
                ZipArchive.FileEntry fileEntry;
                AbstractFile abstractFile;
                block2: {
                    abstractFile = file;
                    if (!(abstractFile instanceof PlainFile)) break block2;
                    cArray = this.read(((PlainFile)abstractFile).file());
                    break block3;
                }
                if (!(abstractFile instanceof ZipArchive.FileEntry)) break block4;
                ZipArchive.FileEntry z = fileEntry = (ZipArchive.FileEntry)abstractFile;
                ReadableByteChannel c = Channels.newChannel(z.getArchive().getInputStream(z.entry()));
                cArray = this.read(c);
            }
            return cArray;
        }
        throw new IOException(new StringBuilder().append((Object)file.toString()).append((Object)" is neither plain file nor ZipArchive#FileEntry").toString());
    }

    public char[] read(File file) {
        FileChannel c = new FileInputStream(file).getChannel();
        char[] exceptionResult1 = null;
        try {
            try {
                exceptionResult1 = this.read(c);
                c.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.reportEncodingError(file.toString());
                exceptionResult1 = new char[]{};
                c.close();
            }
            return exceptionResult1;
        }
        catch (Throwable throwable) {
            c.close();
            throw throwable;
        }
    }

    public char[] read(String filename) {
        return this.read(new File(filename));
    }

    private void reportEncodingError(String filename) {
        this.reporter.error(NoPosition$.MODULE$, new StringBuilder().append((Object)"IO error while decoding ").append((Object)filename).append((Object)" with ").append((Object)this.decoder.charset()).append((Object)"\n").append((Object)"Please try specifying another one using the -encoding option").toString());
    }

    private void chars_$eq(CharBuffer x$1) {
        this.chars = x$1;
    }

    private CharBuffer chars() {
        return this.chars;
    }

    private ByteBuffer bytes() {
        return this.bytes;
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

