/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.rmi.RemoteException;
import java.security.SecureRandom;
import java.util.regex.Pattern;
import scala.Function1;
import scala.Function2;
import scala.List;
import scala.List$;
import scala.MatchError;
import scala.Nil$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Seq;
import scala.Some;
import scala.StringBuilder;
import scala.Tuple2;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.tools.nsc.CompileClient$;
import scala.tools.nsc.CompileSocket$;
import scala.tools.nsc.Properties$;
import scala.tools.nsc.StandardCompileClient;

public class CompileSocket
implements ScalaObject {
    private final int sleepTime;
    private final int MaxAttempts;
    private final File portsDir;
    private final File tmpDir;
    private final Pattern errorPattern;
    private final String errorRegex;
    private final String serverClass;
    private final String vmCommand;

    public CompileSocket() {
        String dirname;
        File trial;
        String string = Properties$.MODULE$.scalaHome();
        this.vmCommand = string == null ? this.cmdName() : ((trial = new File(new File(dirname = string, "bin"), this.cmdName())).canRead() ? trial.getPath() : this.cmdName());
        this.serverClass = "scala.tools.nsc.CompileServer";
        this.errorRegex = ".*(errors? found|don't know|bad option).*";
        this.errorPattern = Pattern.compile(this.errorRegex());
        List totry = List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new Tuple2[]{new Tuple2((Object)"scala.home", (Object)List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new String[]{"var", "scala-devel"}))), new Tuple2((Object)"user.home", (Object)List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new String[]{"tmp"}))), new Tuple2((Object)"java.io.tmpdir", (Object)Nil$.MODULE$)}));
        List potentials = totry.map((Function1)new $anonfun$2(this)).filter((Function1)new $anonfun$3(this)).filter((Function1)new $anonfun$4(this)).map((Function1)new $anonfun$5(this));
        if (potentials.isEmpty()) {
            throw this.fatal("Could not find a directory for temporary files");
        }
        File d = (File)potentials.head();
        d.mkdirs();
        this.info(new StringBuilder().append((Object)"[Temp directory: ").append((Object)d).append((Object)"]").toString());
        this.tmpDir = d;
        this.portsDir = new File(this.tmpDir(), this.dirName());
        this.portsDir().mkdirs();
        this.MaxAttempts = 100;
        this.sleepTime = 20;
    }

    private final Socket getsock$1(int attempts, String string, boolean bl) {
        Socket socket;
        if (attempts == 0) {
            this.error("Unable to establish connection to compilation daemon");
            socket = null;
        } else {
            int port;
            int n = port = bl ? this.getPort(string) : this.pollPort();
            if (port < 0) {
                return null;
            }
            InetAddress hostAdr = InetAddress.getLocalHost();
            Socket exceptionResult4 = null;
            try {
                Socket result = new Socket(hostAdr, port);
                this.info(new StringBuilder().append((Object)"[Connected to compilation daemon at port ").append((Object)BoxesRunTime.boxToInteger((int)port)).append((Object)"]").toString());
                exceptionResult4 = result;
            }
            catch (Exception exception) {
                this.info(exception.toString());
                this.info(new StringBuilder().append((Object)"[Connecting to compilation daemon at port ").append((Object)BoxesRunTime.boxToInteger((int)port)).append((Object)" failed; re-trying...]").toString());
                if (attempts % 2 == 0) {
                    this.portFile(port).delete();
                }
                Thread.sleep(100L);
                exceptionResult4 = this.getsock$1(attempts - 1, string, bl);
            }
            socket = exceptionResult4;
        }
        return socket;
    }

    public final boolean isDirWritable$1(File f2) {
        f2.mkdirs();
        return f2.isDirectory() && f2.canWrite();
    }

    public final Option expand$1(Tuple2 trial) {
        Tuple2 tuple2 = trial;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
        String topdirProp = (String)tuple22._1();
        List extensions = (List)tuple22._2();
        String topdir = System.getProperty(topdirProp);
        if (topdir == null) {
            return None$.MODULE$;
        }
        File fulldir = (File)extensions.foldLeft((Object)new File(topdir), (Function2)new $anonfun$1(this));
        return new Some((Object)fulldir);
    }

    public String getPassword(int port) {
        File ff = this.portFile(port);
        BufferedReader f2 = new BufferedReader(new FileReader(ff));
        for (int retry = 50; ff.length() == 0L && retry > 0; --retry) {
            Thread.sleep(100L);
        }
        if (ff.length() == 0L) {
            ff.delete();
            throw this.fatal("Unable to establish connection to server.");
        }
        String result = f2.readLine();
        f2.close();
        return result;
    }

    public Socket getSocket(String hostName, int port) {
        Socket exceptionResult3 = null;
        try {
            exceptionResult3 = new Socket(hostName, port);
            return exceptionResult3;
        }
        catch (Exception exception) {
            throw this.fatal(new StringBuilder().append((Object)"Unable to establish connection to server ").append((Object)hostName).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)port)).append((Object)"; exiting").toString());
        }
    }

    public Socket getSocket(String serverAdr) {
        int cpos = serverAdr.indexOf(58);
        if (cpos < 0) {
            throw this.fatal(new StringBuilder().append((Object)"Malformed server address: ").append((Object)serverAdr).append((Object)"; exiting").toString());
        }
        String hostName = serverAdr.substring(0, cpos);
        int exceptionResult2 = 0;
        try {
            int port = exceptionResult2 = Predef$.MODULE$.stringWrapper(serverAdr.substring(cpos + 1)).toInt();
            return this.getSocket(hostName, port);
        }
        catch (Throwable throwable) {
            throw this.fatal(new StringBuilder().append((Object)"Malformed server address: ").append((Object)serverAdr).append((Object)"; exiting").toString());
        }
    }

    public Socket getOrCreateSocket(String vmArgs) {
        return this.getOrCreateSocket(vmArgs, true);
    }

    public Socket getOrCreateSocket(String vmArgs$1, boolean create$1) {
        int nAttempts = 49;
        return this.getsock$1(nAttempts, vmArgs$1, create$1);
    }

    public void deletePort(int port) {
        this.portFile(port).delete();
    }

    public void setPort(int port) {
        try {
            PrintWriter f2 = new PrintWriter(new FileOutputStream(this.portFile(port)));
            f2.println(((Object)BoxesRunTime.boxToInteger((int)new SecureRandom().nextInt())).toString());
            f2.close();
            return;
        }
        catch (Exception exception) {
            throw this.fatal(new StringBuilder().append((Object)"Cannot create file: ").append((Object)this.portFile(port).getAbsolutePath()).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public int getPort(String vmArgs) {
        void var3_3;
        int attempts = 0;
        int port = this.pollPort();
        if (port < 0) {
            this.startNewServer(vmArgs);
        }
        while (port < 0 && attempts < this.MaxAttempts()) {
            ++attempts;
            Thread.sleep(Predef$.MODULE$.int2long(this.sleepTime()));
            port = this.pollPort();
        }
        this.info(new StringBuilder().append((Object)"[Port number: ").append((Object)BoxesRunTime.boxToInteger((int)port)).append((Object)"]").toString());
        if (port < 0) {
            throw this.fatal("Could not connect to compilation daemon.");
        }
        return (int)var3_3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int pollPort() {
        int n;
        File[] hits$1 = this.portsDir().listFiles();
        if (hits$1.length == 0) {
            return -1;
        }
        int exceptionResult1 = 0;
        try {
            Predef$.MODULE$.intWrapper(1).until(hits$1.length).foreach((Function1)new $anonfun$pollPort$1(this, hits$1));
            n = exceptionResult1 = Predef$.MODULE$.stringWrapper(hits$1[0].getName()).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            throw this.fatal(new StringBuilder().append((Object)numberFormatException.toString()).append((Object)"\nbad file in temp directory: ").append((Object)hits$1[0].getAbsolutePath()).append((Object)"\nplease remove the file and try again").toString());
        }
        return n;
    }

    public File portFile(int port) {
        return new File(this.portsDir(), ((Object)BoxesRunTime.boxToInteger((int)port)).toString());
    }

    private void startNewServer(String vmArgs) {
        String cmd = this.serverCommand(vmArgs);
        this.info(new StringBuilder().append((Object)"[Executed command: ").append((Object)cmd).append((Object)"]").toString());
        try {
            Runtime.getRuntime().exec(cmd);
            return;
        }
        catch (IOException iOException) {
            throw this.fatal(new StringBuilder().append((Object)"Cannot start compilation daemon.\ntried command: ").append((Object)cmd).toString());
        }
    }

    private String serverCommand(String vmArgs) {
        return new StringBuilder().append((Object)this.vmCommand()).append((Object)vmArgs).append((Object)" ").append((Object)this.serverClass()).toString();
    }

    private int sleepTime() {
        return this.sleepTime;
    }

    private int MaxAttempts() {
        return this.MaxAttempts;
    }

    public File portsDir() {
        return this.portsDir;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void info(String msg) {
        if (this.compileClient().verbose()) {
            System.out.println(msg);
        }
    }

    public Nothing$ fatal(String msg) {
        this.error(msg);
        throw new Exception("fsc failure");
    }

    public void error(String msg) {
        System.err.println(msg);
    }

    public Pattern errorPattern() {
        return this.errorPattern;
    }

    public String errorRegex() {
        return this.errorRegex;
    }

    public String serverClass() {
        return this.serverClass;
    }

    public String vmCommand() {
        return this.vmCommand;
    }

    public String cmdName() {
        return Properties$.MODULE$.cmdName();
    }

    public String dirName() {
        return "scalac-compile-server-port";
    }

    public StandardCompileClient compileClient() {
        return CompileClient$.MODULE$;
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

