/* the main program */

#define _MAIN_C

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <signal.h>

#include <unistd.h>
#include <getopt.h>
#include <errno.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <syslog.h>

#include "server.h"

static void init_signals (void);
static void usr2_handler (int);
static void usr1_handler (int);
static void chld_handler (int);
static void quit_handler (int);

int main (int argc, const char *argv[])
{
  int c, i, n;
  char *b;
  pid_t pid;

  int create_spool = 0;
  
  pkspxy_init_config ();

  Progname = argv[0];
  if ((b = strrchr (Progname, '/')))
    Progname = b + 1;

  openlog (Progname, LOG_PID, LOG_DAEMON);

  while ((c = getopt (argc, argv, "cdoF:")) != EOF)
  {
    switch (c)
    {
      case 'd': Debug++ ; break;
      case 'o': Online = 0; break;
      case 'c': create_spool = 1; break;
      case 'F': 
      {
	if (pkspxy_parse_config (optarg) == -1)
	  return 1;
	break;
      }
      default:
      {
	fprintf (stderr, "%s: Unknown command line parameter.\n", Progname);
	return 1;
      }
    }
  }

  if (create_spool)
  {
    if (pkspxy_create_spool () == -1)
      return 1;
  }
  
  if (!Keyservers)
  {
    fprintf (stderr, "%s: FATAL: No key servers defined.\n", Progname);
    return 1;
  }

  pkspxy_restore_postponed ();
  
  if (!Debug)
  {
    if ((pid = fork ()) < 0)
    {
      fprintf (stderr, "%s: FATAL: Can't fork (%s).", Progname, strerror (errno));
      return 1;
    }
    else if (pid > 0)
    {
      printf ("%d\n", pid);
      return 0;
    }

    /* else */
    
    n = getdtablesize ();
    for (i = 0; i < n; i++)
      close (i);
    
    /* create standard I/O channels */
    open ("/dev/null", O_RDWR);
    open ("/dev/null", O_RDWR);
    open ("/dev/null", O_RDWR);
    
    setsid ();
  }
  
  init_signals ();
  pkspxy_select_loop ();

  pkspxy_dump_postponed ();
  
  return 0;
}

static void init_signals (void)
{
  struct sigaction act;
  
  sigemptyset (&act.sa_mask);
  act.sa_flags = 0;

  act.sa_handler = usr1_handler;
  sigaction (SIGUSR1, &act, NULL);

  act.sa_handler = usr2_handler;
  sigaction (SIGUSR2, &act, NULL);
  
  act.sa_handler = chld_handler;
  sigaction (SIGCHLD, &act, NULL);
  
  act.sa_handler = quit_handler;
  
  sigaction (SIGQUIT, &act, NULL);
  sigaction (SIGINT, &act, NULL);
  sigaction (SIGTERM, &act, NULL);
}

static void usr1_handler (int sig)
{
  Online = 1;
  ForcePostponed = 1;
}

static void usr2_handler (int sig)
{
  Online = 0;
}

static void chld_handler (int sig)
{}

static void quit_handler (int sig)
{
  Signalled = 1;
}
