#ifndef __PYX_HAVE__petsc4py__PETSc
#define __PYX_HAVE__petsc4py__PETSc
#ifdef __cplusplus
#define __PYX_EXTERN_C extern "C"
#else
#define __PYX_EXTERN_C extern
#endif

/* "include/petsc4py/PETSc.pxd":66
 * # --------------------------------------------------------------------
 * 
 * ctypedef public api class Comm [             # <<<<<<<<<<<<<<
 *     type   PyPetscComm_Type,
 *     object PyPetscCommObject,
 */

struct PyPetscCommObject {
  PyObject_HEAD
  MPI_Comm comm;
  int isdup;
  PyObject *base;
};
typedef struct PyPetscCommObject PyPetscCommObject;

/* "include/petsc4py/PETSc.pxd":74
 *     cdef object base
 * 
 * ctypedef public api class Object [             # <<<<<<<<<<<<<<
 *     type   PyPetscObject_Type,
 *     object PyPetscObjectObject,
 */

struct PyPetscObjectObject {
  PyObject_HEAD
  struct __pyx_vtabstruct_8petsc4py_5PETSc_Object *__pyx_vtab;
  PetscObject oval;
  PetscObject *obj;
};
typedef struct PyPetscObjectObject PyPetscObjectObject;

/* "include/petsc4py/PETSc.pxd":87
 *     cdef object get_dict(self)
 * 
 * ctypedef public api class Viewer(Object) [             # <<<<<<<<<<<<<<
 *     type   PyPetscViewer_Type,
 *     object PyPetscViewerObject,
 */

struct PyPetscViewerObject {
  struct PyPetscObjectObject __pyx_base;
  PetscViewer vwr;
};
typedef struct PyPetscViewerObject PyPetscViewerObject;

/* "include/petsc4py/PETSc.pxd":93
 *     cdef PetscViewer vwr
 * 
 * ctypedef public api class Random(Object) [             # <<<<<<<<<<<<<<
 *     type   PyPetscRandom_Type,
 *     object PyPetscRandomObject,
 */

struct PyPetscRandomObject {
  struct PyPetscObjectObject __pyx_base;
  PetscRandom rnd;
};
typedef struct PyPetscRandomObject PyPetscRandomObject;

/* "include/petsc4py/PETSc.pxd":99
 *     cdef PetscRandom rnd
 * 
 * ctypedef public api class IS(Object) [             # <<<<<<<<<<<<<<
 *     type   PyPetscIS_Type,
 *     object PyPetscISObject,
 */

struct PyPetscISObject {
  struct PyPetscObjectObject __pyx_base;
  IS iset;
};
typedef struct PyPetscISObject PyPetscISObject;

/* "include/petsc4py/PETSc.pxd":105
 *     cdef PetscIS iset
 * 
 * ctypedef public api class LGMap(Object) [             # <<<<<<<<<<<<<<
 *     type   PyPetscLGMap_Type,
 *     object PyPetscLGMapObject,
 */

struct PyPetscLGMapObject {
  struct PyPetscObjectObject __pyx_base;
  ISLocalToGlobalMapping lgm;
};
typedef struct PyPetscLGMapObject PyPetscLGMapObject;

/* "include/petsc4py/PETSc.pxd":111
 *     cdef PetscLGMap lgm
 * 
 * ctypedef public api class Vec(Object) [             # <<<<<<<<<<<<<<
 *     type   PyPetscVec_Type,
 *     object PyPetscVecObject,
 */

struct PyPetscVecObject {
  struct PyPetscObjectObject __pyx_base;
  Vec vec;
};
typedef struct PyPetscVecObject PyPetscVecObject;

/* "include/petsc4py/PETSc.pxd":117
 *     cdef PetscVec vec
 * 
 * ctypedef public api class Scatter(Object) [             # <<<<<<<<<<<<<<
 *     type   PyPetscScatter_Type,
 *     object PyPetscScatterObject,
 */

struct PyPetscScatterObject {
  struct PyPetscObjectObject __pyx_base;
  VecScatter sct;
};
typedef struct PyPetscScatterObject PyPetscScatterObject;

/* "include/petsc4py/PETSc.pxd":123
 *     cdef PetscScatter sct
 * 
 * ctypedef public api class Mat(Object) [             # <<<<<<<<<<<<<<
 *     type   PyPetscMat_Type,
 *     object PyPetscMatObject,
 */

struct PyPetscMatObject {
  struct PyPetscObjectObject __pyx_base;
  Mat mat;
};
typedef struct PyPetscMatObject PyPetscMatObject;

/* "include/petsc4py/PETSc.pxd":129
 *     cdef PetscMat mat
 * 
 * ctypedef public api class NullSpace(Object) [             # <<<<<<<<<<<<<<
 *     type   PyPetscNullSpace_Type,
 *     object PyPetscNullSpaceObject,
 */

struct PyPetscNullSpaceObject {
  struct PyPetscObjectObject __pyx_base;
  MatNullSpace nsp;
};
typedef struct PyPetscNullSpaceObject PyPetscNullSpaceObject;

/* "include/petsc4py/PETSc.pxd":135
 *     cdef PetscNullSpace nsp
 * 
 * ctypedef public api class PC(Object) [             # <<<<<<<<<<<<<<
 *     type   PyPetscPC_Type,
 *     object PyPetscPCObject,
 */

struct PyPetscPCObject {
  struct PyPetscObjectObject __pyx_base;
  PC pc;
};
typedef struct PyPetscPCObject PyPetscPCObject;

/* "include/petsc4py/PETSc.pxd":141
 *     cdef PetscPC pc
 * 
 * ctypedef public api class KSP(Object) [             # <<<<<<<<<<<<<<
 *     type   PyPetscKSP_Type,
 *     object PyPetscKSPObject,
 */

struct PyPetscKSPObject {
  struct PyPetscObjectObject __pyx_base;
  KSP ksp;
};
typedef struct PyPetscKSPObject PyPetscKSPObject;

/* "include/petsc4py/PETSc.pxd":147
 *     cdef PetscKSP ksp
 * 
 * ctypedef public api class SNES(Object) [             # <<<<<<<<<<<<<<
 *     type   PyPetscSNES_Type,
 *     object PyPetscSNESObject,
 */

struct PyPetscSNESObject {
  struct PyPetscObjectObject __pyx_base;
  SNES snes;
};
typedef struct PyPetscSNESObject PyPetscSNESObject;

/* "include/petsc4py/PETSc.pxd":153
 *     cdef PetscSNES snes
 * 
 * ctypedef public api class TS(Object) [             # <<<<<<<<<<<<<<
 *     type   PyPetscTS_Type,
 *     object PyPetscTSObject,
 */

struct PyPetscTSObject {
  struct PyPetscObjectObject __pyx_base;
  TS ts;
};
typedef struct PyPetscTSObject PyPetscTSObject;

/* "include/petsc4py/PETSc.pxd":159
 *     cdef PetscTS ts
 * 
 * ctypedef public api class AO(Object) [             # <<<<<<<<<<<<<<
 *     type   PyPetscAO_Type,
 *     object PyPetscAOObject,
 */

struct PyPetscAOObject {
  struct PyPetscObjectObject __pyx_base;
  AO ao;
};
typedef struct PyPetscAOObject PyPetscAOObject;

/* "include/petsc4py/PETSc.pxd":165
 *     cdef PetscAO ao
 * 
 * ctypedef public api class DA(Object) [             # <<<<<<<<<<<<<<
 *     type   PyPetscDA_Type,
 *     object PyPetscDAObject,
 */

struct PyPetscDAObject {
  struct PyPetscObjectObject __pyx_base;
  DA da;
};
typedef struct PyPetscDAObject PyPetscDAObject;

#ifndef __PYX_HAVE_API__petsc4py__PETSc

__PYX_EXTERN_C DL_IMPORT(PyTypeObject) PyPetscComm_Type;
__PYX_EXTERN_C DL_IMPORT(PyTypeObject) PyPetscObject_Type;
__PYX_EXTERN_C DL_IMPORT(PyTypeObject) PyPetscViewer_Type;
__PYX_EXTERN_C DL_IMPORT(PyTypeObject) PyPetscRandom_Type;
__PYX_EXTERN_C DL_IMPORT(PyTypeObject) PyPetscIS_Type;
__PYX_EXTERN_C DL_IMPORT(PyTypeObject) PyPetscLGMap_Type;
__PYX_EXTERN_C DL_IMPORT(PyTypeObject) PyPetscVec_Type;
__PYX_EXTERN_C DL_IMPORT(PyTypeObject) PyPetscScatter_Type;
__PYX_EXTERN_C DL_IMPORT(PyTypeObject) PyPetscMat_Type;
__PYX_EXTERN_C DL_IMPORT(PyTypeObject) PyPetscNullSpace_Type;
__PYX_EXTERN_C DL_IMPORT(PyTypeObject) PyPetscPC_Type;
__PYX_EXTERN_C DL_IMPORT(PyTypeObject) PyPetscKSP_Type;
__PYX_EXTERN_C DL_IMPORT(PyTypeObject) PyPetscSNES_Type;
__PYX_EXTERN_C DL_IMPORT(PyTypeObject) PyPetscTS_Type;
__PYX_EXTERN_C DL_IMPORT(PyTypeObject) PyPetscAO_Type;
__PYX_EXTERN_C DL_IMPORT(PyTypeObject) PyPetscDA_Type;

#endif

PyMODINIT_FUNC initPETSc(void);

#endif
