//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: mstrip.h,v 1.4 2004/05/06 15:08:07 wschweer Exp $
//
//  (C) Copyright 2000-2004 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __MSTRIP_H__
#define __MSTRIP_H__

#include "strip.h"

class Slider;
class DoubleLabel;
class QDialog;
class Knob;
class QString;
class MidiTrack;
class QLabel;

//---------------------------------------------------------
//   MidiStrip
//---------------------------------------------------------

class MidiStrip : public Strip {
      Q_OBJECT

      Slider* slider;
      DoubleLabel* sl;
      QToolButton* route;

      struct KNOB {
            Knob* knob;
            DoubleLabel* dl;
            QLabel* lb;
            } controller[4];    // pan variation reverb chorus

      int volume;
      int variSend;
      int reverbSend;
      int chorusSend;
      int pan;
      bool inHeartBeat;

      void addKnob(int idx, const QString&, const QString&, const char*, bool);
      void ctrlChanged(int num, int val);

   private slots:
      void routeClicked();
      void setVolume(double);
      void setPan(double);
      void setChorusSend(double);
      void setVariSend(double);
      void setReverbSend(double);

   protected slots:
      virtual void heartBeat();

   public slots:
      virtual void songChanged(int);

   public:
      MidiStrip(QWidget* parent, MidiTrack*);
      };


#endif



