//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: ctrl.cpp,v 1.1 2003/11/28 21:19:07 wschweer Exp $
//
//    controller handling for mixer automation
//
//  (C) Copyright 2003 Werner Schweer (ws@seh.de)
//=========================================================


#include "globals.h"
#include "ctrl.h"
#include "xml.h"
// #include "audio.h"

//---------------------------------------------------------
//   CtrlList
//---------------------------------------------------------

CtrlList::CtrlList(int id)
      {
      _id      = id;
      _default = 0.0;
      _curVal  = 0.0;
      _mode    = INTERPOLATE;
      }

//---------------------------------------------------------
//   CtrlList
//---------------------------------------------------------

CtrlList::CtrlList()
      {
      _id      = 0;
      _default = 0.0;
      _curVal  = 0.0;
      _mode    = INTERPOLATE;
      }

//---------------------------------------------------------
//   value
//---------------------------------------------------------

float CtrlList::value(int frame)
      {
      if (!automation || empty()) {
            return _curVal;
            }
      ciCtrl i = upper_bound(frame);
      if (i == end()) {
            ciCtrl i = end();
            --i;
            const CtrlVal& val = i->second;
            _curVal = val.val;
            }
      else {
            int frame2 = i->second.frame;
            float val2 = i->second.val;
            int frame1;
            float val1;
            if (i == begin()) {
                  frame1 = 0;
                  val1   = _default;
                  }
            else {
                  --i;
                  frame1 = i->second.frame;
                  val1   = i->second.val;
                  }
            frame -= frame1;
            val2  -= val1;
            frame2 -= frame1;
            val1 += (frame * val2)/frame2;
            _curVal = val1;
            }
// printf("autoVal %d %f\n", frame, _curVal);
      return _curVal;
      }

//---------------------------------------------------------
//   add
//---------------------------------------------------------

void CtrlList::add(int frame, float val)
      {
// printf("add %d %f\n", frame, val);
      iCtrl e = find(frame);
      if (e != end())
            e->second.val = val;
      else
            insert(std::pair<const int, CtrlVal> (frame, CtrlVal(frame, val)));
      }

//---------------------------------------------------------
//   del
//---------------------------------------------------------

void CtrlList::del(int /* frame*/)
      {
      }

//---------------------------------------------------------
//   read
//---------------------------------------------------------

void CtrlList::read(Xml& xml)
      {
      for (;;) {
            Xml::Token token = xml.parse();
            const QString& tag = xml.s1();
            switch (token) {
                  case Xml::Error:
                  case Xml::End:
                        return;
                  case Xml::Attribut:
                        if (tag == "id")
                              _id = xml.s2().toInt();
                        else if (tag == "cur")
                              _curVal = xml.s2().toDouble();
                        else
                              printf("unknown tag %s\n", tag.latin1());
                        break;
                  case Xml::Text:
                        {
                        const char* s = tag.latin1();
                        int frame;
                        float val;

                        for (;;) {
                              char* endp;
                              while (*s == ' ' || *s == '\n')
                                    ++s;
                              if (*s == 0)
                                    break;
                              frame = strtol(s, &endp, 10);
                              s     = endp;
                              while (*s == ' ' || *s == '\n')
                                    ++s;
                              val = strtod(s, &endp);
                              add(frame, val);
                              s = endp;
// printf("added %d:%f <%s>\n", frame, val, s);
                              ++s;
                              }
                        }
                        break;
                  case Xml::TagEnd:
                        if (xml.s1() == "controller")
                              return;
                  default:
                        break;
                  }
            }
      }

//---------------------------------------------------------
//   add
//---------------------------------------------------------

void CtrlListList::add(CtrlList* vl)
      {
//      printf("CtrlListList(%p)::add(id=%d) size %d\n", this, vl->id(), size());
      insert(std::pair<const int, CtrlList*>(vl->id(), vl));
      }

