!MESSAGE
!MESSAGE Possible Targets:
!MESSAGE ALL [DEBUG=] - Build version.
!MESSAGE CLEAN - Delete Debug and Release directories
!MESSAGE
!MESSAGE VERSION2       - Compile for MuscleCard 2.0.0
!MESSAGE MUSCLECARD_INC - Path to MuscleCard includes
!MESSAGE MUSCLECARD_LIB - Path to MuscleCard link library (.lib)
!MESSAGE PTHREADS_INC   - Path to pthreads includes
!MESSAGE PTHREADS_LIB   - Path to pthreads library
!MESSAGE PTHREADS_NAME  - Name of pthreads library (without extension)
!MESSAGE PCSC_INC       - Path to PC/SC Lite includes
!MESSAGE FLEX           - Path including file name of the flex executable
!MESSAGE FLEX_INC       - Path to shipped flex includes
!MESSAGE BISON          - Path including file name of the bison executable
!MESSAGE

# replace with your path to the MuscleCard header files
# or specify on command line
MUSCLECARD_INC=$(PROGRAMFILES)\Muscle\MuscleCard\Includes

!IF !EXIST("$(MUSCLECARD_INC)")
!ERROR Your path to the header files for MuscleCard is wrong. \
Replace it in the Makefile or call nmake with MUSCLECARD_INC=<PATH_TO_MUSCLECARD_HEADERS>
!ENDIF

# replace with your path to the PC/SC Lite header files
# or specify on command line
PCSC_INC=$(PROGRAMFILES)\Muscle\MuscleCard\Includes

!IF !EXIST("$(PCSC_INC)")
!ERROR Your path to the header files for PC/SC Lite is wrong. \
Replace it in the Makefile or call nmake with PCSC_INC=<PATH_TO_PCSC_HEADERS>
!ENDIF

# replace with your path to the MuscleCard link library (.lib) file
# or specify on command line
MUSCLECARD_LIB=$(ProgramFiles)\Muscle\MuscleCard\Libraries

!IF !EXIST("$(MUSCLECARD_LIB)")
!ERROR Your path to the link library (.lib) file for MuscleCard is wrong. \
Replace it in the Makefile or call nmake with MUSCLECARD_LIB=<PATH_TO_MUSCLECARD_LIBS>
!ENDIF

# replace with your path to the Pthreads header files
# or specify on command line
PTHREADS_INC=$(PTHREADS)

!IF !EXIST("$(PTHREADS_INC)")
!ERROR Your path to the header files for Pthreads is wrong. \
Replace it in the Makefile or call nmake with PTHREADS_INC=<PATH_TO_PTHREADS_HEADERS>
!ENDIF

# replace with your path to the Pthreads library files
# or specify on command line
PTHREADS_LIB=$(PTHREADS)

!IF !EXIST("$(PTHREADS_LIB)")
!ERROR Your path to the library files for Pthreads is wrong. \
Replace it in the Makefile or call nmake with PTHREADS_LIB=<PATH_TO_PTHREADS_LIBS>
!ENDIF

# replace with your name of the Pthreads library
# or specify on command line
PTHREADS_NAME=pthreadVC

# replace with the location of your flex executable
# or specify at command line
FLEX=$(GNUWIN32)\bin\flex.exe

# replace with the location of the include directory of your flex distribution
# or specify it at command line
# A file called unistd.h is needed to compile C files generated by flex.
FLEX_INC=$(GNUWIN32)\include

!IF !EXIST($(FLEX_INC))
!ERROR Your path to the header file needed to compile C files generated by flex is wrong. \
A file called unistd.h is needed to compile C files generated by flex. \
Replace it in the Makefile or call nmake with FLEX_INC=<HEADERS_NEEDED_TO_COMPILE_FLEX_FILES>
!ENDIF

# replace with the location of your bison executable
# or specify at command line
BISON=$(GNUWIN32)\bin\bison.exe




# Directory name may not contain spaces
DEBUG_OUTDIR=Debug
# Directory name may not contain spaces
RELEASE_OUTDIR=Release

!IFNDEF DEBUG
OUTDIR=$(RELEASE_OUTDIR)
!ELSE
OUTDIR=$(DEBUG_OUTDIR)
!ENDIF

LINK32=link.exe
CPP=cl.exe

ALL : $(OUTDIR)\MuscleTools.exe

CLEAN :
	-@rd /S /Q $(DEBUG_OUTDIR)
	-@rd /S /Q $(RELEASE_OUTDIR)

$(OUTDIR) :
    -@mkdir $(OUTDIR)

LINK32_OBJS= \
	$(OUTDIR)\help.obj \
	$(OUTDIR)\muscleTool.obj \
	$(OUTDIR)\parser.obj \
	$(OUTDIR)\scanner.obj




!IFNDEF DEBUG

!IFDEF VERSION2
CPP_PROJ=/nologo /MD /W3 /GX /O2 /I "$(MUSCLECARD_INC)" /I "$(PCSC_INC)" /I "$(PTHREADS_INC)" \
/D "WIN32" /D "NDEBUG" /D "VERSION2" /D "_CONSOLE" /D "_MBCS" /Fo"$(OUTDIR)\\" /Fd"$(OUTDIR)\\" /FD /c
!ELSE
CPP_PROJ=/nologo /MD /W3 /GX /O2 /I "$(MUSCLECARD_INC)" /I "$(PCSC_INC)" /I "$(PTHREADS_INC)" \
/D "WIN32" /D "NDEBUG" /D "_CONSOLE" /D "_MBCS" /Fo"$(OUTDIR)\\" /Fd"$(OUTDIR)\\" /FD /c
!ENDIF

LINK32_FLAGS=$(PTHREADS_NAME).lib musclecard.lib /nologo /subsystem:console /incremental:no /pdb:"$(OUTDIR)\MuscleTools.pdb" /machine:I386 /out:"$(OUTDIR)\MuscleTools.exe" /libpath:"$(MUSCLECARD_LIB)" /libpath:"$(PTHREADS_LIB)"




!ELSE



!IFDEF VERSION2
CPP_PROJ=/nologo /MD /W3 /Gm /GX /ZI /Od /I "$(MUSCLECARD_INC)" /I "$(PCSC_INC)" /I "$(PTHREADS_INC)" /D "WIN32" /D "_DEBUG" /D "_CONSOLE" /D "VERSION2" /D "_MBCS" /FR"$(OUTDIR)\\" /Fo"$(OUTDIR)\\" /Fd"$(OUTDIR)\\" /FD /GZ /c
!ELSE
CPP_PROJ=/nologo /MD /W3 /Gm /GX /ZI /Od /I "$(MUSCLECARD_INC)" /I "$(PCSC_INC)" /I "$(PTHREADS_INC)" /D "WIN32" /D "_DEBUG" /D "_CONSOLE" /D "_MBCS" /FR"$(OUTDIR)\\" /Fo"$(OUTDIR)\\" /Fd"$(OUTDIR)\\" /FD /GZ /c
!ENDIF

LINK32_FLAGS=$(PTHREADS_NAME).lib musclecard.lib /nologo /subsystem:console /incremental:yes /pdb:"$(OUTDIR)\MuscleTools.pdb" /debug /machine:I386 /out:"$(OUTDIR)\MuscleTools.exe" /pdbtype:sept /libpath:"$(MUSCLECARD_LIB)" /libpath:"$(PTHREADS_LIB)"

!ENDIF




$(OUTDIR)\MuscleTools.exe : ../scanner.c ../parser.c $(OUTDIR) $(LINK32_OBJS)
    $(LINK32) $(LINK32_FLAGS) $(LINK32_OBJS)


.c{$(OUTDIR)}.obj::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

.cpp{$(OUTDIR)}.obj::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<

.cxx{$(OUTDIR)}.obj::
   $(CPP) @<<
   $(CPP_PROJ) $<
<<


../scanner.c : ../scanner.l
!IF !EXIST($(FLEX))
	ERROR Flex not found. Change the macro FLEX in this Makefile to point to the \
	correct location or specify it on the command line FLEX=<LOCATION_OF_FLEX_EXECUTABLE>
!ELSE
	$(FLEX) -o../scanner.c ../scanner.l
!ENDIF


../parser.c : ../parser.y
!IF !EXIST($(BISON))
	ERROR Bison not found. Change the macro BISON in this Makefile to point to the \
	correct location or specify it on the command line BISON=<LOCATION_OF_BISON_EXECUTABLE>
!ELSE
	$(BISON) -do ../parser.c ../parser.y
!ENDIF



SOURCE=..\help.c

"$(OUTDIR)\help.obj" : $(SOURCE) "$(OUTDIR)"
	$(CPP) $(CPP_PROJ) $(SOURCE)


SOURCE=..\muscleTool.c

"$(OUTDIR)\muscleTool.obj" : $(SOURCE) "$(OUTDIR)"
	$(CPP) $(CPP_PROJ) $(SOURCE)


SOURCE=..\parser.c

"$(OUTDIR)\parser.obj" : $(SOURCE) "$(OUTDIR)"
	$(CPP) $(CPP_PROJ) $(SOURCE)


SOURCE=..\scanner.c

"$(OUTDIR)\scanner.obj" : $(SOURCE) "$(OUTDIR)"
	$(CPP) $(CPP_PROJ) $(SOURCE)