#include <limits.h>
#include <iostream>

#include "io/fasta.H"
#include "stdinc/stlincludes.H"
#include "mira/parameters.H"
#include "mira/align.H"

//char seq1[]="TNTAATTTCAAACAGGAAGGTATTCTACAAGTTCTTTATTAAAAAATAAAGAAAAAACATTTATTATTGACCCAAAACATAAATGAAAAAACAACGACCATAGATTATTACGNTCTTAATANCTAAACTCTAAAGAGAGTTCTCTTTTAGGNCTGGGGANNGAAGAATCTTTTTAACAATNGACGGNGTCGGTAAAATTCAGACGTAACTAATTCAGTGTCGGNAGTATTTCACAAAGATGAACGAGTATTATCGGGGGTATTTGAAATTCAAAGTTTATTCTTTACTACACCAAAACATTTTTTNGNTTAGNNCGAGANACCGTNTACACATAGAGNCTCTATTTACGANNNAACTAAAGGGNTNAAAATTTTGNGNNGGGNCNAATTACAGNAGATGACTCATATCAGNNGNNAATCGNNNGNNNGNAAATTTGGCCAAANCNAAGAAACCTTCCCACTNGGAAAACCGGNNNNGNCAAANCTTTTCTTTNAANGTAAGTTTTGNA";
//char seq2[]="TTTAATTTCAAAAAGGAAGGTATTCTACAAGTTCTTTATTAAAAAATAAAGAAAAAACATTTATTATTGACCCAAAACATAAATGAAAAAACAACGACCATAGATTATTACGTTCTTAATATCTAAACTCTAAAGAGAGTTCTCTTTTAGGTCTGGAGAAAGGAAGATTCTTTTAACAATAGACGATGTCGTAAAATTTAGACGTAACTAATATAGTGTCGGTAGTATTTCACAAAGATGAACGAGTATTATCGGGGGTATTTGAAATTCAAAGTTTATTCTTTACTACACCAAAACATTTTTTAGATTAGTACGAAAAACCGTCTACACATAGAGCTCTATTTACGATTCAACTAAAGTGCTAAAAATTTTGTGAGGGGTTATAATTATAGTAGATACTCATATTAGAATAATCGTTAATCGAAAATTTGACAAACAAGAAACTTCCATTGTAAACGTTTAGTAAACTTCTTTAAGTAGTTTACTGAGGGGTGACAACCTAAACCGT";



//char seq1[]="TCGGC*TCAAACAGCTCACGCTAAAAGTTGGCGAATCGATGAGACCTATATTCGAGTTAAAGGCCGTTGGGCCTATTTGTATCGCGCTATTGACAGTAACGGTTTGACCATGGATTTTGAGCTACGAAAACACCGCGATTATACCGCATCCTATCACTTTTTGAAGCGTCTCTTGACGACCAATGGTCGGCCTGATCGATTAGTCACTGATCAATATCAGGCAACACTGAAAGCAGTGAAGCATCTGATAAAGCAAGACTATTTGAGCAAATCAGCCCACCAATGTTCCAAATATCGAAATAATTTGATTGAACAGGACCACCGATTCATTAAACGTCATCGTGTCCGCTCAGCAAGCTTTCAAAGCATTCGAACCGCTAGTGCAACGTTGAGCGGTGTAGGAAATTGTTCNNACGCAATCCGCAAAAGAACCCGACGAGAGTTAAGTCAATCACTCGTGGTTCTCNAGTCAGTGGACGAATTAGAAGCATTGTTAGCTGCATAACCTTCAACATAGGATCAATAGCTGGTTAGATGGTCATCTCTCACACTGTTTGCACCAGATCCAAAAAGTTCGCCATAAACATTATTTGCTTGATAAAAATTGAAATTGGTTGATTTTGTCATTATAAAAACTCCCTTTCTTGACTGACACACGCTGTCTCAAAAGAGGGTTGCTAAAACATCTGACTTGTTTTAAAATACAAACCTGATATGCTTTAACTGAATTACAAAGCATTCATTTAGTGGTGAGGCTTTGTAATTTACCAGCATGTGTCTAT";

//char seq2[]="CTCAAACAGCTCACGCTAAAAGTTGGCGAATCGATGAGACCTATATTCGAGTTAAAGGCCGTTGGGCCTATTTGTATCGCGCTATTGACAGTAACGGTTTGACCATGGATTTTGAGCTACGAAAACACCGCGATTATACCGCATCCTATCACTTTTTGAAGCGTCTCTTGACGACCAATGGTCGGCCTGATCGATTAGTCACTGATCAATATCAGGCAACACTGAAAGCAGTGAAGCATCTGATAAAGCAAGACTATTTGAGCAAATCAGCCCACCAATGTTCCAAATATCGAAATAATTTGATTGAACAGGACCACCGATTCATTAAACGTCATCGTGTCCGCTCAGCAAGCTTTCAAAGCATTCGAACCGCTAGTGCAACGTTGAGCGGTGTGGAAATTGTTCACGCAATCCGCAAAAGAACCCGACGAGAGTTAAGTCTCATCGGGTTCTCAGTCGTGGACGAATTAGAAGCATTGTTAGCTGCATAACCTTCAACATAGGATCAATAGCTGGTTAGATGGTCATCTCTCACACTGTTTGCACCAGATCCGTTAAAAGAAGATATATTTTCCATGACCAATCTATCTTCCCCATCTTTAAGCTGGTAACTGTCAGATTCGTCAGTCCCGTCAGTTCCGAAAGCAAAGATTATATTCTGGCCTGATTCCTTGACTTTTTCTAATTCTG";


char seq1[]="GCTGACCAGCGCCCCGGA*TTCTCCCTTTTTCAGTTCATCATATCTCTCCATACAAAACCT*CCTCCCCGCTCAC*ATTTTCCTATTAT*TATCTTACAAAG**CTGA*ACCGCAGTGGGTCTACAGAAACATGATTCACCCGCCACAGAAAAATAGTGACGATGGAACACTTTTTCTCTCATCCAATTTATTTGCTCCG*CCAAAAAGCCCATCAGAT*CCAATGACACCAGCGCTTCTCGCATTCTATCAAATTGTAAA*TAGTAC*ACAAAATCACACAGCAAATAAAAAAACGAAACATTTTTT*CCACACATTCGCTGAAAGCG*CAAACAAAAAC*ACTACAAATTTGAAATAAAACGTTATATTTT*CTCACATGAATTTTCGACAAACTGTATATTTATGATAGAGTTTCAATTATCATAATATTCAGTAATGATTGC**ANTTTTAAAAGGAGGTAACTTAT**AGTAA*C*CAATCTCAATCAGGANTAAAAAAAGTGAATTAAAGACCCGCCATATGACAATGATTTCGATTGCCGGT*GTAATCGGAGCCGGCCTATTTGTAGGCAGCGGTTC*AGTGATTCACTCGACCGGTCCGGGTG*CCGTTGTTTCTTACG*CGTTAGCCGGTATTATTGGTGTATTTTTATTA*TGAGAATGCTCGGTGAGATGTCTGCCGTAAACCCGACGAGCGGATCGTTTTCT*CAATACGCTCACGACG*CCAT*CGGACCGTGGGCAGGATTTACAATCGGCTGGCTGTACTGGT*TTTTCTGGGTGATCGTCATCGCGATCGAAGCCATTGCCGGTGCTGG*CATTATTCAATACTGGTTCCATGATATTCCGCTGTGGCTGACAAGTTTGATCTTGACCATTGTG*CTCACCCTGACAAACGTCTACTCCGTTAAGTCTTTCGGTGAGTTTGAATATTGGTTCTCCCTCATTAAAGTTGTGACTATC*ATTGCTTTTCTAATCGTTGGTTTTGTCCTTTATTTTTGGTCTTTGGCACCGGGCAGTGAG*CCAGTCGGTTTTTCGAATCTTAC*AGGCAAAGGCGG*ATTTTTCCCG*GAGGGCATCAGCTCCGTATTG**C****TCGGCATTGTCGTTGTCATTTTCTCTTTTATGGGAACTGAAATCGTTGCCATTGCAGCAGGGGAAACATCCAATCCGATCGAATCTGTGACAAAAGCCACCAGATCCGTTGTATGGCGCATCATCGTCTTTTACGTGGGCTCAATCGCCATTGTCGTAGCGCTGTTGCCATGGAATTCA*GCAAATATTTTAGAAAGCCCTTTCGTCGCTGTACTTGAGCATATAGGAGTGCCCGCAGCCGCACAGATTATGTAACTTTATCGTCCTCTACAG*CCGTACTCTCTTGCCT*GAATTC*AGGTTTGTATACCACATCCAGAATGCTGTATTCACTTGCAGAAAGAAACGAAGCGCCGCGCCGTTTTATGAAATTGAG*CAAAAAAGG*CGTTCCCGTACAAGCCATTGTGG*CCGGGAC*ATTTTTCTCTTATATCGCGGTCGTAATGAAC*TATTTTTCACCGGATACCGTCTTTTTATTCTTAGTCAACTCATCAGGCGC*AATCGCTTTACTCGTCTATCTTGTCATCGCAGTTTCCCAGCTGAAAAT*GCGGAAAAAACT*CGAAAAAACAAACCCA*GAAGCATTGAAGATCAAAATGTG*GCTCTTCCCTTT*CCTAACCTACTTGACCATCATCGCCATTTGCGGAATTTTAGTGTCCAT*GGCGTTTATTGATTCCATGAGAGACGAG*CTGCTGCTAACAGGCGTCATCACGGGAATCGTTCTGATTTCTTACCTTGTGTTCAGAAAACGCAAGGTGAGCGAGAAAGCGGCTGCCAACCCAGTCACACAGCAGCAACCCGATATCCTG*CCTTAATGCTGATCAAAT*CCTAAACGG*CCTGCCGTTTAGG*ATTTTGTTATTTTCTTCTTCGGGCGGGC*TG*CAGCACG*AAG*ATTTTTTGTAACCATCACGTCCTTATTGTCATTAACTATAGTACCAATTTGGAAAATTTAGATAAGGACAGATGAAAAT*GACACTTGAAAAATTT*GTGGATGCTCTCCCAATCCCAGATACACTAAAGCCAGTACAGCAATAC*AAAAGAAAAAACACATACTACGAAGTCACCATGGAGGAATGCCACTCATCAGCTCCATCGCGATCTCCCTCCAACCCGCCTGTGGGGCTACAACGGTCTTACGTTTCCGGGGCCGA*CCTATTG*AGGTTAAAAGAAAT*GAAAACGTATAT*GTAAAATGGAT*GAATAACCTTCCTTCCACGCATTTCCTTCCAATTGATCAC*ACCATTCATCACAGT*GACAGCCAGCATGAAGAGCCCGAGGTAAAGACTGTTGTTCATTTACACGG*CGGCGTCACGCCAGATGATAGTG*ACGGGTATCCGGAGGCTTGGTTTTCCAAAGACTTTGAACAAACAGGACCTTATTTCAAAAGAGAGGTTTAT*CATTATCCAAACCAGCAGCGCGGGGCTATATTGTGGTACCACGAT";

char seq2[]="TTTTCAGTTCATCATATCTCTCCATACAAAACCTCCTCCCCGCTCACATTTTCCTATTATTATCTTACAAAGCTGAACCGCAGTGGGTCTACAGAAACATGATTC";


int main(int argc, char ** argv)
{
  FUNCSTART("main");

  try{
    vector<MIRAParameters> Pv;
    MIRAParameters::setupStdMIRAParameters(Pv);

    MIRAParameters::parse(argc, argv, Pv);

    Pv[0].setAlignMinScore(1);
    Pv[0].setAlignMinRelScore(20);
    Pv[0].setAlignMinOverlap(1);
    
    
    list<AlignedDualSeq> madsl;
    Align bla(&Pv[0]);
    
    bla.acquireSequences((const char*) seq1, strlen(seq1), 
			 (const char*) seq2, strlen(seq2), 
			 1, 2, 1, 1,
			 true, 15);
    bla.fullAlign(&madsl,false,false);
    list<AlignedDualSeq>::iterator I;
    cout << "madsl.size(): " << madsl.size() << endl;
    
    {
      for(I= madsl.begin(); I!=madsl.end(); I++){
	if(I->isValid()==true){
	  cout << *I;
	}
      }
    }
    
    cout << "\n\n\nmadsl has " << madsl.size() << " elements.\n" <<endl;
    
  }
  catch(Notify n){
    n.handleError("main");
  }
  cout << "\n\n";
  
  cout << "Tests ended.\n";
  
  FUNCEND();
  return 0;
}


