//******************************************************************************
//  Copyright (c) 2005-2010 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#include "qpicture_c.h"

QPictureH QPicture_create(int formatVersion)
{
	return (QPictureH) new QPicture(formatVersion);
}

void QPicture_destroy(QPictureH handle)
{
	delete (QPicture *)handle;
}

QPictureH QPicture_create2(const QPictureH p1)
{
	return (QPictureH) new QPicture(*(const QPicture*)p1);
}

bool QPicture_isNull(QPictureH handle)
{
	return (bool) ((QPicture *)handle)->isNull();
}

int QPicture_devType(QPictureH handle)
{
	return (int) ((QPicture *)handle)->devType();
}

uint QPicture_size(QPictureH handle)
{
	return (uint) ((QPicture *)handle)->size();
}

const char* QPicture_data(QPictureH handle)
{
	return (const char*) ((QPicture *)handle)->data();
}

void QPicture_setData(QPictureH handle, const char* data, uint size)
{
	((QPicture *)handle)->setData(data, size);
}

bool QPicture_play(QPictureH handle, QPainterH p)
{
	return (bool) ((QPicture *)handle)->play((QPainter*)p);
}

bool QPicture_load(QPictureH handle, QIODeviceH dev, const char* format)
{
	return (bool) ((QPicture *)handle)->load((QIODevice*)dev, format);
}

bool QPicture_load2(QPictureH handle, PWideString fileName, const char* format)
{
	QString t_fileName;
	copyPWideStringToQString(fileName, t_fileName);
	return (bool) ((QPicture *)handle)->load(t_fileName, format);
}

bool QPicture_save(QPictureH handle, QIODeviceH dev, const char* format)
{
	return (bool) ((QPicture *)handle)->save((QIODevice*)dev, format);
}

bool QPicture_save2(QPictureH handle, PWideString fileName, const char* format)
{
	QString t_fileName;
	copyPWideStringToQString(fileName, t_fileName);
	return (bool) ((QPicture *)handle)->save(t_fileName, format);
}

void QPicture_boundingRect(QPictureH handle, PRect retval)
{
	QRect t_retval;
	t_retval = ((QPicture *)handle)->boundingRect();
	copyQRectToPRect(t_retval, retval);
}

void QPicture_setBoundingRect(QPictureH handle, PRect r)
{
	QRect t_r;
	copyPRectToQRect(r, t_r);
	((QPicture *)handle)->setBoundingRect(t_r);
}

void QPicture_detach(QPictureH handle)
{
	((QPicture *)handle)->detach();
}

bool QPicture_isDetached(QPictureH handle)
{
	return (bool) ((QPicture *)handle)->isDetached();
}

const char* QPicture_pictureFormat(PWideString fileName)
{
	QString t_fileName;
	copyPWideStringToQString(fileName, t_fileName);
	return (const char*) QPicture::pictureFormat(t_fileName);
}

void QPicture_inputFormatList(QStringListH retval)
{
	*(QStringList *)retval = QPicture::inputFormatList();
}

void QPicture_outputFormatList(QStringListH retval)
{
	*(QStringList *)retval = QPicture::outputFormatList();
}

QPaintEngineH QPicture_paintEngine(QPictureH handle)
{
	return (QPaintEngineH) ((QPicture *)handle)->paintEngine();
}

