package tests::LrFirstTest;

use strict;

use base qw/Lire::Test::TestCase/;

use Lire::SQLExt::LrFirst;

sub set_up {
    my $self = shift()->SUPER::set_up();

    $self->{'lr_first'} = new Lire::SQLExt::LrFirst();
    $self->{'lr_first_key'} = new Lire::SQLExt::LrFirst( 'key' );

    return;
}

sub tear_down {
    my $self = $_[0];

    $self->SUPER::tear_down();

    return;
}

sub test_new {
    my $self = $_[0];

    $self->assert_null( $self->{'lr_first'}{'_value'},
                        '_value should be undefined' );
    $self->assert_deep_equals( [], $self->{'lr_first'}{'_sort_values'} );
    $self->assert_deep_equals( [], $self->{'lr_first'}{'_sort_str'} );
    $self->assert_equals( 'value', $self->{'lr_first'}{'_return'} );

    $self->assert_equals( 'key', $self->{'lr_first_key'}{'_return'} );

    $self->assert_deep_equals( $self->{'lr_first'},
                               $self->{'lr_first'}->new() );
    $self->assert_deep_equals( $self->{'lr_first_key'},
                               $self->{'lr_first_key'}->new() );
}

sub test_is_number {
    my $self = $_[0];

    my @tests = ( [ 0, 1 ], [ '0', 1 ], [ 0xFF, 1 ],
                  [ 'abcde', 0 ], [ '0astring', 0 ],
                  [ '0xFF', 0 ] );
    foreach my $t ( @tests ) {
        if ( $t->[1] ) {
            $self->assert( Lire::SQLExt::LrFirst::is_number( $t->[0] ),
                           "is_number( $t->[0] ) should be true" );
        } else {
            $self->assert( ! Lire::SQLExt::LrFirst::is_number( $t->[0] ),
                           "is_number( $t->[0] ) should be false" );
        }
    }
}

sub test_step_nosortkeys {
    my $self = $_[0];

    my $aggr = $self->{'lr_first'};
    $aggr->step( undef );
    $self->assert_null( $aggr->{'_value'}, 'value should be undef' );
    $aggr->step( 'abcde' );
    $self->assert_equals( 'abcde', $aggr->{'_value'} );
    $aggr->step( '0123' );
    $self->assert_equals( 'abcde', $aggr->{'_value'} );
}

sub test_step {
    my $self = $_[0];

    my $aggr = $self->{'lr_first'};

    $aggr->step( undef, 'host1', 10 );
    $self->assert_null( $aggr->{'_value'},
                        "'_value' attribute should be undef"  );

    $aggr->step( 'user1', undef, 10 );
    $self->assert_null( $aggr->{'_value'},
                        "'_value' attribute should be undef"  );

    $aggr->step( 'user1', 'host1', 'user1' );
    $self->assert_equals( 'user1', $aggr->{'_value'} );
    $self->assert_deep_equals( [ 1, 1 ], $aggr->{'_sort_str'} );
    $self->assert_deep_equals( [ 'host1', 'user1' ], $aggr->{'_sort_values'} );

    $aggr->step( 'user1', undef, 'user1' );
    $self->assert_equals( 'user1', $aggr->{'_value'} );
    $self->assert_deep_equals( [ 1, 1 ], $aggr->{'_sort_str'} );
    $self->assert_deep_equals( [ 'host1', 'user1' ], $aggr->{'_sort_values'} );

    $aggr->step( 'user2', 'host1', 'abcde' );
    $self->assert_equals( 'user2', $aggr->{'_value'} );
    $self->assert_deep_equals( [ 1, 1 ], $aggr->{'_sort_str'} );
    $self->assert_deep_equals( [ 'host1', 'abcde' ], $aggr->{'_sort_values'} );

    $aggr->step( 'user3', 'ahost', 'user1' );
    $self->assert_equals( 'user3', $aggr->{'_value'} );
    $self->assert_deep_equals( [ 1, 1 ], $aggr->{'_sort_str'} );
    $self->assert_deep_equals( [ 'ahost', 'user1' ], $aggr->{'_sort_values'} );

    $aggr->step( 'user5', 'ahost', 10 );
    $self->assert_equals( 'user5', $aggr->{'_value'} );
    $self->assert_deep_equals( [ 1, 1 ], $aggr->{'_sort_str'} );
    $self->assert_deep_equals( [ 'ahost', '10' ], $aggr->{'_sort_values'} );
}

sub test_step_num {
    my $self = $_[0];

    my $aggr = $self->{'lr_first'};

    $aggr->step( 'user1', 'host1', '1024' );
    $self->assert_equals( 'user1', $aggr->{'_value'} );
    $self->assert_deep_equals( [ 1, 0 ], $aggr->{'_sort_str'} );
    $self->assert_deep_equals( [ 'host1', 1024 ], $aggr->{'_sort_values'} );

    $aggr->step( 'user0', 'host1', '512' );
    $self->assert_equals( 'user0', $aggr->{'_value'} );
    $self->assert_deep_equals( [ 1, 0 ], $aggr->{'_sort_str'} );
    $self->assert_deep_equals( [ 'host1', 512 ], $aggr->{'_sort_values'} );

    $aggr->step( 'usera', 'host1', '0a512' );
    $self->assert_equals( 'usera', $aggr->{'_value'} );
    $self->assert_deep_equals( [ 1, 1 ], $aggr->{'_sort_str'} );
    $self->assert_deep_equals( [ 'host1', '0a512' ], $aggr->{'_sort_values'} );

    $aggr->step( 'userb', 'host1', '0512' );
    $self->assert_equals( 'userb', $aggr->{'_value'} );
    $self->assert_deep_equals( [ 1, 1 ], $aggr->{'_sort_str'} );
    $self->assert_deep_equals( [ 'host1', '0512' ], $aggr->{'_sort_values'} );
}

sub test_finalize {
    my $self = $_[0];

    $self->{'lr_first'}{'_value'} = 10;
    $self->assert_num_equals( 10, $self->{'lr_first'}->finalize() );

    $self->{'lr_first_key'}{'_sort_values'} = [ 'test', 'test1'];
    $self->assert_str_equals( 'test test1',
                              $self->{'lr_first_key'}->finalize() );

    $self->{'lr_first_key'}{'_sort_values'} = [];
    $self->assert_str_equals( '', $self->{'lr_first_key'}->finalize() );
}
1;
