/*
 *  Copyright (C) 2005 Kouji TAKAO <kouji@netlab.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#include "gpass/error.h"

void
gpass_error_show_and_exit(GError *error)
{
    g_return_if_fail(error != NULL);
    gpass_error_locale_printf("**error**: %s\n", error->message);
    g_error_free(error);
    exit(1);
}

void
gpass_error_locale_printf(const gchar *format, ...)
{
    va_list args;
    gchar *utf8_str, *locale_str;
    gsize read_bytes, written_bytes;
    GError *error = NULL;

    va_start(args, format);
    utf8_str = g_strdup_vprintf(format, args);
    va_end(args);
    locale_str = g_locale_from_utf8(utf8_str, strlen(utf8_str),
                                    &read_bytes, &written_bytes, &error);
    if (error != NULL) {
        gpass_error_show_and_exit(error);
    }
    printf(locale_str);
    g_free(utf8_str);
    g_free(locale_str);
}
