/*
 *  Copyright (C) 2005 Kouji TAKAO <kouji@netlab.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GPASS_FILE_H__
#define __GPASS_FILE_H__

#include "gpass/crypt-stream.h"
#include "gpass/entry-factory.h"

G_BEGIN_DECLS

/***********************************************************
 *
 * GPassFile
 *
 ***********************************************************/
#define GPASS_TYPE_FILE (gpass_file_get_type())
#define GPASS_FILE(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_FILE, GPassFile))
#define GPASS_FILE_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_FILE, GPassFileClass))
#define GPASS_IS_FILE(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_FILE))
#define GPASS_IS_FILE_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_FILE))
#define GPASS_FILE_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_FILE, GPassFileClass))

typedef struct {
    GObject parent;

    gchar *path;
    gchar *master_password;
} GPassFile;

typedef struct {
    GObjectClass parent;
} GPassFileClass;

GType gpass_file_get_type(void);

GError *gpass_file_create(const gchar *path, const gchar *master_password);
GError *gpass_file_open(GPassFile **self, const gchar *path,
                        const gchar *master_password);
GError *gpass_file_read(GPassFile *self, GPassEntryFactory *factory,
                        GPassEntry **entries);
GError *gpass_file_write_with_version(GPassFile *self, GPassEntry *entries,
                                      const gchar *version);
GError *gpass_file_write(GPassFile *self, GPassEntry *entries);
GError *gpass_file_backup(GPassFile *self, const gchar *backup_path);
GError *gpass_file_restore(GPassFile *self, const gchar *backup_path);
void gpass_file_close(GPassFile *self);

/***********************************************************
 *
 * GPassFileReader
 *
 ***********************************************************/
#define GPASS_TYPE_FILE_READER (gpass_file_reader_get_type())
#define GPASS_FILE_READER(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_FILE_READER, \
                                GPassFileReader))
#define GPASS_FILE_READER_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_FILE_READER, \
                             GPassFileReaderClass))
#define GPASS_IS_FILE_READER(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_FILE_READER))
#define GPASS_IS_FILE_READER_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_FILE_READER))
#define GPASS_FILE_READER_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_FILE_READER, \
                               GPassFileReaderClass))

typedef struct {
    GObject parent;
    
    GPassDecryptStream *decrypt;
    GPassEntryFactory *factory;
    GHashTable *entries;
} GPassFileReader;

typedef struct {
    GObjectClass parent;
    
    GError *(*read_entry)(GPassFileReader *self, guint *id, guint *parent_id,
                          GPassEntry **entry);
} GPassFileReaderClass;

GType gpass_file_reader_get_type(void);

GError *gpass_file_reader_read(GPassFileReader *self, GPassEntry *entries);

/***********************************************************
 *
 * GPassFileWriter
 *
 ***********************************************************/
#define GPASS_TYPE_FILE_WRITER (gpass_file_writer_get_type())
#define GPASS_FILE_WRITER(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_FILE_WRITER, \
                                GPassFileWriter))
#define GPASS_FILE_WRITER_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_FILE_WRITER, \
                             GPassFileWriterClass))
#define GPASS_IS_FILE_WRITER(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_FILE_WRITER))
#define GPASS_IS_FILE_WRITER_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_FILE_WRITER))
#define GPASS_FILE_WRITER_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_FILE_WRITER, \
                               GPassFileWriterClass))

typedef struct {
    GObject parent;
    
    GPassEncryptStream *encrypt;
} GPassFileWriter;

typedef struct {
    GObjectClass parent;
    
    GError *(*write_entry)(GPassFileWriter *self, guint id, guint parent_id,
                           GPassEntry *entry);
} GPassFileWriterClass;

GType gpass_file_writer_get_type(void);

GError *gpass_file_writer_write(GPassFileWriter *self, GPassEntry *entries);

G_END_DECLS

#endif /* #ifndef __GPASS_FILE_H__ */
