/*
 * Decompiled with CFR 0.152.
 */
package geotrans.gui;

import geotrans.gui.AboutDlg;
import geotrans.gui.CreateDatumDlg;
import geotrans.gui.CreateEllipsoidDlg;
import geotrans.gui.CreateFileHeaderDlg;
import geotrans.gui.DeleteDlg;
import geotrans.gui.FileDlg;
import geotrans.gui.FormatOptionsDlg;
import geotrans.gui.MasterPanel;
import geotrans.gui.RestoreDefault;
import geotrans.gui.SaveAsDefault;
import geotrans.gui.jOptions;
import geotrans.jni.GeotransError;
import geotrans.jni.GeotransWarning;
import geotrans.jni.JNIEngine;
import geotrans.jni.JNIException;
import geotrans.jni.JNIFiomeths;
import geotrans.jni.JNIStrtoval;
import geotrans.utility.Center;
import geotrans.utility.DATFileFilter;
import geotrans.utility.Directory;
import geotrans.utility.Platform;
import geotrans.utility.ReadEnv;
import geotrans.utility.StartBrowser;
import geotrans.utility.color.Green;
import geotrans.utility.color.Red;
import geotrans.utility.color.Yellow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ImageProducer;
import java.io.File;
import java.net.URL;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.text.JTextComponent;

public class Geotrans
extends JFrame {
    private Directory currentDir = new Directory(".");
    private JNIEngine jniEngine = new JNIEngine();
    private JNIStrtoval jniStrtoval = new JNIStrtoval();
    private Color defaultSelectedColor = new Color(0, 0, 0);
    private Color currentColor = Green.VALUE;
    private Component prevFocus;
    private MasterPanel upperMasterPanel;
    private MasterPanel lowerMasterPanel;
    private jOptions options;
    private String currLookAndFeel = "Java";
    private String dataDirPathName = "";
    private File defaultFile;
    private JMenuItem aboutMenuItem;
    private JMenuItem contentsMenuItem;
    private JButton convertDownButton;
    private JMenuItem convertDownMenuItem;
    private JMenu convertMenu;
    private JSeparator convertMenuSeparator;
    private JPanel convertPanel;
    private JButton convertUpButton;
    private JMenuItem convertUpMenuItem;
    private JButton copyButton;
    private JMenuItem copyMenuItem;
    private JMenuItem createDatumMenuItem;
    private JMenuItem createEllipsoidMenuItem;
    private JMenuItem createFileHeaderMenuItem;
    private JButton cutButton;
    private JMenuItem cutMenuItem;
    private JMenu datumMenu;
    private JMenuItem deleteDatumMenuItem;
    private JMenuItem deleteEllipsoidMenuItem;
    private JMenu editMenu;
    private JMenu ellipsoidMenu;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JSeparator fileMenuSeparator;
    private JButton formatButton;
    private JMenuItem formatMenuItem;
    private JMenuBar geotransMenuBar;
    private JToolBar geotransToolBar;
    private JSeparator geotransToolBarSeparator;
    private JMenu helpMenu;
    private JSeparator helpMenuSeparator;
    private JMenu lookAndFeelMenu;
    private JPanel lowerPanel;
    private JRadioButtonMenuItem metalRadioButtonMenuItem;
    private JMenuItem openMenuItem;
    private JMenu optionsMenu;
    private JButton pasteButton;
    private JMenuItem pasteMenuItem;
    private JMenuItem restoreDefaultMenuItem;
    private JMenuItem saveAsDefaultMenuItem;
    private JRadioButtonMenuItem unixRadioButtonMenuItem;
    private JPanel upperPanel;
    private JRadioButtonMenuItem windowsRadioButtonMenuItem;

    public Geotrans() {
        this.defaultSelectedColor = (Color)UIManager.get("Button.select");
        this.initComponents();
        this.initialize();
        ButtonGroup lookAndFeelGroup = new ButtonGroup();
        lookAndFeelGroup.add(this.metalRadioButtonMenuItem);
        lookAndFeelGroup.add(this.unixRadioButtonMenuItem);
        lookAndFeelGroup.add(this.windowsRadioButtonMenuItem);
        URL url = this.getClass().getResource("/geotrans/gui/icons/Icon.gif");
        try {
            Image img = this.createImage((ImageProducer)url.getContent());
            this.setIconImage(img);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.pack();
        if (Platform.isUnix) {
            this.setSize(new Dimension(484, 679));
        }
        new Center(null, this);
        try {
            Properties p = ReadEnv.getEnvVars();
            this.dataDirPathName = p.getProperty("GEOTRANS_DATA");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.dataDirPathName = this.dataDirPathName != null && this.dataDirPathName.length() > 0 ? this.dataDirPathName + "/" : "../data/";
        this.dataDirPathName = this.dataDirPathName + "default.xml";
        this.defaultFile = new File(this.dataDirPathName);
        if (this.defaultFile.exists()) {
            new RestoreDefault(this, this.defaultFile, this.upperMasterPanel, this.lowerMasterPanel, this.options);
        }
    }

    private void initComponents() {
        this.geotransToolBar = new JToolBar();
        this.cutButton = new JButton();
        this.copyButton = new JButton();
        this.pasteButton = new JButton();
        this.formatButton = new JButton();
        this.geotransToolBarSeparator = new JSeparator();
        this.upperPanel = new JPanel();
        this.convertPanel = new JPanel();
        this.convertDownButton = new JButton();
        this.convertUpButton = new JButton();
        this.lowerPanel = new JPanel();
        this.geotransMenuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.createFileHeaderMenuItem = new JMenuItem();
        this.restoreDefaultMenuItem = new JMenuItem();
        this.saveAsDefaultMenuItem = new JMenuItem();
        this.fileMenuSeparator = new JSeparator();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.cutMenuItem = new JMenuItem();
        this.copyMenuItem = new JMenuItem();
        this.pasteMenuItem = new JMenuItem();
        this.optionsMenu = new JMenu();
        this.formatMenuItem = new JMenuItem();
        this.lookAndFeelMenu = new JMenu();
        this.metalRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.unixRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.windowsRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.datumMenu = new JMenu();
        this.createDatumMenuItem = new JMenuItem();
        this.deleteDatumMenuItem = new JMenuItem();
        this.ellipsoidMenu = new JMenu();
        this.createEllipsoidMenuItem = new JMenuItem();
        this.deleteEllipsoidMenuItem = new JMenuItem();
        this.convertMenu = new JMenu();
        this.convertDownMenuItem = new JMenuItem();
        this.convertMenuSeparator = new JSeparator();
        this.convertUpMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.contentsMenuItem = new JMenuItem();
        this.helpMenuSeparator = new JSeparator();
        this.aboutMenuItem = new JMenuItem();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("GEOTRANS V2.4.2 - Geographic Translator V2.4.2");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Geotrans.this.exitForm(evt);
            }
        });
        this.geotransToolBar.setFloatable(false);
        this.geotransToolBar.setAlignmentX(0.0f);
        this.geotransToolBar.setMinimumSize(new Dimension(25, 25));
        this.geotransToolBar.setPreferredSize(new Dimension(25, 25));
        this.cutButton.setIcon(new ImageIcon(this.getClass().getResource("/geotrans/gui/icons/Cut16.gif")));
        this.cutButton.setToolTipText("Cut");
        this.cutButton.setMaximumSize(new Dimension(25, 30));
        this.cutButton.setMinimumSize(new Dimension(17, 21));
        this.cutButton.setPreferredSize(new Dimension(27, 27));
        this.cutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Geotrans.this.cutActionPerformed(evt);
            }
        });
        this.cutButton.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                Geotrans.this.editButtonMouseEntered(evt);
            }
        });
        this.geotransToolBar.add(this.cutButton);
        this.copyButton.setIcon(new ImageIcon(this.getClass().getResource("/geotrans/gui/icons/Copy16.gif")));
        this.copyButton.setToolTipText("Copy");
        this.copyButton.setMaximumSize(new Dimension(25, 30));
        this.copyButton.setMinimumSize(new Dimension(17, 21));
        this.copyButton.setPreferredSize(new Dimension(27, 27));
        this.copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Geotrans.this.copyActionPerformed(evt);
            }
        });
        this.copyButton.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                Geotrans.this.editButtonMouseEntered(evt);
            }
        });
        this.geotransToolBar.add(this.copyButton);
        this.pasteButton.setIcon(new ImageIcon(this.getClass().getResource("/geotrans/gui/icons/Paste16.gif")));
        this.pasteButton.setToolTipText("Paste");
        this.pasteButton.setMaximumSize(new Dimension(25, 30));
        this.pasteButton.setMinimumSize(new Dimension(17, 21));
        this.pasteButton.setPreferredSize(new Dimension(27, 27));
        this.pasteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Geotrans.this.pasteActionPerformed(evt);
            }
        });
        this.pasteButton.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                Geotrans.this.editButtonMouseEntered(evt);
            }
        });
        this.geotransToolBar.add(this.pasteButton);
        this.formatButton.setIcon(new ImageIcon(this.getClass().getResource("/geotrans/gui/icons/Preferences16.gif")));
        this.formatButton.setToolTipText("Format Options");
        this.formatButton.setMaximumSize(new Dimension(25, 30));
        this.formatButton.setMinimumSize(new Dimension(17, 21));
        this.formatButton.setPreferredSize(new Dimension(27, 27));
        this.formatButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Geotrans.this.formatActionPerformed(evt);
            }
        });
        this.geotransToolBar.add(this.formatButton);
        this.geotransToolBarSeparator.setOrientation(1);
        this.geotransToolBar.add(this.geotransToolBarSeparator);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        this.getContentPane().add((Component)this.geotransToolBar, gridBagConstraints);
        this.upperPanel.setLayout(new GridBagLayout());
        this.upperPanel.setBackground(Color.lightGray);
        this.upperPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createLineBorder(new Color(0, 0, 0))));
        this.upperPanel.setMinimumSize(new Dimension(469, 284));
        this.upperPanel.setPreferredSize(new Dimension(469, 284));
        this.upperPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.upperPanel, gridBagConstraints);
        this.convertPanel.setLayout(new GridBagLayout());
        this.convertPanel.setBorder(BorderFactory.createBevelBorder(1));
        this.convertDownButton.setFont(new Font("Dialog", 0, 11));
        this.convertDownButton.setText("Convert Upper -> Lower");
        this.convertDownButton.setToolTipText("Convert Upper to Lower");
        this.convertDownButton.setBorder(BorderFactory.createBevelBorder(0));
        this.convertDownButton.setMaximumSize(new Dimension(197, 24));
        this.convertDownButton.setMinimumSize(new Dimension(197, 24));
        this.convertDownButton.setPreferredSize(new Dimension(197, 24));
        this.convertDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Geotrans.this.convertDownActionPerformed(evt);
            }
        });
        this.convertDownButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                Geotrans.this.convertButtonMousePressed(evt);
                Geotrans.this.convertDownButtonMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                Geotrans.this.convertButtonMouseReleased(evt);
                Geotrans.this.convertDownButtonMouseReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 0, 3, 12);
        this.convertPanel.add((Component)this.convertDownButton, gridBagConstraints);
        this.convertUpButton.setFont(new Font("Dialog", 0, 11));
        this.convertUpButton.setText("Convert Lower -> Upper");
        this.convertUpButton.setToolTipText("Convert Lower to Upper");
        this.convertUpButton.setBorder(BorderFactory.createBevelBorder(0));
        this.convertUpButton.setMaximumSize(new Dimension(197, 24));
        this.convertUpButton.setMinimumSize(new Dimension(197, 24));
        this.convertUpButton.setPreferredSize(new Dimension(197, 24));
        this.convertUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Geotrans.this.convertUpActionPerformed(evt);
            }
        });
        this.convertUpButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                Geotrans.this.convertButtonMousePressed(evt);
                Geotrans.this.convertUpButtonMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                Geotrans.this.convertButtonMouseReleased(evt);
                Geotrans.this.convertUpButtonMouseReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 12, 3, 0);
        this.convertPanel.add((Component)this.convertUpButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.getContentPane().add((Component)this.convertPanel, gridBagConstraints);
        this.lowerPanel.setLayout(new GridBagLayout());
        this.lowerPanel.setBackground(Color.lightGray);
        this.lowerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createLineBorder(new Color(0, 0, 0))));
        this.lowerPanel.setMinimumSize(new Dimension(469, 284));
        this.lowerPanel.setPreferredSize(new Dimension(469, 284));
        this.lowerPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.lowerPanel, gridBagConstraints);
        this.geotransMenuBar.setMinimumSize(new Dimension(285, 23));
        this.fileMenu.setMnemonic(70);
        this.fileMenu.setText("File");
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/geotrans/gui/icons/Open16.gif")));
        this.openMenuItem.setMnemonic(79);
        this.openMenuItem.setText("Open");
        this.openMenuItem.setToolTipText("Open");
        this.openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Geotrans.this.openActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.createFileHeaderMenuItem.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        this.createFileHeaderMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/geotrans/gui/icons/Create16.gif")));
        this.createFileHeaderMenuItem.setMnemonic(67);
        this.createFileHeaderMenuItem.setText("Create File Header");
        this.createFileHeaderMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Geotrans.this.createFileHeaderActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.createFileHeaderMenuItem);
        this.restoreDefaultMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.restoreDefaultMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/geotrans/gui/icons/Open16.gif")));
        this.restoreDefaultMenuItem.setMnemonic(82);
        this.restoreDefaultMenuItem.setText("Restore Default");
        this.restoreDefaultMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Geotrans.this.restoreDefaultActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.restoreDefaultMenuItem);
        this.saveAsDefaultMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveAsDefaultMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/geotrans/gui/icons/Save16.gif")));
        this.saveAsDefaultMenuItem.setMnemonic(83);
        this.saveAsDefaultMenuItem.setText("Save As Default");
        this.saveAsDefaultMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Geotrans.this.saveAsDefaultActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveAsDefaultMenuItem);
        this.fileMenu.add(this.fileMenuSeparator);
        this.exitMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/geotrans/gui/icons/Stop16.gif")));
        this.exitMenuItem.setMnemonic(88);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Geotrans.this.exitActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.geotransMenuBar.add(this.fileMenu);
        this.editMenu.setMnemonic(69);
        this.editMenu.setText("Edit");
        this.cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.cutMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/geotrans/gui/icons/Cut16.gif")));
        this.cutMenuItem.setMnemonic(84);
        this.cutMenuItem.setText("Cut");
        this.cutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Geotrans.this.cutActionPerformed(evt);
            }
        });
        this.editMenu.add(this.cutMenuItem);
        this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.copyMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/geotrans/gui/icons/Copy16.gif")));
        this.copyMenuItem.setMnemonic(67);
        this.copyMenuItem.setText("Copy");
        this.copyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Geotrans.this.copyActionPerformed(evt);
            }
        });
        this.editMenu.add(this.copyMenuItem);
        this.pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.pasteMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/geotrans/gui/icons/Paste16.gif")));
        this.pasteMenuItem.setMnemonic(80);
        this.pasteMenuItem.setText("Paste");
        this.pasteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Geotrans.this.pasteActionPerformed(evt);
            }
        });
        this.editMenu.add(this.pasteMenuItem);
        this.geotransMenuBar.add(this.editMenu);
        this.optionsMenu.setMnemonic(79);
        this.optionsMenu.setText("Options");
        this.formatMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.formatMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/geotrans/gui/icons/Preferences16.gif")));
        this.formatMenuItem.setMnemonic(70);
        this.formatMenuItem.setText("Format . . .");
        this.formatMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Geotrans.this.formatActionPerformed(evt);
            }
        });
        this.optionsMenu.add(this.formatMenuItem);
        this.lookAndFeelMenu.setMnemonic(76);
        this.lookAndFeelMenu.setText("Look and Feel");
        this.metalRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(74, 2));
        this.metalRadioButtonMenuItem.setMnemonic(74);
        this.metalRadioButtonMenuItem.setSelected(true);
        this.metalRadioButtonMenuItem.setText("Java");
        this.metalRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Geotrans.this.lookAndFeelActionPerformed(evt);
            }
        });
        this.lookAndFeelMenu.add(this.metalRadioButtonMenuItem);
        this.unixRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        this.unixRadioButtonMenuItem.setMnemonic(85);
        this.unixRadioButtonMenuItem.setText("Unix");
        this.unixRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Geotrans.this.lookAndFeelActionPerformed(evt);
            }
        });
        this.lookAndFeelMenu.add(this.unixRadioButtonMenuItem);
        this.windowsRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.windowsRadioButtonMenuItem.setMnemonic(87);
        this.windowsRadioButtonMenuItem.setText("Windows");
        this.windowsRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Geotrans.this.lookAndFeelActionPerformed(evt);
            }
        });
        this.lookAndFeelMenu.add(this.windowsRadioButtonMenuItem);
        this.optionsMenu.add(this.lookAndFeelMenu);
        this.geotransMenuBar.add(this.optionsMenu);
        this.datumMenu.setMnemonic(68);
        this.datumMenu.setText("Datum");
        this.createDatumMenuItem.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        this.createDatumMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/geotrans/gui/icons/New16.gif")));
        this.createDatumMenuItem.setMnemonic(67);
        this.createDatumMenuItem.setText("Create . . .");
        this.createDatumMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Geotrans.this.createDatumActionPerformed(evt);
            }
        });
        this.datumMenu.add(this.createDatumMenuItem);
        this.deleteDatumMenuItem.setAccelerator(KeyStroke.getKeyStroke(115, 0));
        this.deleteDatumMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/geotrans/gui/icons/Delete16.gif")));
        this.deleteDatumMenuItem.setMnemonic(68);
        this.deleteDatumMenuItem.setText("Delete . . .");
        this.deleteDatumMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Geotrans.this.deleteDatumActionPerformed(evt);
            }
        });
        this.datumMenu.add(this.deleteDatumMenuItem);
        this.geotransMenuBar.add(this.datumMenu);
        this.ellipsoidMenu.setMnemonic(76);
        this.ellipsoidMenu.setText("Ellipsoid");
        this.createEllipsoidMenuItem.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.createEllipsoidMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/geotrans/gui/icons/New16.gif")));
        this.createEllipsoidMenuItem.setMnemonic(67);
        this.createEllipsoidMenuItem.setText("Create . . .");
        this.createEllipsoidMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Geotrans.this.createEllipsoidActionPerformed(evt);
            }
        });
        this.ellipsoidMenu.add(this.createEllipsoidMenuItem);
        this.deleteEllipsoidMenuItem.setAccelerator(KeyStroke.getKeyStroke(117, 0));
        this.deleteEllipsoidMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/geotrans/gui/icons/Delete16.gif")));
        this.deleteEllipsoidMenuItem.setMnemonic(68);
        this.deleteEllipsoidMenuItem.setText("Delete . . .");
        this.deleteEllipsoidMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Geotrans.this.deleteEllipsoidActionPerformed(evt);
            }
        });
        this.ellipsoidMenu.add(this.deleteEllipsoidMenuItem);
        this.geotransMenuBar.add(this.ellipsoidMenu);
        this.convertMenu.setMnemonic(67);
        this.convertMenu.setText("Convert");
        this.convertDownMenuItem.setAccelerator(KeyStroke.getKeyStroke(118, 0));
        this.convertDownMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/geotrans/gui/icons/Down16.gif")));
        this.convertDownMenuItem.setMnemonic(85);
        this.convertDownMenuItem.setLabel(" Upper to Lower");
        this.convertDownMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Geotrans.this.convertDownActionPerformed(evt);
            }
        });
        this.convertMenu.add(this.convertDownMenuItem);
        this.convertMenu.add(this.convertMenuSeparator);
        this.convertUpMenuItem.setAccelerator(KeyStroke.getKeyStroke(119, 0));
        this.convertUpMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/geotrans/gui/icons/Up16.gif")));
        this.convertUpMenuItem.setMnemonic(76);
        this.convertUpMenuItem.setLabel("Lower to Upper");
        this.convertUpMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Geotrans.this.convertUpActionPerformed(evt);
            }
        });
        this.convertMenu.add(this.convertUpMenuItem);
        this.geotransMenuBar.add(this.convertMenu);
        this.helpMenu.setMnemonic(72);
        this.helpMenu.setText("Help");
        this.contentsMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.contentsMenuItem.setMnemonic(67);
        this.contentsMenuItem.setText("Contents");
        this.contentsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Geotrans.this.helpContentsActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.contentsMenuItem);
        this.helpMenu.add(this.helpMenuSeparator);
        this.aboutMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.aboutMenuItem.setMnemonic(65);
        this.aboutMenuItem.setText("About GEOTRANS...");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Geotrans.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.geotransMenuBar.add(this.helpMenu);
        this.setJMenuBar(this.geotransMenuBar);
        this.pack();
    }

    private void restoreDefaultActionPerformed(ActionEvent evt) {
        if (this.defaultFile.exists()) {
            new RestoreDefault(this, this.defaultFile, this.upperMasterPanel, this.lowerMasterPanel, this.options);
        } else {
            JOptionPane.showMessageDialog(this, "File does not exist: " + this.defaultFile, "Error", 0);
        }
    }

    private void saveAsDefaultActionPerformed(ActionEvent evt) {
        new SaveAsDefault(this, this.defaultFile, this.upperMasterPanel, this.lowerMasterPanel, this.options);
    }

    private void convertUpButtonMouseReleased(MouseEvent evt) {
        this.convertUpButton.setBorder(new BevelBorder(0));
    }

    private void convertUpButtonMousePressed(MouseEvent evt) {
        this.convertUpButton.setBorder(new BevelBorder(1));
    }

    private void convertDownButtonMouseReleased(MouseEvent evt) {
        this.convertDownButton.setBorder(new BevelBorder(0));
    }

    private void convertDownButtonMousePressed(MouseEvent evt) {
        this.convertDownButton.setBorder(new BevelBorder(1));
    }

    private void convertButtonMouseReleased(MouseEvent evt) {
        UIManager.put("Button.select", this.defaultSelectedColor);
    }

    private void convertButtonMousePressed(MouseEvent evt) {
        UIManager.put("Button.select", this.currentColor);
    }

    private void createFileHeaderActionPerformed(ActionEvent evt) {
        new CreateFileHeaderDlg(this, true, this.currentDir, this.options).show();
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        new AboutDlg((Frame)this, true).show();
    }

    private void helpContentsActionPerformed(ActionEvent evt) {
        File helpFile = new File("..");
        try {
            if (StartBrowser.isWindowsPlatform()) {
                StartBrowser.displayURL(this, "file:" + helpFile.getCanonicalPath() + "\\help\\contents.htm");
            } else {
                StartBrowser.displayURL(this, "file:" + helpFile.getCanonicalPath() + "/help/contents.htm");
            }
        }
        catch (Exception e) {
            this.jniStrtoval.displayErrorMsg(this, "Could not invoke browser");
        }
    }

    private void lookAndFeelActionPerformed(ActionEvent evt) {
        try {
            if (this.metalRadioButtonMenuItem.isSelected()) {
                this.currLookAndFeel = "Java";
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            } else if (this.unixRadioButtonMenuItem.isSelected()) {
                this.currLookAndFeel = "Unix";
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
            } else if (this.windowsRadioButtonMenuItem.isSelected()) {
                String osName = System.getProperty("os.name");
                if (osName != null && osName.indexOf("Windows") != -1) {
                    this.currLookAndFeel = "Windows";
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                } else {
                    this.resetLookAndFeel();
                    this.jniStrtoval.displayErrorMsg(this, "This option is only available on a Windows platform");
                }
            }
            SwingUtilities.updateComponentTreeUI(this);
            this.upperMasterPanel.setLookAndFeel(this.currLookAndFeel);
            this.lowerMasterPanel.setLookAndFeel(this.currLookAndFeel);
        }
        catch (Exception e) {
            this.jniStrtoval.displayErrorMsg(this, e.getMessage());
        }
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    private void exitActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void openActionPerformed(ActionEvent evt) {
        JNIFiomeths jniFiomeths = new JNIFiomeths();
        JFileChooser jChooser1 = new JFileChooser(this.currentDir.getDirectory());
        jChooser1.addChoosableFileFilter(new DATFileFilter());
        jChooser1.setSelectedFile(new File("*.dat"));
        int state = jChooser1.showOpenDialog(this);
        if (state == 0) {
            File file = jChooser1.getSelectedFile();
            this.currentDir.setDirectory(file.getAbsolutePath());
            if (file != null) {
                try {
                    jniFiomeths.JNISetInputFilename(file.getPath());
                    new FileDlg(this, true, this.currentDir, this.options, jniFiomeths).show();
                }
                catch (GeotransError e) {
                    this.jniStrtoval.displayErrorMsg(this, e.getMessage());
                    jniFiomeths.JNICloseInputFile();
                }
                catch (JNIException e) {
                    this.jniStrtoval.displayErrorMsg(this, e.getMessage());
                    jniFiomeths.JNICloseInputFile();
                }
            }
        }
    }

    private void formatActionPerformed(ActionEvent evt) {
        FormatOptionsDlg formatOptionsDlg = new FormatOptionsDlg((Frame)this, true, this.options);
        formatOptionsDlg.show();
    }

    private void convertUpActionPerformed(ActionEvent evt) {
        boolean errorCode = false;
        try {
            this.lowerMasterPanel.setProjectionDir(0);
            this.lowerMasterPanel.setEngine();
            if (!this.lowerMasterPanel.JNIError() && !this.lowerMasterPanel.engineError()) {
                this.upperMasterPanel.setProjectionDir(1);
                this.upperMasterPanel.setEngine();
                if (!this.upperMasterPanel.JNIError() && !this.upperMasterPanel.engineError()) {
                    this.jniEngine.JNIConvert(1);
                } else {
                    errorCode = true;
                    this.upperMasterPanel.showErrors(this);
                }
            } else {
                errorCode = true;
                this.lowerMasterPanel.showErrors(this);
            }
        }
        catch (GeotransError e) {
            errorCode = true;
            this.jniStrtoval.displayErrorMsg(this, e.getMessage());
        }
        catch (GeotransWarning e) {
            errorCode = false;
            this.jniStrtoval.displayWarningMsg(this, e.getMessage());
        }
        catch (JNIException e) {
            errorCode = true;
            this.jniStrtoval.displayErrorMsg(this, e.getMessage());
        }
        if (!errorCode) {
            this.upperMasterPanel.getCoords(1);
            if (!this.upperMasterPanel.JNIError() && !this.upperMasterPanel.engineError()) {
                this.upperMasterPanel.reportAccuracy();
            } else {
                this.upperMasterPanel.showErrors(this);
            }
        }
    }

    private void convertDownActionPerformed(ActionEvent evt) {
        boolean errorCode = false;
        try {
            this.upperMasterPanel.setProjectionDir(0);
            this.upperMasterPanel.setEngine();
            if (!this.upperMasterPanel.JNIError() && !this.upperMasterPanel.engineError()) {
                this.lowerMasterPanel.setProjectionDir(1);
                this.lowerMasterPanel.setEngine();
                if (!this.lowerMasterPanel.JNIError() && !this.lowerMasterPanel.engineError()) {
                    this.jniEngine.JNIConvert(1);
                } else {
                    errorCode = true;
                    this.lowerMasterPanel.showErrors(this);
                }
            } else {
                errorCode = true;
                this.upperMasterPanel.showErrors(this);
            }
        }
        catch (GeotransError e) {
            errorCode = true;
            this.jniStrtoval.displayErrorMsg(this, e.getMessage());
        }
        catch (GeotransWarning e) {
            errorCode = false;
            this.jniStrtoval.displayWarningMsg(this, e.getMessage());
        }
        catch (JNIException e) {
            errorCode = true;
            this.jniStrtoval.displayErrorMsg(this, e.getMessage());
        }
        if (!errorCode) {
            this.lowerMasterPanel.getCoords(1);
            if (!this.lowerMasterPanel.JNIError() && !this.lowerMasterPanel.engineError()) {
                this.lowerMasterPanel.reportAccuracy();
            } else {
                this.lowerMasterPanel.showErrors(this);
            }
        }
    }

    private void deleteEllipsoidActionPerformed(ActionEvent evt) {
        new DeleteDlg((Frame)this, true, 1).show();
    }

    private void createEllipsoidActionPerformed(ActionEvent evt) {
        new CreateEllipsoidDlg((Frame)this, true).show();
    }

    private void deleteDatumActionPerformed(ActionEvent evt) {
        DeleteDlg deleteDatum = new DeleteDlg((Frame)this, true, 0);
        deleteDatum.show();
        this.upperMasterPanel.deleteDatumFromList(deleteDatum.getIndex());
        this.lowerMasterPanel.deleteDatumFromList(deleteDatum.getIndex());
    }

    private void createDatumActionPerformed(ActionEvent evt) {
        new CreateDatumDlg((Frame)this, true).show();
        this.upperMasterPanel.addDatumToList();
        this.lowerMasterPanel.addDatumToList();
    }

    private void editButtonMouseEntered(MouseEvent evt) {
        this.prevFocus = this.getFocusOwner();
    }

    private void pasteActionPerformed(ActionEvent evt) {
        Component focus = this.getFocusOwner();
        if (focus instanceof JTextComponent) {
            ((JTextComponent)focus).paste();
        } else if (this.prevFocus instanceof JTextComponent) {
            ((JTextComponent)this.prevFocus).paste();
        }
    }

    private void cutActionPerformed(ActionEvent evt) {
        Component focus = this.getFocusOwner();
        if (focus instanceof JTextComponent) {
            ((JTextComponent)focus).cut();
        } else if (this.prevFocus instanceof JTextComponent) {
            ((JTextComponent)this.prevFocus).cut();
        }
    }

    private void copyActionPerformed(ActionEvent evt) {
        Component focus = this.getFocusOwner();
        if (focus instanceof JTextComponent) {
            ((JTextComponent)focus).copy();
        } else if (this.prevFocus instanceof JTextComponent) {
            ((JTextComponent)this.prevFocus).copy();
        }
    }

    public static void main(String[] args) {
        new Geotrans().show();
    }

    public void check3DConversion() {
        boolean _3dConversion = false;
        if (this.upperMasterPanel.getProjectionType() == 0) {
            if (this.lowerMasterPanel.getProjectionType() == 0 || this.lowerMasterPanel.getProjectionType() == 3 || this.lowerMasterPanel.getProjectionType() == 4) {
                this.upperMasterPanel.enableHeightComboBox(true);
                this.upperMasterPanel.selectEllipsoidHeightButton();
                _3dConversion = true;
                this.upperMasterPanel.setHeightFieldEditable(true);
                if (this.lowerMasterPanel.getProjectionType() == 0) {
                    this.lowerMasterPanel.enableHeightComboBox(true);
                    this.lowerMasterPanel.selectEllipsoidHeightButton();
                    this.lowerMasterPanel.setHeightFieldEditable(true);
                }
            } else {
                this.upperMasterPanel.selectNoHeightButton();
                this.upperMasterPanel.setHeightText("0");
                this.upperMasterPanel.setHeightFieldEditable(false);
                this.upperMasterPanel.enableHeightComboBox(false);
            }
        } else if (this.lowerMasterPanel.getProjectionType() == 0) {
            if (this.upperMasterPanel.getProjectionType() == 3 || this.upperMasterPanel.getProjectionType() == 4) {
                this.lowerMasterPanel.enableHeightComboBox(true);
                this.lowerMasterPanel.selectEllipsoidHeightButton();
                _3dConversion = true;
                this.lowerMasterPanel.setHeightFieldEditable(true);
            } else {
                this.lowerMasterPanel.selectNoHeightButton();
                this.lowerMasterPanel.setHeightText("0");
                this.lowerMasterPanel.setHeightFieldEditable(false);
                this.lowerMasterPanel.enableHeightComboBox(false);
            }
        } else if (!(this.upperMasterPanel.getProjectionType() != 3 && this.upperMasterPanel.getProjectionType() != 4 || this.lowerMasterPanel.getProjectionType() != 3 && this.lowerMasterPanel.getProjectionType() != 4)) {
            _3dConversion = true;
        }
        this.upperMasterPanel.updateSrcErrors(_3dConversion);
        this.lowerMasterPanel.updateSrcErrors(_3dConversion);
    }

    public void checkValidConversion() {
        int validColor = this.jniEngine.JNICheckValidConversion(this.upperMasterPanel.getProjectionType(), this.lowerMasterPanel.getProjectionType(), this.upperMasterPanel.getDatumIndex(), this.lowerMasterPanel.getDatumIndex());
        if (validColor == 0) {
            this.currentColor = Red.VALUE;
        } else if (validColor == 1) {
            this.currentColor = Yellow.VALUE;
        } else if (validColor == 2) {
            this.currentColor = Green.VALUE;
        }
        this.convertUpButton.setBackground(this.currentColor);
        this.convertDownButton.setBackground(this.currentColor);
    }

    private void initialize() {
        boolean error = false;
        this.options = new jOptions();
        try {
            this.jniEngine.JNIInitializeEngine();
            this.upperMasterPanel = new MasterPanel(1, 0, this.options);
            if (this.upperMasterPanel == null) {
                this.jniStrtoval.displayErrorMsg(this, "Unable to initialize GEOTRANS");
                System.exit(0);
            }
            this.lowerMasterPanel = new MasterPanel(1, 1, this.options);
            if (this.lowerMasterPanel == null) {
                this.jniStrtoval.displayErrorMsg(this, "Unable to initialize GEOTRANS");
                System.exit(0);
            }
            this.upperMasterPanel.setParent(this);
            this.lowerMasterPanel.setParent(this);
            this.check3DConversion();
            this.checkValidConversion();
            this.upperPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            this.upperPanel.add((Component)this.upperMasterPanel, gridBagConstraints);
            gridBagConstraints.anchor = 16;
            this.lowerPanel.add((Component)this.lowerMasterPanel, gridBagConstraints);
        }
        catch (GeotransError e) {
            this.jniStrtoval.displayErrorMsg(this, e.getMessage());
            error = true;
        }
        catch (UnsatisfiedLinkError e) {
            this.jniStrtoval.displayErrorMsg(this, "Unsatisfied Link Error: " + e.getMessage());
            error = true;
        }
        if (error) {
            System.exit(0);
        }
    }

    private void resetLookAndFeel() {
        if (this.currLookAndFeel.equals("Java")) {
            this.metalRadioButtonMenuItem.setSelected(true);
        } else if (this.currLookAndFeel.equals("Unix")) {
            this.unixRadioButtonMenuItem.setSelected(true);
        } else if (this.currLookAndFeel.equals("Windows")) {
            this.windowsRadioButtonMenuItem.setSelected(true);
        }
    }

    static {
        System.loadLibrary("jnigeotrans");
    }
}

