#include "cp_types.h"
#include "cp_proto.h"

/* ================= redchain processing routines ============ 

build_redchain
redface_comb_info (find corners, paired edges, etc.)
next_red_edge
 and local subroutines
*/

struct RedList *build_redchain(struct p_data *p,int seed,
			       struct Vertlist *fdo)
/* Build red chain and fdo (face draw order) from seed, 
remaining cognizant of any poison verts. Calling routine
must store catalog of faces and emptied 'rwb_flags' before 
entering this routine. */
{
  int i,f,num,loop_count=0,hit_flag,stop,looplimit,*face_ptr;
  int debg=0,tripflag=0,sph_flag=0;
  int *rw_ptr;
  f_data *faces;
  struct RedList *redlist,*temp,*rtrace,*stop_ptr;
  struct K_data *pK_ptr;

  pK_ptr=p->packK_ptr;
  if (!(faces=p->faces) || !(rw_ptr=p->rwb_flags)) return NULL;
  if (p->f_util) free(p->f_util);
  p->f_util=(int *)calloc((size_t)(p->facecount+1),sizeof(int));

  /* start with faces about seed (assuming seed not poison) */

  face_ptr=face_org[seed]+1;
  num=pK_ptr[seed].num;
  redlist=temp=(struct RedList *)calloc((size_t)1,sizeof(struct RedList));
  redlist->face=f=*(face_ptr); /* first face */
  fdo->v=f;
  rw_ptr[f]++;
  faces[f].index_flag=find_index(p,f,seed);
  for (i=1;i<num;i++)
    {
      f=*(face_ptr+i);
      redlist->next=(struct RedList *)
	calloc((size_t)1,sizeof(struct RedList));
      rtrace=redlist;
      redlist=redlist->next;
      redlist->prev=rtrace;
      redlist->face=f;
      fdo=fdo->next=(struct Vertlist *)
	calloc((size_t)1,sizeof(struct Vertlist));
      fdo->v=f;
      rw_ptr[f]++;
      faces[f].index_flag=find_index(p,f,seed);
    }
  fdo->next=NULL;
  if (!pK_ptr[seed].bdry_flag) redlist->next=temp;
  else /* backtrack to get closed list */
    {
      for (i=num-2;i>0;i--)
	{
	  f=*(face_ptr+i);
	  redlist->next=(struct RedList *)
	    calloc((size_t)1,sizeof(struct RedList));
	  rtrace=redlist;
	  redlist=redlist->next;
	  redlist->prev=rtrace;
	  redlist->face=f;
	}
      redlist->next=temp;
    }
  temp->prev=redlist;

  /* ----------- main loop for the rest of the faces ---------------- */

  looplimit=(100)*p->nodecount; /* emergency limit */
  stop=0;
  hit_flag=1;
  while (hit_flag && !stop && loop_count<looplimit)
    {
      hit_flag=0;
      stop_ptr=redlist;
      /* one pass to get started */
      if (!loop_vert(p,&redlist,&fdo,&stop_ptr,&tripflag,0,&hit_flag))
	stop=1; /* redchain a closed flower */
      if (debg) 
	{if (hit_flag) record_redlist(redlist,p->facecount);
	ck_list(redlist);}
      /* multiple passes for loop-overs only */
      while (!stop && (tripflag<2) && loop_count<looplimit
	     && (sph_flag=loop_vert(p,&redlist,&fdo,
				    &stop_ptr,&tripflag,0,&hit_flag)))
	{
	  loop_count++;
	  while (p->f_util[redlist->face]
		 && tripflag<2) /* move on */
	    {
	      if (redlist==stop_ptr) 
		tripflag++;
	      redlist=redlist->next;
	    }
	  if (debg) 
	    {if (hit_flag) record_redlist(redlist,p->facecount);
	    ck_list(redlist);} 
	}
      if (loop_count==looplimit || !sph_flag) stop=1;
      tripflag=0;	   
      stop_ptr=redlist;
      /* multiple passes, allowing blues also */
      while (!stop && (tripflag<3) && loop_count<looplimit
	     && (sph_flag=loop_vert(p,&redlist,&fdo,
				    &stop_ptr,&tripflag,1,&hit_flag)))
	{
	  loop_count++;
	  while (p->f_util[redlist->face]
		 && tripflag<2) /* move on */
	    {
	      if (redlist==stop_ptr) 
		tripflag++;
	      redlist=redlist->next;
	    }
	  if (debg) 
	    {if (hit_flag) record_redlist(redlist,p->facecount);
	    ck_list(redlist);} 
	}
      /* a couple more passes, just to make sure */
      if (sph_flag) 
	for (i=1;i<3;i++) 
	  {
	    if (!loop_vert(p,&redlist,&fdo,&stop_ptr,
			   &tripflag,1,&hit_flag))
	      stop=1;
	    if (debg) 
	      {if (hit_flag) record_redlist(redlist,p->facecount);
	      ck_list(redlist);} 
	    loop_count++;
	  }
      else stop=1;
    } /* end of main while */

  if (p->f_util) {free(p->f_util);p->f_util=NULL;}
  if (loop_count==looplimit)
    {
      sprintf(msgbuf,"emergency exit in build_redchain.");
      emsg();
    }
  
  return redlist;
} /* build_redchain */

int loop_vert(struct p_data *p,struct RedList **redlist,
	      struct Vertlist **fdo,struct RedList **stop_ptr,
	      int *tripflag,int mode,int *hit)
     /* Find vert shared by current and next red faces and find fan of
contig red faces in vert's star. If vert is interior, not poison, and
remaining faces of its star are still free, then adjust red chain to loop
outside of vert. If mode flag is on, then try to add the face of star 
preceeding the fan to the red chain (e.g.,blue face). Don't add this 
face to red chain if vert and the other end of the edge between the 
new face and the fan face are both poison.

Reset redlist downstream in any case. Also, if red chain is changed, 
then reset stop_ptr to the new redlist; otherwise, stop_ptr 
remains as is.

Faces with util_flag set can be skipped; they are bdry verts with
whole star in red chain.

Return 0 if redchain is around single vert, otherwise return 1.
hit means there's been a change to red chain. */
{
  int cface,n,findex=0,bindex,eindex,i,j,num,*face_ptr,vert;
  int f,laso_flag=1,blue_flag=0;
  int *rw_ptr=p->rwb_flags;
  f_data *faces=p->faces;
  struct RedList *bzip,*new_seg,*tmp,*hold,*killit,*init_red,*trace;
  struct K_data *pK_ptr;

  pK_ptr=p->packK_ptr;
  bzip=init_red=*redlist;
  cface=(*redlist)->face;
  if (p->f_util[cface])
    {
      *redlist=(*redlist)->next;
      if (*redlist==*stop_ptr) 
	(*tripflag)++;
      return 1;
    }
  /* may need two passes if we're at a (current) "blue" vert,
     starting with vert NOT shared with red chain; only then go on
     to handle the usual vert (one shared with next red).
     Note: this ensures that this vert gets checked; also, blue_flag
     prevents util_flag from being set, so this vert doesn't get 
     overlooked later in the process. */

  n=nghb_tri(p,(*redlist)->next->face,cface);
  if ((*redlist)->next->face==(*redlist)->prev->face
      && pK_ptr[(vert=faces[cface].vert[(n=(n+2) % 3)])].num > 1)
    /* here 'vert' is the vert that cface doesn't shared with its ngbh
       in redchain. */
    {
      blue_flag=1;
      num=pK_ptr[vert].num;
      face_ptr=face_org[vert]+1;
      /* find index of cface */
      while (*(face_ptr+findex)!=cface && findex<(num-1)) findex++;
      eindex=bindex=findex; /* should all be same in this case */
      /* if vert is interior, see if we can loop 
	 red chain around the other side of it. */
      if (!pK_ptr[vert].bdry_flag) 
	{
	  i=bindex+1;
	  while ( (j=(i % num))!=eindex && laso_flag)
	    {
	      if (rw_ptr[*(face_ptr+j)]>0) laso_flag=0;
	      i++;
	    }

	  /* yes, we can loop around and vert is not poison */
	  if (laso_flag && pK_ptr[vert].util_flag!=-1) 
	    {
	      trace=(*redlist)->next; /* exit and entrance to blue face */
	      (*hit)++;
	      i=(findex+1) % num;
	      tmp=new_seg=(struct RedList *)
		calloc((size_t)1,sizeof(struct RedList));
	      new_seg->prev=bzip;
	      new_seg->face=*(face_ptr+i);
	      rw_ptr[new_seg->face]++;
	      add_face_order(p,fdo,new_seg->face,bzip->face);
	      i=(i+1) % num;
	      while ( i!=((findex+1) % num))
		{
		  hold=tmp;
		  tmp=tmp->next=(struct RedList *)
		    calloc((size_t)1,sizeof(struct RedList));
		  tmp->prev=hold;
		  tmp->face=*(face_ptr+i);
		  rw_ptr[tmp->face]++;
		  add_face_order(p,fdo,tmp->face,hold->face);
		  i=(i+1) % num;
		}
	      /* new red segment repeats blue cface;
		 insert new segment, point to new cface */
	      tmp->next=trace;
	      trace->prev=tmp;
	      bzip->next=new_seg;
	      (*redlist)=(*stop_ptr)=tmp;
	    }
	}
      if (mode && (pK_ptr[vert].bdry_flag || !laso_flag)) 
	/* add blue face next (clockwise) to cface, if possible */ 
	{
	  j=(eindex-1+num) % num; 
	  if ( ((pK_ptr[vert].bdry_flag && (eindex > 0)) 
		|| !pK_ptr[vert].bdry_flag)
	       && rw_ptr[*(face_ptr+j)]==0) 
	    {
	      f=*(face_ptr+j);
	      if (pK_ptr[vert].util_flag!=-1
		  || pK_ptr[faces[f].vert[nghb_tri(p,cface,f)]].
		  util_flag!=-1)
		{
		  add_face_order(p,fdo,f,(*redlist)->face);
		  add_face_to_redlist(p,f,redlist);
		  rw_ptr[f]++;
		  (*hit)++;
		  *stop_ptr=*redlist;
		} 
	    }
	}
    } /* end of special check when cface is blue */
  
  /* Now, move on to the usual vertex */
  bzip=*redlist; /* redlist may have moved, cface should be same */
  cface=(*redlist)->face;
  n=nghb_tri(p,(*redlist)->next->face,cface);
  vert=faces[cface].vert[n];
  num=pK_ptr[vert].num;
  face_ptr=face_org[vert]+1;
  /* find index of cface */
  findex=0;
  while (*(face_ptr+findex)!=cface && findex<(num-1)) findex++;
  /* find index of downstream face sharing vert; note, redlist gets 
     shifted at least one position downstream. */
  i=findex;
  while ( (*redlist)->next->face==*(face_ptr+((i+num-1) % num))
	  && (*redlist)->next->face!=cface ) 
    {
      *redlist=(*redlist)->next;
      if (*redlist==*stop_ptr) 
	(*tripflag)++;
      i--;
    }
  eindex= (num+i) % num;

  /* check if there's single outside vert of whole red chain; i.e.,
     complex must be a sphere. */
  if ((*redlist)->next->face==cface)
    {
      hold=*redlist;
      while (hold->next!=*redlist)
	{
	  if (find_index(p,hold->face,vert)<0) goto NOTSPH;
	  hold=hold->next;
	}
      return 0;
    }
 NOTSPH:  
  /* find index of upstream face */
  i=findex;
  while ( bzip->prev->face==*(face_ptr+((i+1) % num))
	  && bzip->prev->face!=cface )
    {
      bzip=bzip->prev;
      i++;
    }
  bindex=(i % num);
  if (pK_ptr[vert].bdry_flag && num>1 && eindex==0 
      && bindex==(num-1) && !blue_flag)
    /* whole fan is already red, this face and last face
       of fan are not blue; don't need to revisit this face */
    {
      hold=*redlist;
      while (hold->face!=*(face_ptr)) hold=hold->next;
      if (hold->prev->face!=hold->next->face)
	{
	  p->f_util[cface]=1;
	  *redlist=(*redlist)->next;
	  if (*redlist==*stop_ptr) 
	    (*tripflag)++;
	  return 1;
	}
    }

  /* Note: 'fan' of contig red faces containing cface in star
     of vert goes counterclockwise from eindex to bindex. First
     check if can loop over vert; otherwise, if face
     preceeding fan is free, we add it as blue face. */

  laso_flag=1;
  if (!pK_ptr[vert].bdry_flag) 
    {
      i=bindex+1;
      while ( (j=(i % num))!=eindex && laso_flag)
	{
	  if (rw_ptr[*(face_ptr+j)]!=0) laso_flag=0;
	  i++;
	}

      /* yes, we can and vert is not poison */
      if (laso_flag && pK_ptr[vert].util_flag!=-1)
	{
	  *stop_ptr=*redlist;
	  (*hit)++;
	  if ( (i=(bindex+1) % num)!=eindex ) /* new red segment */
	    {
	      tmp=new_seg=(struct RedList *)
		calloc((size_t)1,sizeof(struct RedList));
	      new_seg->prev=bzip;
	      new_seg->face=*(face_ptr+i);
	      rw_ptr[new_seg->face]++;
	      add_face_order(p,fdo,new_seg->face,bzip->face);
	      i++;
	      while ( (j=i % num)!=eindex)
		{
		  hold=tmp;
		  tmp=tmp->next=(struct RedList *)
		    calloc((size_t)1,sizeof(struct RedList));
		  tmp->prev=hold;
		  tmp->face=*(face_ptr+j);
		  rw_ptr[tmp->face]++;
		  add_face_order(p,fdo,tmp->face,hold->face);
		  i++;
		}
	    }
	  else /* no new red */
	    {
	      tmp=bzip;
	      new_seg=*redlist;
	    }
	  killit=bzip->next; /* ptr to old segment */
	  /* insert new red segment (and detach old) */
	  (*redlist)->prev=tmp;
	  tmp->next=(*redlist);
	  bzip->next=new_seg;
	  /* now kill old segment */
	  while (killit!=*redlist)
	    {
	      hold=killit->next;
	      rw_ptr[killit->face]--; /* drop count by 1 */
	      if (rw_ptr[killit->face]==0) /* if this face is no longer
					       in red chain, make it white */
		rw_ptr[killit->face]--; 
	      free(killit);
	      killit=hold;
	    }		
	  (*hit)++;
	}
    }
  if (mode && (pK_ptr[vert].bdry_flag || !laso_flag)) 
    /* add blue face next (clockwise) to fan, if possible. */ 
    {
      j=(eindex-1+num) % num; 
      if ( ((pK_ptr[vert].bdry_flag && (eindex > 0)) 
	    || !pK_ptr[vert].bdry_flag)
	   && rw_ptr[*(face_ptr+j)]==0) 
	{
	  f=*(face_ptr+j);
	  cface=*(face_ptr+((j+1) % num));
	  if (pK_ptr[vert].util_flag!=-1 
	      || pK_ptr[faces[f].vert[nghb_tri(p,cface,f)]].util_flag!=-1)
	    {
	      add_face_order(p,fdo,f,(*redlist)->face);
	      add_face_to_redlist(p,f,redlist);
	      rw_ptr[f]++;
	      *stop_ptr=*redlist;
	      (*hit)++;
	    }
	}
    }

  return 1;
} /* loop_vert */

int redface_comb_info(struct p_data *p,struct RedList *redlist,
		      struct EdgePair *edge_pair)
     /* Go through given red face list to find 'corners', identified 
segments, cross faces, etc. 'blue' faces always an annoyance -- they 
have two edges to worry about. Note: in very pathological situation, 
face can be in red chain 3 times; the program will probably crash. */
{
  int i,share_vert,post_vert,click=0,debg=0,vert;
  int indx,rev_indx,fore_indx,back_indx;
  int seg_count=0,pair_count=0,pair_flag;
  int wflag=0,current_color=201,color,v,w;
  f_data *faces;
  struct RedList *trace,*rev_trace,*hold;
  struct RedList *first_edge=NULL;
  struct RedList *fore_face,*back_face,*temp;

  faces=p->faces;
  if (redlist->next->face==redlist->prev->face)
    redlist=redlist->next; /* avoid starting at blue face */

  /* Each face is 'responsible' (due to red chain drawing 
     order) for placing one circle (other faces may place the same 
     circle in other spots). v_flag is index of this circle in
     face verts; this is the circle NOT shared with the
     previous face in the red chain. */

  /* OLD???: except for blue faces, the edge
     ENDING at that vert is an open edge (ie, either bdry edge or 
     paired edge). Note: face before a blue face is responsible
     for a vertex two edges along the red edges --- it has to be
     in place before the blue face can be drawn. */

  trace=redlist;
  indx=nghb_tri(p,trace->prev->face,trace->face);
  share_vert=faces[trace->face].vert[(indx+1) % 3];
  while (trace!=redlist || !(wflag++))
    {
      trace->v_flag=(nghb_tri(p,trace->prev->face,trace->face)+2) % 3;
      post_vert=faces[trace->face].vert[
	nghb_tri(p,trace->next->face,trace->face)];
      if (post_vert!=share_vert) /* found new edge? */
	{
	  if (click)
	    {
	      hold->next_edge=trace;
	      hold=trace;
	    }
	  else /* this is first face with edge in red chain. */
	    {
	      first_edge=hold=trace;
	      click=1;
	    }
	}
      share_vert=post_vert;
      trace=trace->next;
    }
  /* link last edge to first */
  hold->next_edge=first_edge;

  /* debug */
  if (debg) red_bug(redlist);


  /* store all cross-face data */

  click=-1;
  wflag=0;
  trace=first_edge;
  while (trace!=first_edge || !(wflag++) )
    {
      indx=(nghb_tri(p,trace->prev->face,trace->face)+1) % 3;
      if (!trace->cross[indx])
	{
	  w=faces[trace->face].vert[indx];
	  v=faces[trace->face].vert[(indx+1) % 3];
	  /* search for match up to first_edge */
	  fore_face=trace->next_edge;
	  while (fore_face!=first_edge)
	    {
	      if ((fore_indx=check_face(p,fore_face->face,v,w))>=0)
		{
		  trace->cross[indx]=fore_face;
		  fore_face->cross[fore_indx]=trace;
		  fore_face=first_edge; /* to break out of while */
		  click++;
		}
	      else fore_face=fore_face->next_edge;
	    }
	}
      if (trace->next->face==trace->prev->face
	  && !trace->cross[(indx+1) % 3]) /* blue face, second edge */
	{
	  w=faces[trace->face].vert[(indx+1) % 3];
	  v=faces[trace->face].vert[(indx+2) % 3];
	  fore_face=trace->next_edge;
	  while (fore_face!=first_edge)
	    {
	      if ((fore_indx=check_face(p,fore_face->face,v,w))>=0)
		{
		  trace->cross[(indx+1) % 3]=fore_face;
		  fore_face->cross[fore_indx]=trace;
		  fore_face=first_edge; /* to break out of while */
		  click++;
		}
	      else fore_face=fore_face->next_edge;
	    }
	}
      trace=trace->next_edge;
    }

  /* debug */
  if (debg) red_bug(redlist);

  if (click<0) /* no pairings found? iff complex simply connected */
    {
      edge_pair[1].edge=redlist;
      edge_pair[1].edge->corner_flag[edge_pair[1].edge->v_flag]=3;
          /* Note: 3 indicates both start and end vert */
      if ((indx=nghb_tri(p,redlist->next->face,redlist->face))>=0)
	back_red_face(p,&edge_pair[1].edge,faces[redlist->face].
		      vert[indx]);
      return 1;
    }

  /* eliminate as many blue faces as possible; remain cognizant 
     of poison verts (check to make sure util_flag still reflects
     poison). */
  trace=redlist;
  do
    {
      click=0;
      trace=redlist->next;
      while (trace!=redlist)
	{
	  if (trace->next->face==trace->prev->face
	      && (fore_face=trace->cross[
	        (indx=((nghb(p,trace->prev->face,trace->face)+1) % 3))])
	      && (back_face=trace->cross[(indx+2) % 3])
	      && back_face->next_edge==fore_face
	      && p->packK_ptr[faces[trace->face].
			     vert[trace->v_flag]].util_flag!=-1)
	    {
	      click++;
	      if (trace==first_edge) first_edge=trace->next_edge;
	      /* fix up new location */
	      if (fore_face->next->face==fore_face->prev->face) wflag=1;
	      else wflag=0; /* flag if blue */
	      hold=back_face->next;
	      /* toss out old */
	      while ((temp=hold)!=fore_face) /* toss out old */
		{
		  hold=hold->next;
		  if (temp==redlist) redlist=hold;
		  free(temp);
		}

	      /* create and fill new */
	      back_face->next=fore_face->prev=temp=
		(struct RedList *)calloc((size_t)1,sizeof(struct RedList));
	      temp->prev=back_face;
	      temp->next=fore_face;
	      temp->face=trace->face;
	      indx=(nghb_tri(p,back_face->face,temp->face)+1) % 3;
	      temp->cross[indx]=trace->next;
	      temp->v_flag=(indx+1) % 3;
	      if (wflag) temp->next_edge=fore_face;
	      else 
		{
		  temp->next_edge=fore_face->next_edge;
		  fore_face->next_edge=NULL;
		}

	      /* fix back_face */
	      back_indx=nghb_tri(p,temp->face,back_face->face);
	      back_face->cross[back_indx]=NULL;
	      back_indx=(nghb_tri(p,back_face->prev->face,
				  back_face->face)+2) % 3;
	      back_face->v_flag=back_indx;
	      back_face->next_edge=NULL;
	      vert=faces[back_face->face].vert[
		nghb_tri(p,temp->face,back_face->face)];
	      hold=temp;
	      back_red_face(p,&hold,vert);
	      hold->next_edge=temp;

	      /* fix fore_face */
	      fore_indx=nghb_tri(p,temp->face,fore_face->face);
	      fore_face->cross[fore_indx]=NULL;
	      fore_face->v_flag=(fore_indx+2) % 3;
	      hold=temp;

	      /* remove old (keep trace->next, toss trace and trace->prev) */
	      temp=trace->prev;
	      back_face=trace->prev->prev;
	      fore_face=trace->next;

	      /* fix fore_face (former trace->next) */
	      indx=(nghb_tri(p,back_face->face,fore_face->face)+1) % 3;
	      fore_face->v_flag=(indx+1) % 3;
	      fore_face->cross[(indx+2) % 3]=temp->cross[(indx+2) % 3];
	      fore_face->cross[indx]=hold; /* transplanted face */
	      fore_face->prev=back_face;
	      if (trace->next_edge!=fore_face)
		fore_face->next_edge=trace->next_edge;

	      /* fix back_face */
	      back_face->next=fore_face;
	      vert=faces[temp->face].vert[
		nghb_tri(p,trace->face,temp->face)];
	      hold=trace;
	      back_red_face(p,&hold,vert);
	      if (hold!=fore_face)
		hold->next_edge=fore_face;	     
	      if (temp==redlist) redlist=temp->prev;
	      free(temp);
	      hold=trace;
	      trace=fore_face;
	      if (hold==redlist) redlist=back_face;
	      free(hold);
	    }
	  else trace=trace->next;
	} /* end of while */
    } while (click); /* end of do (Has to stop: each instance
			reduces number of red edges by one.) */

  if (debg) red_bug(redlist);

  /* Now we find and mark all corner verts. Along the way we
     keep record the first 'edge_pair' start info. Then when
     we're done recording corner info, we can use this first edge
     to get started on recording the remaining edge_pair info. */

  trace=first_edge;
  indx=(nghb_tri(p,trace->prev->face,trace->face)+1) % 3;
  wflag=0;
  while ((trace!=first_edge) || !(wflag++)) 
    /* Note that we must always come into this 'while' loop with 
       trace having an edge and indx set to first end of that edge. */
    {
      if ((rev_trace=trace->cross[indx])) /* found a paired edge? */
	{
	  next_red_edge(p,trace,indx,&fore_face,&fore_indx,1);
	  rev_indx=nghb_tri(p,trace->face,rev_trace->face);
	  next_red_edge(p,rev_trace,rev_indx,&back_face,&back_indx,-1);

   	  /* is it an 'end' corner? */
	  if (fore_face->cross[fore_indx]!=back_face)
	    {
	      trace->corner_flag[(indx+1) % 3] |= 2; /* end corner */

	      /* is it a beginning corner also? */
	      if (fore_face->cross[fore_indx])
		{
		  trace->corner_flag[(indx+1) % 3] |= 1; /* begin corner */
		  if (!edge_pair[1].edge)
		    {
		      edge_pair[1].edge=trace;
		      edge_pair[1].edge_indx=(indx+1) % 3;
		      edge_pair[1].color=current_color;
		      current_color++;
		    }
		}
	    }
	}
      else /* if not paired, is it a 'begin' corner (ie, is next red paired? */
	{
	  next_red_edge(p,trace,indx,&fore_face,&fore_indx,1);
	  if (fore_face->cross[fore_indx])
	    {
	      trace->corner_flag[(indx+1) % 3] |= 1; /* begin corner */
	      if (!edge_pair[1].edge)
		{
		  edge_pair[1].edge=trace;
		  edge_pair[1].edge_indx=(indx+1) % 3;
		  edge_pair[1].color=current_color;
		  current_color++;
		}
	    }
	}
      /* blue face, first edge, adjust indx and come through again */
      if (trace->next->face==trace->prev->face
	  && trace->v_flag==(indx+1) % 3)
	indx=(indx+1) % 3;
      else
	{
	  trace=trace->next_edge;
	  indx=(nghb_tri(p,trace->prev->face,trace->face)+1) % 3;
	}
    }/* end of while */

  /* debug */
  if (debg) red_bug(redlist);

  /* First edge_pair start is now known. We proceed to find and store 
     the rest of border and paired segments and data.
     In non-simply connected case, there must be some paired 
     segments; every border segment is associated with a 
     component of the border and will necessarily be preceeded 
     and followed by paired segments. (Identify it by finding an end
     to a paired segment which is NOT also the beginning of another
     paired segment.) */

  trace=edge_pair[1].edge;
  indx=edge_pair[1].edge_indx;
  find_paired_start(p,trace,indx,
		    &(edge_pair[1].mate),&(edge_pair[1].mate_indx));
  find_seg_start(p,trace,indx,&trace,&indx,&v,&pair_flag);
  
  seg_count=pair_count=1;
  while (trace!=edge_pair[1].edge || indx!=edge_pair[1].edge_indx)
    {
      
      color=current_color; /* trace and indx should point to start vert 
			      of side-paired or border segment. 
			      (Note: it's the next_edge which is 
			      actually the first EDGE of the segment.) */
      find_paired_start(p,trace,indx,&back_face,&back_indx);

      /* If this start is already a 'mate', use same color */
      for (i=1;i<=seg_count;i++)
	if (edge_pair[i].edge==back_face &&
	    edge_pair[i].edge_indx==back_indx)
	  {
	    color=edge_pair[i].color;
	    i=seg_count+1; /* to exit loop */
	  }
      seg_count++;
      edge_pair[seg_count].edge=trace;
      edge_pair[seg_count].edge_indx=indx;
      if (pair_flag)
	{
	  edge_pair[seg_count].color=color;
	  edge_pair[seg_count].mate=back_face;
	  edge_pair[seg_count].mate_indx=back_indx;
	  pair_count++;
	  if (color==current_color) current_color++;
	}
      else edge_pair[seg_count].color=FG_COLOR;
      find_seg_start(p,trace,indx,&trace,&indx,&v,&pair_flag);
    } /* end of while */

  /* debug */
  if (debg) 
    {
      red_bug(redlist);
      record_edge_pair(p);
    }

  /*  sprintf(msgbuf,"Red chain segment count = %d, "
	  "pairing count = %d, number of bdry components is %d.",
	  seg_count,pair_count,p->num_bdry_comp);
	  msg();   */

  return 1;
} /* redface_comb_info */
				       
int find_seg_start(struct p_data *p,struct RedList *redlist,
		   int indx,struct RedList **start_ptr,
		   int *start_indx,int *vert,int *flag)
     /* Given spot_ptr in red chain, find next 'start' for a bdry segment. 
Often, indx already points to a start but we want the NEXT start; 
thus, generally don't return current location. However, if indx is set
to -1, then it might return the current location if it's a start and 
it will set an appropriate index. Return 1 on success. flag set to 
indicate this is paired (vs border) segment. */
{
  int count=0;
  f_data *faces;

  if (!redlist) return 0;
  *flag=0;
  faces=p->faces;
  while (!redlist->next_edge) /* no free edge in this face */
    {
      redlist=redlist->next;
      indx=-1; /* given indx must be outdated */
    }
  if (indx>=0)
    {
      if (redlist->next->face==redlist->prev->face 
	  && redlist->v_flag==indx)   /* blue face, first edge;
					 skip this, but try second */
	indx=(indx+1) % 3;
      else
	{
	  redlist=redlist->next_edge;
	  indx=(nghb_tri(p,redlist->prev->face,redlist->face)+2) % 3;
	}
    }
  if (indx<0) /* must choose indx to try; note: if blue face,
		 this yields first edge. */
    indx=(nghb_tri(p,redlist->prev->face,redlist->face)+2) % 3;
  while (count < p->facecount)
    {
      if (redlist->corner_flag[indx] & 3)
	{
	  *start_ptr=redlist;
	  *start_indx=indx;
	  *vert=faces[redlist->face].vert[indx];
	  if (redlist->corner_flag[indx] & 1) *flag=1;
	  return 1;
	}
      if (redlist->next->face==redlist->prev->face
	  && redlist->v_flag==indx) /* blue face, first edge;
				       loop thru to try second. */
	{
	  indx=(indx+1) % 3;
	}
      else 
	{
	  redlist=redlist->next_edge;
	  indx=(nghb_tri(p,redlist->prev->face,redlist->face)+2) % 3;
	}
      count++;
    }
  if (count==p->facecount) return 0; /* error in data */
  return 1;
} /* find_seg_start */

int back_red_face(struct p_data *p,struct RedList **redlist,int vert)
     /* back through red face list while faces share vert */
{
  int n;

  while ((n=nghb_tri(p,(*redlist)->face,(*redlist)->prev->face))>=0
	 && p->faces[(*redlist)->prev->face].vert[n]==vert)
    (*redlist)=(*redlist)->prev;
  return 1;
} /* back_red_face */

int next_red_edge(struct p_data *p,struct RedList *spot_ptr,int indx,
		  struct RedList **down_ptr,int *down_indx,int dir)
     /* From spot_ptr in red chain with open edge, find next red face 
   with contiguous edge; dir=1, forward; dir=-1, backward search. 
   ('Index' for edge here means first end (counterclkw) */
{
  int vert;
  f_data *faces;
  struct RedList *trace;

  faces=p->faces;
  /* look forward */
  if (dir==1) 
    {
      vert=faces[spot_ptr->face].vert[(indx+1) % 3];
      if (spot_ptr->next->face==spot_ptr->prev->face
	  && spot_ptr->v_flag==(indx+1) % 3) /* blue face; pass back same
						face, index to second edge */
	{
	  *down_ptr=spot_ptr;
	  *down_indx=(indx+1) % 3;
	  return 1;
	}
      if (!(*down_ptr=spot_ptr->next_edge)
	  || (*down_indx=find_index(p,spot_ptr->next_edge->face,vert))<0)
	{
	  *down_indx=0;
	  return 0;
	}
      return 1;
    }
  /* look backward */
  if (spot_ptr->next->face==spot_ptr->prev->face
      && spot_ptr->v_flag==indx) /* blue face at second edge; 
				    pass back index to first */
    {
      *down_ptr=spot_ptr;
      *down_indx=(indx+2) % 3;
      return 1;
    }  
  trace=spot_ptr->prev;
  while ((trace!=spot_ptr) && !trace->next_edge)
    trace=trace->prev;
  vert=faces[spot_ptr->face].vert[indx];
  if (((*down_ptr)=trace)==spot_ptr
      || (*down_indx=(find_index(p,trace->face,vert)+2) % 3)<0) /* error */
    {
      *down_ptr=NULL;
      *down_indx=0;
      return 0;
    }
  return 1;
} /* next_red_edge */

int find_paired_start(struct p_data *p,struct RedList *redlist,int indx,
		      struct RedList **end_ptr,int *end_indx)
     /* Given start of paired segment (face and indx to 'begin' vert), 
set the start data for its mate. Return 0 on failure. */
{
  struct RedList *trace;
  int trace_indx;

  if (!(redlist->corner_flag[indx] & 1)) /* not paired start */
    return 0;
  next_red_edge(p,redlist,((indx+2) % 3),&trace,&trace_indx,1);
  if (!trace || !((*end_ptr)=trace->cross[trace_indx]) /* error */
      || ((*end_indx)=nghb_tri(p,trace->face,(*end_ptr)->face)) < 0) 
    return 0;
  do
    {
      next_red_edge(p,*end_ptr,*end_indx,end_ptr,end_indx,-1);
    } while (!((*end_ptr)->corner_flag[((*end_indx)+1) % 3] & 1));
  *end_indx=((*end_indx)+1) % 3;
  return 1;
} /* find_paired_start */

int add_face_to_redlist(struct p_data *p,int f,struct RedList **redptr)
     /* add face to double linked list; duplicate redptr, add new item 
between, then shift redptr to new (downstream) redptr. */
{
  struct RedList *trace,*dup,*newitem;

  trace=(*redptr)->next;
  newitem=(struct RedList *)
    calloc((size_t)1,sizeof(struct RedList));
  dup=newitem->next=(struct RedList *)
    calloc((size_t)1,sizeof(struct RedList));
  *dup=**redptr;
  dup->next=trace;
  trace->prev=dup;
  dup->prev=newitem;
  newitem->prev=*redptr;
  (*redptr)->next=newitem;
  newitem->face=f;
  *redptr=dup;
  return 1;
} /* add_face_to_redlist */

int query_in_red(struct RedList *redlist,int face)
     /* is face in redlist? */
{
  struct RedList *temp;

  if (redlist->face==face) return 1;
  temp=redlist->next;
  while (temp!=redlist)
    {
      if (temp->face==face) return 1;
      temp=temp->next;
    }
  return 0;
} /* query_in_red */

int add_face_order(struct p_data *p,struct Vertlist **fdo,
		   int face,int preface)
     /* Add face at end of draw order; assume nghb preface is 
already drawn to set index. */
{
  int n;
  f_data *faces;

  faces=p->faces;
  (*fdo)=(*fdo)->next=
    (struct Vertlist*)calloc((size_t)1,sizeof(struct Vertlist));
  (*fdo)->v=face;
  (*fdo)->next=NULL;
  n=nghb_tri(p,preface,face);
  if (n<0) 
    faces[face].index_flag=0; /* shouldn't happen */ 
  else faces[face].index_flag=n;
  return 1;
} /* add_face_order */

