#include "cp_types.h"
#include "cp_proto.h"

/* from bdry v to ngb interior w, open edge. 0 for
failure. */

int open_edge(struct p_data *p,int v,int w)
{
  int new,ind,back,k,u,*newflower;
  double *newoverlaps;
  struct K_data *pK_ptr;
  struct R_data *pR_ptr;

  pK_ptr=p->packK_ptr;
  pR_ptr=p->packR_ptr;
  if (v<0 || v>p->nodecount || !pK_ptr[v].bdry_flag 
      || (ind=nghb(p,v,w))<0 || pK_ptr[w].bdry_flag)
    return 0;
  /* new vert */
  new=p->nodecount+1;
  if ( (p->nodecount+1) > (p->sizelimit)
       && !alloc_pack_space(p,new,1) )
    {
      sprintf(msgbuf,
	      "Space allocation problem with adding vertex.");
      emsg();
      return 0;
    }
  pK_ptr[new].num=pK_ptr[v].num-ind;
  pK_ptr[new].flower=(int *)calloc((size_t)(pK_ptr[new].num+1),
				   sizeof(int));
  for (k=0;k<=pK_ptr[new].num;k++)
    pK_ptr[new].flower[k]=pK_ptr[v].flower[k+ind];
  if (p->overlap_status) 
    {
      pK_ptr[new].overlaps=(double *)
	calloc((size_t)(pK_ptr[new].num+1),sizeof(double));
      for (k=0;k<=pK_ptr[new].num;k++)
	pK_ptr[new].overlaps[k]=pK_ptr[v].overlaps[k+ind];
    }
  else pK_ptr[new].overlaps=NULL;
  pK_ptr[new].bdry_flag=1;
  pR_ptr[new].aim=-1.0;
  pR_ptr[new].rad=pR_ptr[v].rad;
  pR_ptr[new].center=pR_ptr[v].center;
  /* fix its ngb's flowers */
  for (k=1;k<=pK_ptr[new].num;k++)
    {
      back=nghb(p,(u=pK_ptr[v].flower[k+ind]),v);
      pK_ptr[u].flower[back]=new;
      if (!back && !pK_ptr[u].bdry_flag)
	pK_ptr[u].flower[pK_ptr[u].num]=new;
    }
  /* fix v's flower */
  newflower=(int *)calloc((size_t)(ind+1),sizeof(int));
  for (k=0;k<=ind;k++) newflower[k]=pK_ptr[v].flower[k];
  free(pK_ptr[v].flower);
  pK_ptr[v].flower=newflower;
  if (pK_ptr[v].overlaps) 
    {
      newoverlaps=(double *)calloc((size_t)(ind+1),sizeof(double));
      for (k=0;k<=ind;k++)
	newoverlaps[k]=pK_ptr[v].overlaps[k];
      free(pK_ptr[v].overlaps);
      pK_ptr[v].overlaps=newoverlaps;
    }
  pK_ptr[v].num=ind;
  /* fix w */
  back=nghb(p,w,v);
  newflower=(int *)calloc((size_t)(pK_ptr[w].num+1),sizeof(int));
  for (k=0;k<pK_ptr[w].num;k++)
    newflower[k]=pK_ptr[w].flower[(k+back) % pK_ptr[w].num];
  newflower[pK_ptr[w].num]=new;
  free(pK_ptr[w].flower);
  pK_ptr[w].flower=newflower;
  if (pK_ptr[w].overlaps)
    {
      newoverlaps=(double *)calloc((size_t)(pK_ptr[w].num+1),
				   sizeof(double));
      for (k=0;k<pK_ptr[w].num;k++)
	newoverlaps[k]=pK_ptr[w].overlaps[(k+back) % pK_ptr[w].num];
      newoverlaps[pK_ptr[w].num]=pK_ptr[w].overlaps[back];
      free(pK_ptr[w].overlaps);
      pK_ptr[w].overlaps=newoverlaps;
    }
  pK_ptr[w].bdry_flag=1;
  pR_ptr[w].aim=-1.0;
  p->nodecount++;
  return 1;
} /* open_edge */
