#include "cp_types.h"
#include "cp_proto.h"

/* given vertlist, string together as many as form a valid edgelist. */

struct Edgelist *node_to_edge(struct p_data *p,struct Vertlist *vertlist)
{
  int v,w;
  struct Vertlist *vtrace,*vclobber;
  struct Edgelist *edgelist,*etrace;

  edgelist=NULL;
  /* remove repeats in vertlist */
  vtrace=vertlist;
  while (vtrace!=NULL)
    {
      if (vtrace->next!=NULL && vtrace->v==vtrace->next->v)
	{
	  vclobber=vtrace->next;
	  vtrace->next=vtrace->next->next;
	  free(vclobber);
	}
      else vtrace=vtrace->next;
    }
  /* get started */
  if (vertlist==NULL || vertlist->next == NULL
      || (v=vertlist->v) <1 || v > p->nodecount
      || nghb(p,v,(w=vertlist->next->v))<0) return edgelist;
  edgelist=(struct Edgelist *)calloc((size_t)1,sizeof(struct Edgelist));
  edgelist->v=v;
  edgelist->w=w;
  etrace=edgelist;
  vtrace=vertlist->next->next;
  while (vtrace!=NULL)
    {
      v=w;
      w=vtrace->v;
      if (nghb(p,v,w)<0) return edgelist; /* chain broken */
      etrace->next=(struct Edgelist *)
	calloc((size_t)1,sizeof(struct Edgelist));
      etrace=etrace->next;
      etrace->v=v;
      etrace->w=w;
      vtrace=vtrace->next;
    }
  return edgelist;
} /* node_to_edge */
