#include "cp_types.h"
#include "cp_proto.h"

int vertex_translation(struct Edgelist *vertex_map,int v)
     /* find image of v in vertex_map. Return -1 on failure. */
{
  struct Edgelist *trace;

  if (!vertex_map) return -1;
  trace=vertex_map;
  while (trace)
    {
      if (trace->v==v) return trace->w;
      trace=trace->next;
    }
  return -1;
} /* vertex_translation */

int vertex_rev_translation(struct Edgelist *vertex_map,int w)
     /* find entry in vertex_map matched to w. Return 0 on failure. */
{
  struct Edgelist *trace;

  if (!vertex_map) return 0;
  trace=vertex_map;
  while (trace)
    {
      if (trace->w==w) return trace->v;
      trace=trace->next;
    }
  return 0;
} /* vertex_rev_translation */

int face_translation(struct p_data *p,int nf,struct p_data *q)
     /* translate face nf of p to q, if it exists. Return 0 on failure. */
{
  if (!p->status || !q->status || nf < 0 || nf > p->facecount
      || !p->vertex_map) return 0;
  return ( what_face(q,
		     vertex_translation(p->vertex_map,p->faces[nf].vert[0]),
		     vertex_translation(p->vertex_map,p->faces[nf].vert[1]),
		     vertex_translation(p->vertex_map,p->faces[nf].vert[2])) );
} /* face_translation */

int face_rev_translation(struct p_data *p,int nf,struct p_data *q)
     /* translate face nf of q to p, if it exists. Return 0 on failure. */
{
  if (!p->status || !q->status || nf < 0 || nf > q->facecount 
      || !p->vertex_map) return 0;
  return ( what_face(p,
		     vertex_rev_translation(p->vertex_map,
					    q->faces[nf].vert[0]),
		     vertex_rev_translation(p->vertex_map,
					    q->faces[nf].vert[1]),
		     vertex_rev_translation(p->vertex_map,
					    q->faces[nf].vert[2])) );
} /* face_rev_translation */

int map_list(struct p_data *p,struct p_data *q,char *datastr,
	     int mode,int rev_flag)
/* this forms Vlist (mode=1) or Flist (mode=2) using pack p 
'vertex_map' to translate indices. For faces, must have target
pack q specified. rev_flag means to translate using the inverse 
of vertex_map, so this goes from indices of q to those of p, but
still using vertex_map of p. */
{
  int hits,count=1,max_num=1,*trans_vec=NULL;
  char *endptr;
  struct Vertlist *list=NULL,*trace,*oldtrace;
  struct Edgelist *etrace;

  if (!p->status || !p->vertex_map || !q->status) return 0;
  /* for efficiency, move vectex_map stuff to vector */
  if (rev_flag)
    {
      etrace=p->vertex_map;
      while (etrace) 
	{
	  max_num = (etrace->w>max_num) ? etrace->w : max_num;
	  etrace=etrace->next;
	}
      trans_vec=(int *)calloc((size_t)(max_num+1),sizeof(int));
      etrace=p->vertex_map;
      while (etrace && etrace->w>0)
	{
	  trans_vec[etrace->w]=etrace->v;
	  etrace=etrace->next;
	}
    }
  else
    {
      trans_vec=(int *)calloc((size_t)(p->nodecount+1),sizeof(int));
            etrace=p->vertex_map;
      while (etrace && etrace->v>0 && etrace->v<=p->nodecount)
	{
	  trans_vec[etrace->v]=etrace->w;
	  etrace=etrace->next;
	}
    }

  if (mode==2) /* faces */
    {
      if (rev_flag) list=Face_link_parse(q,datastr,&endptr,&hits,&Vlist,
			 &Elist,&Flist,&region,pathlist,pathlength);
      else list=Face_link_parse(p,datastr,&endptr,&hits,&Vlist,
			 &Elist,&Flist,&region,pathlist,pathlength);
      trace=list;
      while (trace)
	{
	  if (rev_flag) trace->v=what_face(p,
			trans_vec[q->faces[trace->v].vert[0]],
			trans_vec[q->faces[trace->v].vert[1]],
			trans_vec[q->faces[trace->v].vert[2]]);
	  else trace->v=what_face(q,
			trans_vec[p->faces[trace->v].vert[0]],
			trans_vec[p->faces[trace->v].vert[1]],
			trans_vec[p->faces[trace->v].vert[2]]);
	  trace=trace->next;
	}
    }
  else /* circles */
    {
      if (rev_flag) list=Node_link_parse(q,datastr,&endptr,&hits,
		         &Vlist,&Elist,&Flist,&region,pathlist,pathlength);
      else list=Node_link_parse(p,datastr,&endptr,&hits,
		&Vlist,&Elist,&Flist,&region,pathlist,pathlength);
      trace=list;
      while (trace)
	{
	  trace->v=trans_vec[trace->v];
	  trace=trace->next;
	}
    }
  
  if (trans_vec) free(trans_vec);
  /* remove any neg or zero entries of list (note: calling
     routine may have to check that positive values are legitimate.) */
  trace=list;
  while (list && list->v<=0)
    {
      trace=list;
      list=list->next;
      free(trace);
    }
  if (!list) return 0;

  oldtrace=list;
  trace=list->next;
  while(trace)
    {
      if (trace->v<=0)
	{
	  oldtrace->next=trace->next;
	  free(trace);
	  trace=oldtrace->next;
	}
      else 
	{
	  oldtrace=trace;
	  trace=trace->next;
	  count++;
	}
    }

  /* move to appropriate list */
  if (mode==1) 
    {
      if (Vlist) vert_free(&Vlist);
      Vlist=list;
    }
  else if (mode==2)
    {
      if (Flist) vert_free(&Flist);
      Flist=list;
    }
  else vert_free(&list);
  return count;
} /* map_list */


