#include "cp_types.h"
#include "cp_proto.h"

/* comp angle sum c and its derivative d (with respect to the 
s_radius, for interior nodes in hyp setting. Deriv depends on 
whether some of radii are infinite */

int h_curvcalc(struct p_data *p,int i,double s,double *c,double *d)
{
  int k;
  double s1,s2,a,b,cc,e,ss,cs;
  struct K_data *pK_ptr;
  struct R_data *pR_ptr;

  pK_ptr=p->packK_ptr;pR_ptr=p->packR_ptr;
  *c=0;*d=0;
  if (s<=0) return 1; /* infinite radius at vertex of interest */
  s2=pR_ptr[pK_ptr[i].flower[0]].rad;
  for (k=1;k<=pK_ptr[i].num;k++)
    {
      s1=s2;
      s2=pR_ptr[pK_ptr[i].flower[k]].rad;
      cs=h_comp_cos(s,s1,s2);
      *c+=acos(cs);
      if ((s1>0) && (s2>0))
	{
	  cc=(-s1*s1-s2*s2);
	  b=s1*s1*s2*s2;
	  a=(-2-cc-2*b);
	  e=cc-a;
	  ss=s*s;
	  *d+=2*e*(1-b*ss*ss)/((1+cc*ss+b*ss*ss)*
			       sqrt( e*(2+(cc+a)*ss+2*b*ss*ss) ));
	}
      else if ((s1<=0) && (s2<=0)) *d+=2/sqrt(1-s*s);
      else if (s1<=0) *d+=sqrt(s2/s)/(1+s2*s);
      else *d+=sqrt(s1/s)/(1+s1*s);
    }
  return 1;
} /*h_curvcalc */
