#include "cp_types.h"
#include "cp_proto.h"

/* Routine for transferring data. Normally, these are 'get' 
routines: get data for active pack p FROM q. If rev_flag set, 
these are 'put' routines: put data from p TO q. The datastr 
specifies indices from p. If trans_flag is set, then use the 
vertex_map of p (if it exists) to translate the indices to
the other packing. Flag settings:
   r = radii
   z = centers
   a = aims
   s = angle sums
   c = circle colors
   m = mark
   f = face colors
Return 0 on failure. Caution: routine doesn't check for match 
of geometries. */

int get_put_data(struct p_data *p,struct p_data *q,
	     char *datastr,char flag,int rev_flag,int trans_flag)
{
  int hits,tv;
  char *endptr;
  struct Vertlist *list=NULL,*trace;
  struct Edgelist *maplist=NULL,*mtrace,*etrace,*qtrace,*holdmap;
  struct R_data *qR_ptr,*pR_ptr;
  struct K_data *qK_ptr,*pK_ptr;

  if (!(q->status) || !(p->status) || p->locks) return 0;

  qR_ptr=q->packR_ptr;qK_ptr=q->packK_ptr;
  pR_ptr=p->packR_ptr;pK_ptr=p->packK_ptr;

  /* take care of vertex_map case (only under "get") */

  if ((flag=='v' || flag=='V') && (qtrace=q->vertex_map))
    {
      if (!trans_flag) /* direct transfer */
	{
	  edge_free(&p->vertex_map);
	  p->vertex_map=etrace=(struct Edgelist *)
	    calloc((size_t)1,sizeof(struct Edgelist));
	  while(qtrace)
	    {
	      etrace=etrace->next=(struct Edgelist *)
		calloc((size_t)1,sizeof(struct Edgelist));
	      etrace->v=qtrace->v;
	      etrace->w=qtrace->w;
	      qtrace=qtrace->next;
	    }
	  etrace=p->vertex_map;
	  p->vertex_map=p->vertex_map->next;
	  free(etrace);
	  return 1;
	}
      else  /* compose p's vertex_map with q's (or reverse of q's) */
	{
	  holdmap=mtrace=p->vertex_map;
	  p->vertex_map=etrace=(struct Edgelist *)
	    calloc((size_t)1,sizeof(struct Edgelist));
	  while(mtrace)
	    {
	      if (flag=='v') tv=vertex_translation(q->vertex_map,mtrace->w);
	      else tv=vertex_rev_translation(q->vertex_map,mtrace->w);
	      if (tv>0) /* got something */
		{
		  etrace=etrace->next=(struct Edgelist *)
		    calloc((size_t)1,sizeof(struct Edgelist));
		  etrace->v=mtrace->v;
		  etrace->w=tv;
		}
	      mtrace=mtrace->next;
	    }
	  etrace=p->vertex_map;
	  p->vertex_map=p->vertex_map->next;
	  free(etrace);
	  edge_free(&holdmap);
	  return 1;
	}
    }

  /* get list of indices (verts or faces) and set up index map. */

  if (flag=='r' || flag=='z' || flag=='a' || flag=='c' || flag=='m')
    {
      if (!(list=trace=Node_link_parse(p,datastr,&endptr,&hits,
		           &Vlist,&Elist,&Flist,&region,pathlist,pathlength)))
	{
	  sprintf(msgbuf,"get_data: indices were not specified.");
	  emsg();
	  return 0;
	}
      maplist=mtrace=(struct Edgelist *)
	calloc((size_t)1,sizeof(struct Edgelist));
      if (p->vertex_map && trans_flag) /* have to map indices */
	while (trace)
	  {
	    if ((tv=vertex_translation(p->vertex_map,trace->v))>0
		&& tv<=q->nodecount)
	      {
		mtrace=mtrace->next=(struct Edgelist *)
		  calloc((size_t)1,sizeof(struct Edgelist));
		mtrace->v=trace->v;
		mtrace->w=tv;
	      }
	    trace=trace->next;
	  }
      else /* identify map */
	while (trace)
	  {
	    if ( trace->v>0 && trace->v<=q->nodecount)
	      {
		mtrace=mtrace->next=(struct Edgelist *)
		  calloc((size_t)1,sizeof(struct Edgelist));
		mtrace->v=trace->v;
		mtrace->w=trace->v;
	      }
	    trace=trace->next;
	  }
      mtrace=maplist;
      maplist=maplist->next;
      free(mtrace);
      if (!maplist) return 0; /* didn't get any indices */
    }
  else if (flag=='f') /* want face information */ 
    {
      if(!(list=trace=Face_link_parse(p,datastr,&endptr,&hits,
		      &Vlist,&Elist,&Flist,&region,pathlist,pathlength)))
	{
	  sprintf(msgbuf,"get_data: indices were not specified.");
	  emsg();
	  return 0;
	}
      maplist=mtrace=(struct Edgelist *)
	calloc((size_t)1,sizeof(struct Edgelist));
      if (p->vertex_map && trans_flag) /* have to map indices */
	while (trace)
	  {
	    if ((tv=face_translation(p,trace->v,q))>0
		&& tv<=q->facecount)
	      {
		mtrace=mtrace->next=(struct Edgelist *)
		  calloc((size_t)1,sizeof(struct Edgelist));
		mtrace->v=trace->v;
		mtrace->w=tv;
	      }
	    trace=trace->next;
	  }
      else /* identify map */
	while (trace)
	  {
	    if ( trace->v>0 && trace->v<=q->facecount)
	      {
		mtrace=mtrace->next=(struct Edgelist *)
		  calloc((size_t)1,sizeof(struct Edgelist));
		mtrace->v=trace->v;
		mtrace->w=trace->v;
	      }
	    trace=trace->next;
	  }
      mtrace=maplist;
      maplist=maplist->next;
      free(mtrace);
      if (!maplist) return 0; /* didn't get any indices */
    }
  else
    {
      sprintf(msgbuf,"Didn't get valid flag for type of data.");
      emsg();
      return 0;
    }

  /* move data */

  mtrace=maplist;
  switch(flag)
    {
    case 'r': /* radii */
      {
	while(mtrace)
	  {
	    if (rev_flag) qR_ptr[mtrace->w].rad=pR_ptr[mtrace->v].rad;
	    else pR_ptr[mtrace->v].rad=qR_ptr[mtrace->w].rad;
	    mtrace=mtrace->next;
	  }
	break;
      }
    case 'z': /* centers */
      {
	while(mtrace)
	  {
	    if (rev_flag) qR_ptr[mtrace->w].center=pR_ptr[mtrace->v].center;
	    else pR_ptr[mtrace->v].center=qR_ptr[mtrace->w].center;
	    mtrace=mtrace->next;
	  }
	break;
      }
    case 'a': /* aims */
      {
	while(mtrace)
	  {
	    if (rev_flag) qR_ptr[mtrace->w].aim=pR_ptr[mtrace->v].aim;
	    else pR_ptr[mtrace->v].aim=qR_ptr[mtrace->w].aim;
	    mtrace=mtrace->next;
	  }
	break;
      }
    case 's': /* angle sum */
      {
	while(mtrace)
	  {
	    if (rev_flag) qR_ptr[mtrace->w].curv=pR_ptr[mtrace->v].curv;
	    else pR_ptr[mtrace->v].curv=qR_ptr[mtrace->w].curv;
	    mtrace=mtrace->next;
	  }
	break;
      }
    case 'c': /* circle color */
      {
	while(mtrace)
	  {
	    if (rev_flag) qK_ptr[mtrace->w].color=pK_ptr[mtrace->v].color;
	    else pK_ptr[mtrace->v].color=qK_ptr[mtrace->w].color;
	    mtrace=mtrace->next;
	  }
	break;
      }
    case 'm': /* mark */
      {
	while(mtrace)
	  {
	    if (rev_flag) qK_ptr[mtrace->w].mark=pK_ptr[mtrace->v].mark;
	    else pK_ptr[mtrace->v].mark=qK_ptr[mtrace->w].mark;
	    mtrace=mtrace->next;
	  }
	break;
      }
    case 'f': /* face color */
      {
	while(mtrace)
	  {
	    if (rev_flag) 
	      q->faces[mtrace->w].color=p->faces[mtrace->v].color;
	    else p->faces[mtrace->v].color=q->faces[mtrace->w].color;
	    mtrace=mtrace->next;
	  }
	break;
      }
    } /* end of switch */
  vert_free(&list);
  edge_free(&maplist);
 return 1;
} /* get_put_data */
    
