#include "cp_types.h"
#include "cp_proto.h"

/* build vertlist of hex-extended edge from v1 to v2 up to 'lgth' 
   (if it exists). */

struct Vertlist *extended_edge_verts(struct p_data *p,int v1,int v2,int lgth)
{
  int next,i=1,dir,current,last;
  struct Vertlist *vlist=NULL,*trace;
  struct K_data *pK_ptr=p->packK_ptr;

  if (!p->status || v1==v2 || (dir=hex_extend(p,v1,v2,lgth))<0) 
    return NULL ;
  vlist=trace=(struct Vertlist *)
    calloc((size_t)1,sizeof(struct Vertlist));
  trace->v=last=v1;
  current=pK_ptr[last].flower[dir];
  while (current!=v2 && i<lgth && (next=hex_proj(p,current,last)))
    {
      trace=trace->next=(struct Vertlist *)
	calloc((size_t)1,sizeof(struct Vertlist));
      trace->v=last=current;
      current=next;
      i++;
    }
  if (current!=v2) 
    {
      vert_free(&vlist);
      return NULL;
    }
  trace=trace->next=(struct Vertlist *)
    calloc((size_t)1,sizeof(struct Vertlist));
  trace->v=v2;
  return vlist;
} /* extended_edge_verts */

