#include "cp_types.h"
#include "cp_proto.h"

/* drawing labels in various geometries */

int draw_node_labels(struct p_data *p,int show)
{
  int i;
	
  if (!p->status) return 0;
  for (i=1;i<=p->nodecount;i++)
    draw_cir_number(p,i,i,show);
  refresh_canvas(p->screen);
  return 1;
} /* draw_node_labels */

int draw_cir_number(struct p_data *p,int v,int n,int show)
     /* write n at center of circle v */
{
  int front;
  double stretch;
  complex ctr;
	
  if (!p->status || !p->packK_ptr[v].plot_flag) return 0;
  if (p->hes<0 && p->packR_ptr[v].rad<0)
    {
      stretch=1.0+(p->screen->box.rx-p->screen->box.lx)*15/
	(p->screen->pix_box.rx-p->screen->pix_box.lx); 
      /* to shift horocycle labels a little to miss circle*/
      ctr.re=p->packR_ptr[v].center.re*stretch;
      ctr.im=p->packR_ptr[v].center.im*stretch;
    } 
  else if (p->hes>0) 
    {
      ctr=ss_view(p->screen,p->packR_ptr[v].center,1,&front);
      if (!front) return 0;
      ctr=s_pt_to_visual_plane(ctr);
    }
  else ctr=p->packR_ptr[v].center;
  return (shownumber(p->screen,n,ctr,show));
} /* draw_cir_number */

int write_at_pt(struct p_data *p,complex pt,char *datastr,int show)
     /* write string at pt on screen (for sphere, need to convert). */
{
  int front,x,y;
  complex normpt;
	
  if (p->hes>0) /* sphere */
    {
      pt=ss_view(p->screen,pt,1,&front);
      if (!front) return 0;
      pt=s_pt_to_visual_plane(pt);
    }
  r_to_pix(pt,&normpt,p->screen->pix_box,p->screen->box);
  if ((x=(int)normpt.re)<=p->screen->pix_box.rx 
      && x >= 0
      && (y=(int)normpt.im) <= p->screen->pix_box.ry 
      && y >= 0) /* on screen */
    {
      DrawString(p->screen->xpm,x,y,datastr,strlen(datastr));
      if (show) refresh_canvas(p->screen);
    }
  return 1;
} /* write_at_pt */

int draw_face_labels(struct p_data *p,int show)
{
  int k;

  if (!p->status) return 0;
  for (k=1;k<=p->facecount;k++) 
    draw_face_number(p,k,k,show);
  refresh_canvas(p->screen);
  return 1;
} /* draw_face_labels */

int draw_face_number(struct p_data *p,int face,int n,int show)
     /* number n in face face */
{
  int i0,i1,i2,front;
  complex ctr,p0,p1,p2;
  struct R_data *pR_ptr;

  if (!p->faces[face].plot_flag) return 0;
  pR_ptr=p->packR_ptr;
  i0=p->faces[face].vert[0];p0=pR_ptr[i0].center;
  i1=p->faces[face].vert[1];p1=pR_ptr[i1].center;
  i2=p->faces[face].vert[2];p2=pR_ptr[i2].center;
  if (p->hes<=0)
    {
      ctr.re=(p0.re+p1.re+p2.re)*.33333;
      ctr.im=(p0.im+p1.im+p2.im)*.33333;
    }
  else
    {
      ctr=sph_tri_center(p0,p1,p2);
      ctr=ss_view(p->screen,ctr,1,&front);
      if (!front) return 0;
      ctr=s_pt_to_visual_plane(ctr);
    }
  return (shownumber(p->screen,n,ctr,show));

} /* draw_face_number */

int shownumber(struct s_data *q,int n,complex pt,int show)
     /* print number in canvas. */
{
  int x,y;
  char numtext[32]; /* buffer for digits */
  complex normpt;

  r_to_pix(pt,&normpt,q->pix_box,q->box);
  if ((x=(int)normpt.re)>q->pix_box.rx || x < 0
      || (y=(int)normpt.im) > q->pix_box.ry || y < 0)
    return 0; /* pt off screen */
  if (n>10) x -= 5;
  if (n>100) x -= 5; /* shift a little for better positioning */
  sprintf(numtext,"%d",n);
  DrawString(q->xpm,x,y,numtext,strlen(numtext));
  if (show) refresh_canvas(q);
  return 1;
} /* shownumber */

