/* cp_xview.c   To segregate calls to xview functions */

#include "cp_head.h"

int set_print_file(char *datastr)
{
  if (cmd_mode) return 1;
  return (panel_set_value(print_file_item,datastr));
} /* set_print_file */

int set_ps_file(char *datastr)
{
  if (cmd_mode) return 1;
  return (panel_set_value(ps_file_item,datastr));
} /* set_ps_file */

int set_pack_dir_name(char *datastr)
{
  if (cmd_mode) return 1;
  return (panel_set_value(dir_name_item,datastr));
} /* set_pack_dir_name */

int set_print_cmd(char *datastr)
{
  if (cmd_mode) return 1;
  return (panel_set_value(print_com_item,datastr));
} /* set_print_cmd */

char *get_print_file()
{
  if (cmd_mode) return NULL;
  return (char *)xv_get(print_file_item,PANEL_VALUE);
} /* get_print_file */
 
char *get_ps_file()
{
  if (cmd_mode) return NULL;
  return (char *)xv_get(ps_file_item,PANEL_VALUE);
} /* get_ps_file */

char *get_pack_dir_name()
{
  if (cmd_mode) return NULL;
  return (char *)xv_get(dir_name_item,PANEL_VALUE);
} /* get_pack_dir_name */

char *get_print_cmd()
{
  if (cmd_mode) return NULL;
  return (char *)xv_get(print_com_item,PANEL_VALUE);
} /* get_print_cmd */

int set_u_cir_flag(int pnum,int truefalse)
{
  if (cmd_mode) return 1;
  return (int)xv_set(u_cir_flag[pnum],PANEL_TOGGLE_VALUE,0,truefalse,0);
} /* set_u_cir_flag */

int set_coord_flag(int pnum,int truefalse)
{
  if (cmd_mode) return 1;
  return (int)xv_set(coord_flag[pnum],PANEL_TOGGLE_VALUE,0,truefalse,0);
} /* set_coord_flag */

int set_script_name(char *filename)
{
  char buff[NAME_MAX];

  if (cmd_mode) return 1;
  xv_set(script_sw,TEXTSW_FILE,filename,0);
  sprintf(buff,"Script Window - ");
  if (textsw_append_file_name(script_sw,filename)!=0)
    strcat(buff,"(NONE)\0");
  else strcat(buff,filename);
  xv_set(script_frame,XV_LABEL,buff,0); 
  return 1;
} /* set_script_name */
