#include "cp_types.h"
#include "cp_proto.h"

/* identify edges/vert on opposite sides of bdry vert 'vert'. */

int close_up(struct p_data *p,int vert)
{
  int next,v,i,ii,j,jj,w,*newflower,newnum,hold;
  double vert_next_angle=0.0,next_w_angle=0.0,*newoverlaps=NULL;
  struct K_data *pK_ptr;

  pK_ptr=p->packK_ptr;
  /* fix up 'next', vertex after vert */
  if (pK_ptr[vert].num<3) return 0; /* too few faces */
  v=pK_ptr[vert].flower[0];
  next=pK_ptr[vert].flower[pK_ptr[vert].num];
  /* if next==v, then vert and next should be interior; nothing more to do */
  if (next==v)
    {
      pK_ptr[vert].bdry_flag=pK_ptr[next].bdry_flag=0;
      p->packR_ptr[vert].aim=p->packR_ptr[next].aim=2*M_PI; 
      return 1;
    } 
  /* fix up vert */
  pK_ptr[vert].flower[0]=next;
  pK_ptr[vert].bdry_flag=0;
  p->packR_ptr[vert].aim=2*M_PI;
  if (p->overlap_status) /* average the overlaps with v and next */
    {
      vert_next_angle=(0.5)*(pK_ptr[vert].overlaps[0]+
			     pK_ptr[vert].overlaps[pK_ptr[vert].num]);
      pK_ptr[vert].overlaps[0]=
	pK_ptr[vert].overlaps[pK_ptr[vert].num]=
	vert_next_angle;
    }

  /* if next and v share common neighbors: either <v,vert,next> or
     <v,vert,next,w> is a closed bdry comp; in former case, modify w
     to put in latter case (one face disappears). */

  else if ((pK_ptr[v].flower[0]==
	       (w=pK_ptr[next].flower[pK_ptr[next].num]))
	   || pK_ptr[v].flower[0]==next)
    {
      if (pK_ptr[v].flower[0]==next)
	{
	  remove_edge(p,v,next);
	  w=pK_ptr[next].flower[pK_ptr[next].num];
	}
      newnum=pK_ptr[v].num+pK_ptr[next].num;
      newflower=(int *)calloc((size_t)(newnum+1),sizeof(int));
      if (p->overlap_status) 
	{
	  newoverlaps=(double *)calloc((size_t)(newnum+1),
				       sizeof(double));
	  next_w_angle=(0.5)*
	    (pK_ptr[w].overlaps[0]+
	     pK_ptr[w].overlaps[pK_ptr[w].num]);
	}
      hold=pK_ptr[next].num;
      for (i=0;i<=pK_ptr[next].num;i++)
	{
	  newflower[i]=pK_ptr[next].flower[i];
	  if (p->overlap_status) newoverlaps[i]=
				   pK_ptr[next].overlaps[i];
	}
      for (i=1;i<=pK_ptr[v].num;i++)
	{
	  newflower[i+pK_ptr[next].num]=pK_ptr[v].flower[i];
	  if (p->overlap_status) newoverlaps[i+pK_ptr[next].num]=
				   pK_ptr[next].overlaps[i];
	}
      free(pK_ptr[next].flower);
      pK_ptr[next].flower=newflower;
      pK_ptr[next].num=newnum;
      if (p->overlap_status)
	{
	  free(pK_ptr[next].overlaps);
	  pK_ptr[next].overlaps=newoverlaps;
	  pK_ptr[next].overlaps[0]=
	    pK_ptr[next].overlaps[newnum]=vert_next_angle;
	  pK_ptr[next].overlaps[hold]=next_w_angle;	
	}
      /* fix up w */
      pK_ptr[w].flower[pK_ptr[w].num]=next;
      if (p->overlap_status)
	pK_ptr[w].overlaps[0]=pK_ptr[w].overlaps[pK_ptr[w].num]
	  = vert_next_angle;
      pK_ptr[next].bdry_flag=	pK_ptr[w].bdry_flag=0;
      p->packR_ptr[next].aim=p->packR_ptr[w].aim=2*M_PI;
    }

  /* otherwise, next remains boundary vertex */
  else
    {
      newnum=pK_ptr[v].num+pK_ptr[next].num;
      newflower=(int *)calloc((size_t)(newnum+1),sizeof(int));
      if (p->overlap_status) 
	newoverlaps=(double *)calloc((size_t)(newnum+1),sizeof(double));
      for (i=0;i<=pK_ptr[v].num;i++)
	{
	  newflower[i]=pK_ptr[v].flower[i];
	  if (p->overlap_status)
	    newoverlaps[i]=pK_ptr[v].overlaps[i];
	}
      for (i=1;i<=pK_ptr[next].num;i++)
	{
	  newflower[i+pK_ptr[v].num]=pK_ptr[next].flower[i];
	  if (p->overlap_status)
	    newoverlaps[i+pK_ptr[v].num]=pK_ptr[v].overlaps[i];
	}
      if (p->overlap_status)
	newflower[pK_ptr[v].num]=vert_next_angle;
      pK_ptr[next].flower=newflower;
      pK_ptr[next].num=newnum;
      if (p->overlap_status)
	{
	  free(pK_ptr[w].overlaps);
	  pK_ptr[w].overlaps=newoverlaps;
	}
      p->packR_ptr[next].aim=-1.0;
    }

  /* fix up things with v in their flowers (v will be removed) */
  for (i=0;i<=pK_ptr[v].num;i++)
    {
      ii=pK_ptr[v].flower[i];
      for (j=0;j<=pK_ptr[ii].num;j++)
	{
	  jj=pK_ptr[ii].flower[j];
	  if (jj==v) pK_ptr[ii].flower[j]=next;
	}
    }
  delete(p,v);
  return 1;
} /* close_up */
