#include "cp_types.h"
#include "cp_proto.h"

/* see if angle sum errors and any incompatibilities
due to overlap angles are within tolerance; return 0 if okay, 
1 for inconsistency, 2 for out of tolerance. */

int ck_pack_status(struct p_data *p,double tol)
{
  int i,ic_flag,accum_ic_flag=0,out_flag=0;
  double ic_err;

  for (i=1;i<=p->nodecount;i++)
    {
      if (p->packR_ptr[i].aim>=0)
	{
	  if (p->hes<-okerr) 
	    h_as_overlap(p,i,p->packR_ptr[i].rad,
			 &p->packR_ptr[i].curv,&ic_flag,&ic_err);
	  else if (p->hes< okerr)
	    e_as_overlap(p,i,p->packR_ptr[i].rad,
			 &p->packR_ptr[i].curv,&ic_flag,&ic_err);
	  if (ic_flag) accum_ic_flag++;
	  else if (fabs(p->packR_ptr[i].curv-p->packR_ptr[i].aim)>tol)
	    out_flag++;
	}
    }
  if (accum_ic_flag) return 1;
  if (out_flag) return 2;
  return 0;
} /* ck_pack_status */
