#include "cp_types.h"
#include "cp_proto.h"

/* minimum eucl dist from complex value to polygonal bdry 
(b_dist) and to bdry vertices (b_vert_dist) of pack p. */

int bdry_dist(struct p_data *p,complex pt,double *b_dist,double *b_vert_dist)
{
  int i,j,k1,k2;
  double dist,dum,vert_dist;
  complex end1,end2,y;

  for (i=1;i<=p->nodecount;i++) 
    p->packK_ptr[i].util_flag=0;
  if (p->hes<0) /* hyp case */
    {
      for (j=1;j<=p->num_bdry_comp;j++)
	{
	  k2=p->bdry_starts[j];
	  h_to_e_data(p->packR_ptr[k2].center,
		      p->packR_ptr[k2].rad,&end2,&dum);
	  y=csub(end2,pt);
	  *b_dist=cAbs(y); 
	  *b_vert_dist=*b_dist;
	  while (!p->packK_ptr[k2].util_flag)
	    {
	      end1=end2;
	      k1=k2;
	      k2=p->packK_ptr[k1].flower[0];
	      h_to_e_data(p->packR_ptr[k2].center,
			  p->packR_ptr[k2].rad,&end2,&dum);
	      dist=seg_dist(pt,end1,end2);
	      *b_dist=(dist<*b_dist) ? dist : *b_dist;
	      y=csub(end2,pt);
	      vert_dist=cAbs(y);
	      *b_vert_dist=(vert_dist<*b_vert_dist) ?
		vert_dist : *b_vert_dist;
	      p->packK_ptr[k1].util_flag=1;
	    }
	}
      return 1;
    }
  else if (p->hes==0) /* eucl case */
    {
      for (j=1;j<=p->num_bdry_comp;j++)
	{
	  k2=p->bdry_starts[j];
	  end2=p->packR_ptr[k2].center;
	  y=csub(end2,pt);
	  *b_dist=cAbs(y); 
	  *b_vert_dist=*b_dist;
	  while (!p->packK_ptr[k2].util_flag)
	    {
	      end1=end2;
	      k1=k2;
	      k2=p->packK_ptr[k1].flower[0];
	      end2=p->packR_ptr[k2].center;
	      dist=seg_dist(pt,end1,end2);
	      *b_dist=(dist<*b_dist) ? dist : *b_dist;
	      y=csub(end2,pt);
	      vert_dist=cAbs(y);
	      *b_vert_dist=(vert_dist<*b_vert_dist) ?
		vert_dist : *b_vert_dist;
	      p->packK_ptr[k1].util_flag=1;
	    }
	}
      return 1;
    }
  return 0;
} /* bdry_dist */
