#include "cp_types.h"
#include "cp_proto.h"

struct p_data *init_packing()
/* Initiate a bare bones packing p_data pointer, allocate initial
   space */
{
  int j,k;
  struct p_data *p;

  if (!(p=(struct p_data *)calloc((size_t)1,sizeof(struct p_data)))
      || !(p->screen=(struct s_data *)
	   calloc((size_t)1,sizeof(struct s_data))))
    {
      if (p) free(p);
      return NULL;
    }
  p->sizelimit=5000;
  alloc_edge_pair(p);
  p->screen->box.lx=p->screen->box.ly=-1.1;
  p->screen->box.rx=p->screen->box.ry=1.1;
  p->screen->pix_box.lx=p->screen->pix_box.ly=0;
  p->screen->pix_box.rx=p->screen->pix_box.ry=CANV_SIZE;
  p->screen->factor=1.0;
  for (k=0;k<3;k++)
    {
      for (j=0;j<3;j++)
	p->screen->disp_trans[k][j]=
	  p->screen->disp_inv_trans[k][j]=0.0;
      p->screen->disp_trans[k][k]=
	p->screen->disp_inv_trans[k][k]=1.0;
    }
  alloc_pack_space(p,5000,0);
  return p;
} /* init_packing */

int alloc_pack_space(struct p_data *p,int new_size,int flag)
/* Enlarge pack data space, step of 5000. Allocate space for 
pK and pR data, free old space. If flag=1, adjust size of current 
pack, else this is new pack. CAUTION: after return, be sure to 
update any corrupted pointers, e.g., pK_ptr and pR_ptr. */
{
  int v,size,oldsize;
  struct K_data *newK,*pK_ptr;
  struct R_data *newR,*pR_ptr;
	
  if (!p) return 0;
  oldsize=p->sizelimit;
  size=((int)((new_size-1)/5000))*5000+5000;
  if (flag && size==oldsize) return 1; /* no action needed */
  if (flag && (p->nodecount > (size-1))) return 0; 
  /* pack too big for given new_size */

  pK_ptr=p->packK_ptr;pR_ptr=p->packR_ptr;
  p->sizelimit=size;
  if ((newK=(struct K_data *)
       calloc((size_t)(size+1),sizeof(struct K_data)))==NULL)
    {p->sizelimit=oldsize;return 0;}
  if ((newR=(struct R_data *)
       calloc((size_t)(size+1),sizeof(struct R_data)))==NULL)
    {free(newK);p->sizelimit=oldsize;return 0;}
  if (flag) for (v=1;v<=p->nodecount;v++) /* copy old data */
    {
      newK[v]=pK_ptr[v];
      newR[v]=pR_ptr[v];
    }
  else /* empty out pack and reset */
    {
      if (p->faces) 
	{free(p->faces);p->faces=NULL;}
      if (p->rwb_flags)
	{free(p->rwb_flags);p->rwb_flags=NULL;}
      if (p->f_util)
	{free(p->f_util);p->f_util=NULL;}
      free_overlaps(p);
      p->overlap_status=p->status=0;
      if (pK_ptr) for (v=1;v<=p->nodecount;v++)
	if (pK_ptr[v].flower) free(pK_ptr[v].flower);
      vert_free(&(p->vlist));
      vert_free(&(p->flist));
      edge_free(&(p->elist));
      edge_free(&(p->vertex_map));
      free_redfaces(&(p->redfaces));
      alloc_edge_pair(p);
      p->nodecount=p->first_red_face=p->status=p->locks=0;
      strcpy(p->fhead,"");
      strcpy(p->file_name,"");
    }
  if (pK_ptr) free(pK_ptr);
  if (pR_ptr) free(pR_ptr);
  p->packK_ptr=newK;
  p->packR_ptr=newR;
  return 1;
} /* alloc_pack_space */

int alloc_faces_space(struct p_data *p)
     /* allocate face data space (knowing facecount) */
{
  if (p->faces) free(p->faces);
  if (p->rwb_flags) free(p->rwb_flags);
  p->faces=(f_data *)calloc((p->facecount+1),sizeof(f_data));
  if (!(p->faces)) return 0;
  p->rwb_flags=(int *)calloc((p->facecount+1),sizeof(int));
  if (!(p->rwb_flags)) {free(p->faces);p->faces=NULL;return 0;}
  if (p->f_util) {free(p->f_util);p->f_util=NULL;}
  return 1;
} /* alloc_faces_space */

int alloc_overlaps(struct p_data *p)
     /* Allocate overlaps ptr space and initialize. 
Return 1 if succeeds or already set. */
{
  int v,i;

  if (p->overlap_status) return 1; /* already have space */
  for (v=1;v<=p->nodecount;v++)
    {
      if ( (p->packK_ptr[v].overlaps=(double *)
	    malloc((p->packK_ptr[v].num+1)*sizeof(double)))==NULL )
	{
	  strcpy(msgbuf,"Failed to allocate memory for edge data.");
	  emsg();
	  free_overlaps(p);
	  return 0;
	}
      else for (i=0;i<=p->packK_ptr[v].num;i++)
	p->packK_ptr[v].overlaps[i]=1.0;
    }
  p->overlap_status=1;
  return 1;
} /* alloc_overlaps */

int alloc_edge_pair(struct p_data *p)
{
  if (p->edge_pair) free(p->edge_pair);
  p->edge_pair=(struct EdgePair *)
    calloc((size_t)(3*MAX_COMPONENTS+1),sizeof(struct EdgePair));
  return 1;
} /* alloc_edge_pair */

