#include "cp_types.h"
#include "cp_proto.h"

/* adds circle connected to v and clockwise bdry 
neighbor. Verify v is valid node, set needed default data. 
CAUTION: after return, be sure to update any corrupted pointers
pK_ptr and pR_ptr. */

int add_vert(struct p_data *p,int v)
{
  int v2,node,i,n,*newflower,flag=0;
  double *newoverlaps;
  struct K_data *pK_ptr;
  struct R_data *pR_ptr;

  if (v<1 || v>p->nodecount || !p->packK_ptr[v].bdry_flag) return 0;
  v2=p->packK_ptr[v].flower[p->packK_ptr[v].num];
  if ( (node=p->nodecount+1) > (p->sizelimit)
       && !alloc_pack_space(p,node,1) )
    {
      sprintf(msgbuf,
	      "Space allocation problem with adding vertex.");
      emsg();
      return 0;
    }
  pK_ptr=p->packK_ptr;pR_ptr=p->packR_ptr; 
  if (pR_ptr[v].rad<=0)  /* avoid infinite rad */
    {
      pR_ptr[v].rad=.1;
    }
  /* add to flower of v */
  n=pK_ptr[v].num;
  newflower=(int *)calloc((size_t)(n+2),sizeof(int));
  for (i=0;i<=n;i++) newflower[i]=pK_ptr[v].flower[i];
  newflower[n+1]=node;
  free(pK_ptr[v].flower);
  pK_ptr[v].flower=newflower;
  if (pK_ptr[v].overlaps)
    {
      newoverlaps=(double *)calloc((size_t)(n+2),sizeof(double));
      for (i=0;i<=n;i++) newoverlaps[i]=pK_ptr[v].overlaps[i];
      newoverlaps[n+1]=1.0;
      free(pK_ptr[v].overlaps);
      pK_ptr[v].overlaps=newoverlaps;
    }
  pK_ptr[v].num=n+1;
  /* add to flower of v2 */
  n=pK_ptr[v2].num;
  newflower=(int *)calloc((size_t)(n+2),sizeof(int));
  for (i=1;i<=n+1;i++) newflower[i]=pK_ptr[v2].flower[i-1];
  newflower[0]=node;
  free(pK_ptr[v2].flower);
  pK_ptr[v2].flower=newflower;
  if (pK_ptr[v2].overlaps)
    {
      newoverlaps=(double *)calloc((size_t)(n+2),sizeof(double));
      for (i=1;i<=n+1;i++) newoverlaps[i]=pK_ptr[v2].overlaps[i-1];
      newoverlaps[0]=1.0;
      free(pK_ptr[v2].overlaps);
      pK_ptr[v2].overlaps=newoverlaps;
    }
  pK_ptr[v2].num=n+1;
  /* add new node */
  p->nodecount++;
  pK_ptr[node].num=1;
  pK_ptr[node].flower=(int *)calloc((size_t)2,sizeof(int));
  pK_ptr[node].flower[0]=v;
  pK_ptr[node].flower[1]=v2;
  if (p->overlap_status)
    {
      pK_ptr[node].overlaps=(double *)calloc((size_t)2,
					     sizeof(double));
      pK_ptr[node].overlaps[0]=pK_ptr[node].overlaps[1]=1.0;
    }
  pK_ptr[node].bdry_flag=pK_ptr[node].plot_flag=1;
  pK_ptr[node].mark=0;
  pK_ptr[node].color=FG_COLOR;
  pR_ptr[node].rad=pR_ptr[v].rad;
  any_compcenter(p->hes,
		 pR_ptr[v].center,pR_ptr[v2].center,&pR_ptr[node].center,
		 pR_ptr[v].rad,pR_ptr[v2].rad,&pR_ptr[node].rad,1.0,1.0,1.0);
  /* fix curvatures */
  if (p->hes<0)
    {
      h_anglesum_overlap(p,node,pR_ptr[node].rad,
			 &pR_ptr[node].curv,&flag);
      h_anglesum_overlap(p,v,pR_ptr[v].rad,&pR_ptr[v].curv,&flag);
      h_anglesum_overlap(p,v2,pR_ptr[v2].rad,&pR_ptr[v2].curv,&flag);
    }
  else if (p->hes==0)
    {
      e_anglesum_overlap(p,node,pR_ptr[node].rad,
			 &pR_ptr[node].curv,&flag);
      e_anglesum_overlap(p,v,pR_ptr[v].rad,&pR_ptr[v].curv,&flag);
      e_anglesum_overlap(p,v2,pR_ptr[v2].rad,&pR_ptr[v2].curv,&flag);
    }
  else if (p->hes>okerr)
    {
      s_anglesum_overlap(p,node,pR_ptr[node].rad,
			 &pR_ptr[node].curv,&flag);
      s_anglesum_overlap(p,v,pR_ptr[v].rad,&pR_ptr[v].curv,&flag);
      s_anglesum_overlap(p,v2,pR_ptr[v2].rad,&pR_ptr[v2].curv,&flag);
    }
  /* set defualt aims */
  pR_ptr[node].aim=pR_ptr[v].aim=pR_ptr[v2].aim=-1;
  return 1;
} /* add_vert */
