/* Decompose.c 					6/00 */
/*
cc -o Decompose Decompose.c -I/usr/openwin/include cp_remote_library.c 
hyp_math.c eucl_math.c sph_math.c complex_math.c -g -lm 
*/

#include <stdio.h>
#include "cp_types.h"
#include "cp_proto.h"

#define MAX_GRAINS 200

/* ==================================================================== 
   global declarations
 ==================================================================== */

/* basic stuff */
struct p_data *packdata;


struct p_light **grains;
int grain_count;

/* utility buffers. */
char packname[256];
char emsgbuf[BUFSIZE],buf[BUFSIZE],data[2*BUFSIZE],*msgbuf;
double toler=TOLER,okerr=OKERR;

/* file pointers */

FILE *packfp=NULL,*outfp;

/* procedure prototypes */
int sort_a_cmd(char *inmsg);
int parse_a_cmd(char *command);
int log_pack_info();
int emsg();
int msg();
int repack_activity_msg(char *msg);

/* ==================================================================== 
   main routine
 ==================================================================== */

int main(int argc,char *argv[])
{
  char inmsg[BUFSIZE];

/* ---------- initialization --------------- */

  grains=(struct p_light **)
    calloc((size_t)(MAX_GRAINS+1),sizeof(struct p_light *));  
  strcpy(emsgbuf,"ERROR: ");
  msgbuf=emsgbuf+7;
  packname[0]='\0';
  if ((packdata=(struct p_data *)
       calloc((size_t)1,sizeof(struct p_data)))==NULL ||
      !alloc_pack_space(packdata,10000,0))
    {
      printf("Insufficient memory.");
      exit(0);
    }

/* --- mini-notifier loop: continually check for input from stdin */

  printf("cmd: ");
  while (fgets(inmsg,BUFSIZE,stdin))
    {
      sort_a_cmd(inmsg);
    } 
  exit(2);
} /* end of main */


int log_pack_info() 
{
  printf("Loaded packing: name=%s; nodecount=%d; ",
	  packname,packdata->nodecount);
  if (packdata->hes<0) printf("geom=hyperbolic; ");
  else if (packdata->hes==0) printf("geom=euclidean; ");
  else printf("geom=spherical; ");
  if (packdata->overlap_status) printf("Overlap packing.\n\n");
  else printf("Tangency packing.\n");
  return 1;
} /* log_pack_info */

int sort_a_cmd(char *inmsg)
/* pick of individual commands in input stream, separated by ';' .*/
{
  int flag=1,n;
  char *command,local_stream[BUFSIZE],*token_ptr;

  strncpy(local_stream,inmsg,BUFSIZE-1);
  local_stream[BUFSIZE-1]='\0';
  token_ptr=local_stream;
  while (*(token_ptr)==';' || *(token_ptr)==' ') token_ptr++;
  stripsp(token_ptr);
  while (flag && (n=strcspn(token_ptr,";"))>0)
    {
      flag=0;
      command=token_ptr;
      token_ptr += n;
      if (*(token_ptr)==';')
	{
	  *(token_ptr)='\0';
	  token_ptr += 1;
	  stripsp(token_ptr);
	}
      while (*(token_ptr)==';' || *(token_ptr)==' ') token_ptr++;
      stripsp(command);
      flag=parse_a_cmd(command); /* stops if parse returns 0 */
    } /* end of while */
  printf("cmd: ");
  return flag;
} /* sort_a_cmd */

int parse_a_cmd(char *command)
/* Handle the commands passed from sort_a_cmd */
{
  int i,spread,overlp,mx,g;
  char *nextpoint,*dpoint,cmd[BUFSIZE],newpack[256];
  struct K_data *pK_ptr;
  struct R_data *pR_ptr;
  FILE *packfp=NULL;

  nextpoint=command;
  if (!grab_next(&nextpoint,cmd)) return 0; /* get command */
  strcpy(data,nextpoint); /* rest is data */
  dpoint=data;
  switch (cmd[0])
    {
    case 'b':
      {
	if (!strncmp(cmd,"bye",3)) /* =========== exit */
	  {
	    printf("bye");
	    exit(5);
	  }
	break;
      }
    case 'l':
      {
	if (!strncmp(cmd,"layers",6)) /* == decompose by layers */
	  {
	    if (sscanf(nextpoint,"%d %d %d",&spread,&overlp,&mx)!=3
		|| spread<2 || overlp>=spread 
		|| mx<10 || !packdata->status)
	      {
		printf(msgbuf,"usage: layers g o M, g=generations, "
		       " o=overlap, M=max size");
		emsg();
		return 0;
	      }
	    return ((grain_count=layer_decompose(packdata,grains,
		      spread,overlp,mx,MAX_GRAINS)));
	  }
	break;
      }
    case 'r': 
      { 
	if (!strncmp(cmd,"read",4)) /* ========== read packing */
	  {
	    if (!sscanf(dpoint,"%s",newpack) 
		|| (packfp=fopen(newpack,"r"))==NULL
		|| !readpack(packfp,packdata) )
	      {
		printf("Read of file %s has failed.\n",newpack);
		if (packfp) fclose(packfp);
		return 0;
	      }
	    strncpy(packname,newpack,255);
	    if (packfp) fclose(packfp);
	    packdata->status=1;
	    pK_ptr=packdata->packK_ptr;
	    pR_ptr=packdata->packR_ptr;
	    log_pack_info();
	    for (i=1;i<=packdata->nodecount;i++) /* set bdry flags */
	      {
		if (packdata->packK_ptr[i].flower[0]==
		    packdata->packK_ptr[i].flower[
		      packdata->packK_ptr[i].num])
		  packdata->packK_ptr[i].bdry_flag=0;
		else packdata->packK_ptr[i].bdry_flag=1;
	      }
	    return 1;
	  }
	break;
      }
    case 'w':
      {
	if (!strncmp(cmd,"write_g",7) /* ===== write grains */
	  && grains)
	  {
	    for (g=0;g<grain_count;g++)
	      {
		sprintf(buf,"%s_%d.p",packname,g);
		if (!(packfp=fopen(buf,"w"))) break;
		write_light(packfp,grains[g],1);
		fclose(packfp);
	      }
	  }
	break;
      }
     case '?':
      {
	sprintf(buf,"%s\n","Commands are:");
	printf(buf);
	printf("   %s\n","layers <spread> <overlp> <mx>");
	printf("   %s\n","read <filename>");
	printf("   %s\n","write_g");
	break;
      }
   } /* end of cmd switch */
  return 0;
} /* parse_a_cmd */

int emsg()
{
  printf(emsgbuf);return 1;
}

int msg()
{
  printf(msgbuf);return 1;
}






