/* xv_head.h  Xview and Xlib global variables for CirclePack */

#ifndef XV_HEAD_H
#define XV_HEAD_H

#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/cms.h>
#include <xview/xv_xrect.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/cursor.h>
#include <xview/tty.h>

/* ======== remote structure (only here because of 'Notify_client') == */

struct remote_control
{
	int 	op_code;	/* situation op_code */
		/* Options:
		 (bitwise)	0 = communications not yet set.
				1 = remote process up and waiting.
		 */
	int	locks;		/* locks on packs; bitwise, 1=locked */
	int 	pid;		/* process id; 0 if not running */
	int 	pipeto[2];	/* pipe to child; [1] open. */
	int	pipefr[2];	/* pipe from child: [0] open */
	FILE	*fp_to_remote;		/* file pointer */
	FILE	*fp_from_remote;	/* file pointer */
	Notify_client	notify_client;	/* handle to remote routine */
	char	program[32];	/* name of remote program */ 
	char 	moniker[32];	/* name for user to use in communications */
} remote[NUM_PROC];

/* ======================= XLib graphics variables ============ */
/* Note: 'colors' color table stuff is set elsewhere; will depend on GUI */

	GC gc,gc_fill;  /* graphics contexts */
	Xv_singlecolor cms_colors[NUM_COLORS+1];
	Display *display;
	XFontStruct *font;
	Cms cms;
	XGCValues gc_val;
        char stipple_bits[4];

/* ================== graphics and XView variables ========== */

	Frame base_frame, cmd_frame, script_frame,
		help_frame,history_frame,setup_frame,text_frame,msg_frame;
	Frame canvas_frame[NUM_PACKS],screen_frame[NUM_PACKS],
		manip_frame[NUM_PACKS];
	Panel panel;		/* main control panel */
	Canvas canvas[NUM_PACKS];  /* window ptr for the graphics window */
	Textsw scratch_sw,log_sw,help_sw,msg_sw,script_sw;
	Textsw_mark script_file_data_mark,script_file_cmd_mark,
		script_file_path_mark;
	Panel_item cmd_item,active_pack_item,radius_inc,Eucl_factor,
		fill_pattern,close_setup_item,print_com_item,
		remote_name_item,dir_name_item,	ps_file_item,print_file_item,
		script_name_item,cmd_button_item,
		u_cir_flag[NUM_PACKS],coord_flag[NUM_PACKS],clsup[NUM_PACKS],
		sfac[NUM_PACKS],rset[NUM_PACKS],ssize[NUM_PACKS],
		scent[NUM_PACKS],sdp[NUM_PACKS],clcd[NUM_PACKS],
		pmsg_item[NUM_PACKS],manip_item[NUM_PACKS];
	Cursor act_can_cursor, inact_can_cursor, delete_cursor, 
		axes_cursor, add_cursor, size_cursor,enfold_cursor,
		incr_cursor,decr_cursor,path_cursor,proj_cursor,lock_cursor;
					/* Various cursors for canvases */
	unsigned char red[NUM_COLORS+1],green[NUM_COLORS+1],blue[NUM_COLORS+1];

#endif




