/* cp_types.h  include file of type declarations for the program CirclePack
   and the CirclePack library routines. */

#ifndef CP_TYPES_H
#define CP_TYPES_H

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <math.h>
#include <pwd.h>
#include <sys/times.h>
#include <sys/types.h>
#include <sys/resource.h>
#include <sys/stat.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <X11/Xlib.h>
#include <X11/Xos.h>
#include <X11/Xutil.h>

#include "complex_math.h"
#include "hyp_math.h"
#include "eucl_math.h"
#include "sph_math.h"
#include "cp_canvas.h"

#include <dirent.h>
#define float double
#define NUM_PROC 6		/* max number of remote processes */
#define MAX_PETALS 2000		/* max number of petals in a flower */
#define MAX_COMPONENTS 300	/* number of allowed boundary components */
#define CANV_SIZE 450		/* initial size of canvase 0 */
#define MAX_PIXEL 800 		/* max canvas size */
#define MSG_LENGTH 10000	/* length of message window backup */
#define NUM_COLORS 255          /* No. colors in color table */
#define COLOR_RAMP 200          /* No. colors in color ramp */
#define BG_COLOR 0		/* background color code */
#define FG_COLOR 255    	/* foreground color code */
#define NAME_MAX 255		/* max length of filenames */
#define SHOW 1
#define NOSHOW 0		/* display flags */
#define PS_UNIT_LINEWIDTH .5    /* default standard line width */
#define BUFSIZE 1024		/* need some big buffers */
#define MAX_ACCUR 15            /* limit on requested accuracy */
#define TOLER .00000000001      /* default utility threshold */
#define OKERR .0000000000001    /* default okerr, smaller than TOLER */
#define M_TOLER .0000000000001  /* default for machine tolerance */
				   

extern char *msgbuf;

/*======================= type definitions =========================*/

typedef struct
 {
        int vert[3];		/* ordered triple of vertices */
	int index_flag;		/* which to draw first, 0,1, or 2;
				 (So verts index_flag, (index_flag+1)%3
				 are used to plot (index_flag+2)%3.)*/
        int next_face;		/* next face in drawing order. */
	int next_red;		/* next red face (if this face is red) */
	int plot_flag;		/* may indicate whether face location
				   is reliable enough for plotting */
	int color;		/* color index */
	int mark;		/* mark */
  } f_data;

struct RedList
 {
        int face;               /* face number */
        int v_flag;             /* gives index of the vertex this
				   face is responsible for in
				   drawing order of red faces. */
        double rad;              /* radius of v_flag vert */
        complex center;         /* center of v_flag vert */
        int corner_flag[3];     /* mark paired segment corner verts:
				   bits: 1=begin; 2=end */
        struct RedList *cross[3]; /* ptr to side-paired 
				     face in red chain */
        struct RedList *next_edge; /* face having next red edge */
        struct RedList *next;
        struct RedList *prev;
 };

struct EdgePair
 {
        int edge_indx;    /* indx of counterckw end of begin edge */
        int mate_indx;    /* indx to counterckw end of end edge */
        struct RedList *edge,*mate; /* in storing edge pairings;
				       'mate' will be NULL if 'edge'
				       is border (non-paired) edge. */
        Mobius mob;       /* Mobius transform if this is paired edge.
			     (Not implemented in sph case.) */
        double mob_err;   /* error in the Mobius transform (mainly for hyp
			     case; mob is always an automorphism, but roundoff 
			     can prevent it from providing exact match). */
        int color;
 };

struct Vertlist
 {
	int v;			/* vertex number */
	struct Vertlist *next;
 };

struct Edgelist
 {
	int v,w;		/* vertex numbers of edge ends */
	struct Edgelist *next;
 };

struct Centlist
 {
        complex z;              /* complex, e.g., circle center */
        struct Centlist *next;
 };

struct Pathlist
 {
	double x,y;		/* coords of point */
	struct Pathlist *next;
 };

struct Overlaps
{
  int v,w;
  double angle;
  struct Overlaps *next;
};

struct BdryData
{
  int v;                  /* original vert number */
  int new_indx;           /* assigned new vert number (temporary) */
  int num;                /* number of faces in fan */
  int bdry_flag;
  int poison_flag;        /* true if vert is poison (util_flag=-1) */
  int indx1,indx2;        /* first and last indices in face_org of
			     faces of this fan */
  int duty_flag;          /* utility flag */
  struct BdryData *next_v;/* pts to next object sharing v */
  struct BdryData *prev_v;/* pts to prev object sharing v */
  struct BdryData *next;
  struct BdryData *prev;
};

/*==================== structure for circle data ====================*/

struct K_data
 {
	int num;                /* number of faces containg this node.*/
				/* 'flower' has entries from 0 to num */
	int color;		/* gives color value, 0=background */
	int mark;		/* mark */
	int bdry_flag; 		/* true for boundary nodes */
	int plot_flag;		/* true if node has been successfully 
				   placed in packing layout. */
	int *flower;		/* ptr to list of nodes in flower;
				   in positive orientation, last = first if
				   flower is closed */
	double *overlaps;	/* optional ptr to list of prescribed 
				   'inversive distances' to nghb's in flower 
				   (ie cosine of overlap angle/inv dist). */
        int util_flag;          /* utility flag (misc temp uses) */
        int next_vert;          /* next vert in draw order (misc temp uses) */
 };

struct R_data
 {
	complex center;		/* center as complex number */
	double rad;		/* radius of circle for this node. 
				   hyperbolic case: called 's_radius' for 
				   special. exp(-r) is stored for
				   finite radii; for infinite hyp radius,
				   we store the negative of the eucl radius
				   (can then use eucl data for plotting). */
	double curv;		/* angle sum at this vertex. */
	double aim;		/* desired curvature at this vertex */
 };


/* ==================== structure for screen data ====================*/

struct s_data
 {
	Pix_box pix_box;	/* describes pixel box for screen */
	Box box;		/* real world box for screen */
	double factor;		/* display factor from param window */
	double disp_trans[3][3],disp_inv_trans[3][3];
				/* 3x3 transforms real x,y,z to those
				   for display (and inverse) */
	int cflag_opt;	        /* display option for circles,
				   standard flags. */
	int fflag_opt;	        /* display option for faces,
				   standard flags. */
	int unitcircle;		/* 0=don't diplay */
	int ms_flag;		/* flags for sensitized mice in canvas.
				   0=unsensitized, 1=rubberband circ,
				   2=add circ, 3=del circ, 4=enfold,
				   5=crosshairs,6=incr rad,7=decr rad */
	int coord_flag;		/* 1=show coord axes */
	Pixmap xpm;		/* pointer to Pixmap */
	XID xid;		/* canvas xid */
 } *screendata;

/* ==================== structure for pack data ====================*/

struct p_data
 {
	int status;		/* 0 if pack empty, 1 otherwise */
	char fhead[64];		/* pack header <= 40 char*/
	char file_name[NAME_MAX]; /* filename when file was written */
	int hes;		/* curvature of geometry,-1=hyp,0=eucl,1=sph */
        int intrinsic_geom;     /* intrinsic geometry (max pack setting) */
	struct K_data *packK_ptr;	/* pointer to corres complex data */
	struct R_data *packR_ptr;	/* pointer to corres rad data */
	int sizelimit;		/* max number of node space allocated */
	int nodecount;		/* number of nodes */
	int facecount;		/* number of faces = 1+edges-nodes */
	int intnode;		/* number of interior nodes */
	int num_bdry_comp;	/* number of bdry components */
	int num_int_comp;	/* number of components of interior verts */
	int bdry_starts[MAX_COMPONENTS+1];	
				/* indices for nodes marking bdry components */
	int int_starts[MAX_COMPONENTS+1];	
				/* indices of nodes marking int components */
	int first_face;		/* index of first face to plot */
	int first_red_face;	/* index of "red" chain of faces */
	int beta;		/* index of beta node (on boundary) */
	int alpha;		/* index of alpha node (origin) */
	int gamma;		/* index of node to be plotted on y>0 axis */
	int euler;		/* Euler characteristic */
	int genus;		/* genus of complex. Euler+#bdry=2-2g */
	int active_node;	/* currently active_node */
	int locks;		/* locks placed by remote processes;
					bitwise flags */
	int overlap_status;	/* true if some non-trivial overlaps set */
	f_data *faces;		/* pointer to face data: filled by
				   routine complex_count */
        int *rwb_flags;		/* red/white/blue flags for faces:
				   set in face-order stuff */
        int *f_util;            /* temporary utility flags for processing 
				   faces: user must de/allocate as needed. */
	struct s_data *screen;	/* pointer to screen for display */
        struct Vertlist *vlist;   /* pack utility vert list */
        struct Vertlist *flist;   /* pack utility face list */
        struct Edgelist *elist;   /* pack utility edge list */
        struct Edgelist *vertex_map; /* optional table mapping (some)
					vertices of this pack to 
					vertex numbers of another, 
					e.g. in projection to another
					canvas.*/
        struct RedList *redfaces;  /* double linked list of data for drawing
					bdry faces.*/
        struct EdgePair *edge_pair;
                                 /* stores ptrs to red chain for edge
				    pairings in non-simply conn cases */
 } *packdata;

/* IDEA: "light" packing has minimal data for standard repacking
   (assume tangency, no overlaps stored). Data is organized explicitly 
   for efficient communication/repacking. Local indices are sequential, 
   from 1 to nodecount; "variable" verts are those subject to
   repacking adjustment (even if on combinatoric bdry), others are
   "fixed" verts and are given the higher indices; fixed verts don't
   have flowers since they're only there to complete flowers of the
   variable verts. Space is allocated for variable vert aims if they
   are != 2*pi (Eg. a variable vert which is a bdry in parent typically
   has a negative aim and that will require an entry here.)

   Carry 'checkpoint' and 'orig_indices' data from parent
   packing to be able to pass info back. */

struct p_light
 {
   int *counts;           /* create area of size 12 for future
			     expansion. Current contents as follows:
                             0: vertcount
			        = size of radii block
				= size of orig_indices block
			     1: hes=geometry
			     2: vcount= count of variable verts
			     3: size of var_indices block 
                             4: checkcount (= parent nodecount) 
			     5: aimcount= count of non-default aims 
			        = size of aim_index block
				= size of aim block   
			  */

   int *var_indices;      /* block of variable vert flower data: a
			     contiguous list of "num p(0)..p(num)". 
			     Note: stored here using local index 
			     (1 to vertcount) */
   int *orig_indices;     /* listing of all vert indices in parent pack */
   int *orig_fixed;       /* utility ptr = orig_indices+counts[2]+1 */
   double *radii;         /* block of  radii: bdry are last */
   double *fixed_radii;   /* utility ptr = radii+counts[2]+1 */
   int *aim_indices;      /* block of indices (local) of verts with 
			     non-default aims for variable verts */
   double *aims;          /* block of corresponding aims */
};


/* =================================================================
Global variables: here because often required by library routines. */

double toler;	/* numerical tolerance for computing */
double okerr;	/* quantity small enough to set to zero 
		   in calculating */
double m_toler; /* machine tolerence = sqrt(machine precision) */
unsigned long fgcolor,bgcolor; /* indices of fore/backgound colors */
int sc_print_size;	/* size (inches) for postscript output */
int color_ramp_size;    /* color ramp depends on GUI being used */
unsigned char red[NUM_COLORS+1],green[NUM_COLORS+1],blue[NUM_COLORS+1];
int bc_min,bc_max;        /* min/max indices for special colors
			     (those for which bdry color is modified
			     from those of interior) */
int bc_offset;            /* When reading color values from rgb_file,
			     store circle/face bdry colors values 
			     at .75 of parent (interior); store 
			     in color map with offset (<0) to 
			     index of parent value. */
int line_thick;		/* thickness setting for lines */
double ps_linewidth;    /* linewidth for postscript */
double graylevel;       /* double value to send to postscript */
int fill_mode;		/* mode for filled objects: 0=grey,1=white,
				   2=black */
Box std_real_box;	/* default real world window */
int iterates;		/* number Newton iterates in pack computations */
unsigned long int rand_next; /* random number generator variable */
int num_plot;		/* num plot points for arcs on sphere */
double degPI;           /* set to 180.0/M_PI */

struct Vertlist *Vlist;   /* global utility vert list */
struct Vertlist *Flist;   /* global utility face list */
struct Edgelist *Elist;   /* global utility edge list */
struct Edgelist *Vertex_map;/* global utility vertex_map */
struct Centlist *Clist;   /* globel utility center list */

struct Pathlist *pathlist,*newpath; 	
			  /* specify "cookie cutting" paths. */
int pathlength;		  /* number of pts in stored pathlist */
Region region;            /* for XLib region info */

int **face_org;           /* For short-lived data on face indices
			     needed by several routines. */
double layout_th;         /* layout threshold: tolerance for placement
			     errors in pack centers. */

extern struct Vertlist *Node_link_parse(),*Face_link_parse();
extern struct Edgelist *Node_pair_link();

#endif
