#
# 	Construction des transports et definition des etats
# 	(c) 1997 Alexandre Burton
# 	v1.80a (10/08/97)
#
#       EDITED BY Hans-Christoph Steiner <hans@eds.org>
#       $Id $

proc buildTransports {} {
    global path curState color helpLine tcl_platform fffont ffont prefs
    initStates 
    foreach c {0 1 2 3 4} {grid columnconfigure $path(trans) $c -weight 1}
    grid rowconfig $path(trans) 0 -weight 1
    
    set pshort(Play) <$prefs(pkey)>
    set pshort(Stop) <$prefs(skey)>
    set pshort(Pause) ""
    set row 0
    
    switch -- $tcl_platform(platform) {
	"windows"   { 
	    array set pname { bReset * bPlay > bStop \[\] } 
	}
	"macintosh" { 
	    array set pname { bPlay "Send to Csound (Cmd-Space)" }        
	}
	"unix"      { 
	    array set pname { bPlay "Play <$plnam)>" bStop "Stop <$spnam>" bPause Pause }
	}           
    }
    
    button $path(trans).bReset  -command {CsoundReset} -width 2 
    button $path(trans).bRewind -command {CsoundRewind} -width 2     
    button $path(trans).bStop  -command {CsoundStop} -width 2 
	
    
    switch -- $tcl_platform(platform) {
	"windows" {
	    checkbutton $path(trans).bPlay -indicatoron 0 -selectcolor Black\
		    -variable curState(.bPlay) -command {CsoundLaunch}
	    checkbutton $path(trans).bPause -indicatoron 0 -selectcolor Black \
		    -variable curState(.bPause) -command {CsoundPause} 
 	}
	"unix" {
	    checkbutton $path(trans).bPlay -indicatoron 0 -selectcolor Black -bg ${color}3\
		    -variable curState(.bPlay) -bd 2 -command {CsoundLaunch}  -activebackground ${color}4
	    checkbutton $path(trans).bPause -indicatoron 0 -selectcolor Black -bg ${color}3\
		    -variable curState(.bPause) -bd 2 -command {CsoundPause} -activebackground ${color}4
 	}
	"macintosh" {	
	    button $path(trans).bPlay -command {CsoundLaunch}
	    checkbutton $path(trans).bPause -indicatoron 0 -selectcolor Black \
		    -variable curState(.bPause) -command {CsoundPause} 
 	}	
    }    
    
    
    checkbutton $path(trans).bCue -indicatoron 0 -selectcolor Black \
	-variable curState(.bCue)  -command {CsoundCue} 
    
    switch -- $tcl_platform(platform) {
	"windows" {
	    grid $path(trans).bReset  -row $row -column 0 -columnspan 2 -sticky ew
	    grid $path(trans).bStop   -row $row -column 2 -columnspan 2 -sticky ew	
	    grid $path(trans).bPlay   -row $row -column 4 -columnspan 2 -sticky ew
	    foreach b {Reset Stop Play} { $path(trans).b$b config -text $pname(b$b) }
	}
	"unix" {
	    switch -- $tcl_platform(os) {
		"IRIX" {
		    pack $path(trans).bStop   -side left -expand 1 -fill both -padx 1 -pady 2
		    pack $path(trans).bPause  -side left -expand 1 -fill both -padx 1 -pady 2
		    pack $path(trans).bPlay   -side left -expand 1 -fill both -padx 1 -pady 2
		    foreach b {Pause Stop Play} { $path(trans).b$b config -bd 3 -text "$b $pshort($b)" }
		}
		"Linux" {
		    grid $path(trans).bStop  -row $row -column 0 -columnspan 2 -sticky news
		    grid $path(trans).bPause   -row $row -column 2 -columnspan 2 -sticky news	
		    grid $path(trans).bPlay   -row $row -column 4 -columnspan 2 -sticky news
		    foreach b {Pause Stop Play} { $path(trans).b$b config -text "$b $pshort($b)" }
		}
		"Darwin" {
		    grid $path(trans).bStop  -row $row -column 0 -columnspan 2 -sticky news
		    grid $path(trans).bPause   -row $row -column 2 -columnspan 2 -sticky news	
		    grid $path(trans).bPlay   -row $row -column 4 -columnspan 2 -sticky news
		    foreach b {Pause Stop Play} { $path(trans).b$b config -text "$b $pshort($b)" }
		}
	    }
	}
	
	"macintosh" {	
	    grid $path(trans).bPlay   -row $row -column 0 -columnspan 6 -sticky ew -padx 3 -pady 3
	    foreach b {Play} { $path(trans).b$b config -text $pname(b$b) }		
	}	
	"not_yet..." {
	    grid $path(trans).bRewind -row $row -column 1 -sticky ew
	    grid $path(trans).bPause  -row $row -column 3 -sticky ew
	    grid $path(trans).bCue    -row $row -column 5 -sticky ew
	}
    }
    
    foreach b {bReset bRewind bPause bStop bPlay bCue} { bindHelp $path(trans).$b $b }
    setstate not
}


proc previewcsound {command} {
	global color okline newline tcl_platform cfont
    switch -- $tcl_platform(platform)  {
	macintosh   { toplevel .cs -bg ${color}2; unsupported1 style .cs movableDBoxProc }
	windows	    { toplevel .cs -bg ${color}2 }
	unix        { toplevel .cs -bg ${color}2 }
    }
 	wm title .cs "Csound Command Previewer"
	label .cs.l -text "Csound Command Line:"  -bg ${color}2
	text .cs.e  -bg white -width 100 -height 6 -font $cfont(big)
	button .cs.c -text "Cancel" -width 10 -command "set okline 0; destroy .cs"
	if {$tcl_platform(platform)  == "macintosh"}	{
		button .cs.o -text "Proceed"  -width 10 -default 1\
		  -command {set newline [.cs.e get 0.0 e]; set okline 1; destroy .cs}
	} {
		button .cs.o -text "Proceed"  -width 10 \
		  -command {set newline [.cs.e get 0.0 e]; set okline 1; destroy .cs}
	}
	
	
	.cs.e insert 0.0 $command

	
    grid columnconfig .cs 1 -weight 2
    grid .cs.l -column 0 -row 0 -sticky w  -columnspan 1 -padx 3
	grid .cs.e -column 0 -row 1 -sticky ew  -columnspan 4 -padx 3
	grid .cs.c -column 2 -row 2 -sticky e   -padx 3 -pady 3
	grid .cs.o -column 3 -row 2 -sticky w   -padx 3 -pady 3

	bindtags .cs.l {.cs .cs.l Label all}
	bind .cs <Return> ".cs.o invoke ; break"
   	bind .cs <Escape> ".cs.c invoke ; break"

   	focus .cs ; grab set .cs ; tkwait window .cs

}

proc initStates {} {
	global states idblink cueid
	set cueid {}
	set idblink {}

	set normal 	 	black
	set disabled 	gray75
	set playing		green
	set cueing		yellow
	set pausing		red
	
	array set states [subst "
		play {
		   {
			{.bReset	{}	normal 		$normal}
			{.bRewind 	{}	normal 		$normal}
			{.bStop		{}	normal		$normal}
			{.bPause	0	normal 		$normal}
			{.bPlay		1	disabled 	$playing}
			{.bCue		0	disabled 	$disabled}
		   }
		   {}
		}
		not {
		   {
			{.bReset	{}	disabled 	$disabled}
			{.bRewind 	{}	disabled 	$disabled}
			{.bStop		{}	disabled	$disabled}
			{.bPause	0	disabled 	$disabled}
			{.bPlay		0	disabled 	$disabled}
			{.bCue		0	disabled 	$disabled}
		   }
		   {}
		}
		cue {
		   {
			{.bReset	{}	normal 		$normal}
			{.bRewind 	{}	disabled 	$disabled}
			{.bStop		{}	normal 		$normal}
			{.bPause	0	disabled 	$disabled}
			{.bPlay		0	disabled 	$disabled}
			{.bCue		1	disabled 	$cueing}
		   }
		   {blink .bCue $normal $cueing 200}
		}
		pause {
		   {
			{.bReset	{}	normal 		$normal}
			{.bRewind 	{}	normal 		$normal}
			{.bStop		{}	normal 		$normal}
			{.bPause	1	disabled 	$pausing}
			{.bPlay		0	normal 		$normal}
			{.bCue		0	disabled 	$disabled}
		   }
		   {blink .bPlay $normal $playing 400}
		}
		idle {
		   {
			{.bReset	{}	normal		$normal}
			{.bRewind 	{}	disabled 	$disabled}
			{.bStop		{}	disabled 	$disabled}
			{.bPause	0	disabled 	$disabled}
			{.bPlay		0	normal 		$normal}
			{.bCue		0	normal 		$normal}
		   }
		   {}
		}
	"]
}

proc setstate {state} {
	global states curState cueid path idblink
	after cancel $cueid
	after cancel $idblink
	set preset [lindex $states($state) 0]
	foreach b $preset {
		$path(trans)[lindex $b 0] config -state [lindex $b 2] -fg [lindex $b 3] \
			-disabledforeground [lindex $b 3]
		if [llength [lindex $b 1]] {set curState([lindex $b 0]) [lindex $b 1]}
	}
	eval [lindex $states($state) 1]
}

proc blink {what from to speed} {
	global idblink path
	$path(trans)$what config -fg $to -disabledforeground $to
	set idblink [after $speed blink $what $to $from $speed]
}
