from bzrlib import tests
from bzrlib.plugins.pipeline.pipeline import PipeStorage


class TestCaseWithPipes(tests.TestCaseWithTransport):

    def make_branch_and_checkout(self, branch_path, checkout_path='checkout'):
        branch = self.make_branch(branch_path)
        return branch.create_checkout(checkout_path, lightweight=True)

    def connect_many(self, *branches):
        prev = None
        for branch in branches:
            if prev is not None:
                PipeStorage.connect(prev, branch)
            prev = branch
