/*
 * Copyright (c) 2000-2004 QoSient, LLC
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 * Copyright (c) 1990, 1991, 1992, 1993, 1994
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * distributions including binary code include the above copyright notice and
 * this paragraph in its entirety in the documentation or other materials
 * provided with the distribution, and (3) all advertising materials mentioning
 * features or use of this software display the following acknowledgement:
 * ``This product includes software developed by the University of California,
 * Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
 * the University nor the names of its contributors may be used to endorse
 * or promote products derived from this software without specific prior
 * written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * @(#) $Header: /usr/local/cvsroot/argus/include/gencode.h,v 1.17 2004/02/23 15:00:36 argus Exp $ (LBL)
 */

/*
 * filter.h must be included before this file.
 */

#include <os.h>

/* Address qualifers. */

#define Q_HOST		1
#define Q_NET		2
#define Q_PORT		3
#define Q_GATEWAY	4
#define Q_PROTO		5
#define Q_TTL		6
#define Q_TOS		7

/* Protocol qualifiers. */

#define Q_LINK		1
#define Q_MAN		2
#define Q_IP		3
#define Q_ARP		4
#define Q_RARP		5
#define Q_TCP		6
#define Q_UDP		7
#define Q_ICMP		8
#define Q_IGMP		9
#define Q_IGRP		10

#define	Q_DECNET	11
#define	Q_LAT		12
#define	Q_MOPRC		13
#define	Q_MOPDL		14

#define Q_DETAIL	15
#define Q_MERGED	16

/* TCP Protocol qualifiers. */

#define Q_NORMAL	17
#define Q_MULTIPATH	18
#define Q_RESET		19
#define Q_TIMEDOUT	20
#define Q_WINSHUT	21
#define Q_ESTABLISHED	22
#define Q_RETRANS	23
#define Q_SRCRETRANS	24
#define Q_DSTRETRANS	25
#define Q_FRAG		26
#define Q_FRAG_ONLY	27
#define Q_CONNECTED 	28
#define Q_REJECT    	29
#define Q_ECHO    	30
#define Q_UNREACH    	31
#define Q_REDIRECT    	32
#define Q_TIMEXED     	33
#define Q_LOOP      	34

#define Q_SYN		40
#define Q_SYNACK	41
#define Q_DATA		42
#define Q_FIN		43
#define Q_FINACK	44
#define Q_WAIT		45


/* RTP Protocol qualifiers. */


#define Q_RTP   	46
#define Q_ESP   	47
#define Q_ECN   	48
#define Q_MPLS   	49
#define Q_VLAN   	50


/* Directional qualifers. */

#define Q_SRC		1
#define Q_DST		2
#define Q_OR		3
#define Q_AND		4

#define Q_DEFAULT	0
#define Q_UNDEF		255

struct stmt {
	int code;
        struct slist *jt;       /*only for relative jump in block*/
        struct slist *jf;       /*only for relative jump in block*/
	int k;
};

struct slist {
	struct stmt s;
	struct slist *next;
};

/* 
 * A bit vector to represent definition sets.  We assume TOT_REGISTERS
 * is smaller than 8*sizeof(atomset).
 */

typedef unsigned int atomset;
#define ATOMMASK(n) (1 << (n))
#define ATOMELEM(d, n) (d & ATOMMASK(n))

/*
 * An unbounded set.
 */

typedef unsigned int *uset;

/*
 * Total number of atomic entities, including accumulator (A) and index (X).
 * We treat all these guys similarly during flow analysis.
 */

#define N_ATOMS (BPF_MEMWORDS+2)

struct edge {
	int id;
	int code;
	uset edom;
	struct block *succ;
	struct block *pred;
	struct edge *next;	/* link list of incoming edges for a node */
};

struct block {
	int id;
	struct slist *stmts;	/* side effect stmts */
	struct stmt s;		/* branch stmt */
	int mark;
        int longjt;             /* jt branch requires long jump */
        int longjf;             /* jf branch requires long jump */
	int level;
	int offset;
	int sense;
	struct edge et;
	struct edge ef;
	struct block *head;
	struct block *link;	/* link field used by optimizer */
	uset dom;
	uset closure;
	struct edge *in_edges;
	atomset def, kill;
	atomset in_use;
	atomset out_use;
	int oval;
	int val[N_ATOMS];
};

struct arth {
	struct block *b;	/* protocol checks */
	struct slist *s;	/* stmt list */
	int regno;		/* virtual register number of result */
};

struct qual {
	unsigned char addr;
	unsigned char proto;
	unsigned char dir;
	unsigned char pad;
};

#ifndef __GNUC__
#define volatile
#endif

#define yylex argus_lex
#define yyparse argus_parse

extern int argus_lex(void);
extern int argus_parse (void);
extern void argus_lex_init(char *buf);

struct arth *Argusgen_loadi(int);
struct arth *Argusgen_load(int, struct arth *, int);
struct arth *Argusgen_loadlen(void);
struct arth *Argusgen_neg(struct arth *);
struct arth *Argusgen_arth(int, struct arth *, struct arth *);

void Argusgen_and(struct block *, struct block *);
void Argusgen_or(struct block *, struct block *);
void Argusgen_not(struct block *);

struct block *Argusgen_scode(char *, struct qual);
struct block *Argusgen_tcode(int, struct qual);
struct block *Argusgen_ecode(u_char *, struct qual);
struct block *Argusgen_mcode(char *, char *, int, struct qual);
struct block *Argusgen_ncode(char *, unsigned int, struct qual);
struct block *Argusgen_proto_abbrev(int);
struct block *Argusgen_relation(int, struct arth *, struct arth *, int);
struct block *Argusgen_less(int);
struct block *Argusgen_greater(int);
struct block *Argusgen_byteop(int, int, int);
struct block *Argusgen_broadcast(int);
struct block *Argusgen_multicast(int);
struct block *Argusgen_inbound(int);

void Argusbpf_optimize(struct block **);

void Argus_error(char *fmt, ...);

void Argusfinish_parse(struct block *);
char *Argussdup(char *);

struct bpf_insn *Argusicode_to_fcode(struct block *, int *);

int Arguspcap_parse(void);
void Arguslex_init(char *);
void Argussappend(struct slist *, struct slist *);

int ArgusFilterCompile(struct bpf_program *, char *, int, unsigned int);


/* XXX */
#define JT(b)  ((b)->et.succ)
#define JF(b)  ((b)->ef.succ)
