!{\src2tex{textfont=tt}}
!!****f* ABINIT/linfit
!! NAME
!! linfit
!!
!! FUNCTION
!! Perform a linear fit of y=ax+b data
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! PARENTS
!!
!! INPUTS
!!  x(n)=x coordinates
!!  y(n)=y coordinates
!!
!! OUTPUT
!!  a=coefficient of linear term of fit
!!  b=coefficient of constant term of fit
!!  function linfit=root mean square of differences between data and fit
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

function linfit(n,x,y,a,b)

 use defs_basis

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: n
 real(dp) :: linfit
 real(dp),intent(out) :: a,b
!arrays
 real(dp),intent(in) :: x(n),y(n)

!Local variables-------------------------------
!scalars
 integer :: i
 real(dp) :: msrt=0._dp,sx2=0._dp,sx=0._dp,sxy=0._dp,sy=0._dp,tx,ty

! *************************************************************************

 sx=0._dp; sy=0._dp; sxy=0._dp; sx2=0._dp
 do i=1,n
   tx=dble(x(i))
   ty=dble(y(i))
   sx=sx+tx
   sy=sy+ty
   sxy=sxy+tx*ty
   sx2=sx2+tx*tx
 end do
 a=(n*sxy-sx*sy)/(n*sx2-sx*sx)
 b=sy/n-sx*a/n
 msrt=0._dp
 do i=1,n
   tx=dble(x(i))
   ty=dble(y(i))
   msrt=msrt+( ty-a*tx-b )**2
 end do
 msrt=sqrt(msrt/n)
 linfit=msrt
 end function linfit
!!***
