/* NewWorkspace.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.main.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

import org.grinvin.gui.FileFilters;
import org.grinvin.workspace.Workspace;
import org.grinvin.workspace.WorkspaceException;


/**
 *
 * @author adpeeter
 */
public class NewWorkspace extends AbstractAction {

    // implements handleExecute
    public void actionPerformed (ActionEvent e) {
        try {
            File directory = selectNewWorkspaceLocation();
            if (directory != null) {
                Workspace.getInstance().newWorkspace(directory);
            }
        } catch (WorkspaceException ex) {
            throw new RuntimeException("Could not create new workspace");
        }
    }

    /**
     * Ask the user for a workspace location.
     * @return directory which will hold the workspace, or null when no directory
     * could be chosen.
     */
    public static File selectNewWorkspaceLocation() {
        // TODO: factor out common functionality with SaveWorkspaceAs
        // TODO: this should not be here

        JFileChooser chooser = new JFileChooser();
        ResourceBundle bundle = ResourceBundle.getBundle("org.grinvin.main.actions.resources");
        chooser.setFileFilter(FileFilters.GWS_FILTER);

        if (chooser.showDialog(null, bundle.getString("workspace.save.caption")) == JFileChooser.APPROVE_OPTION) {

            File file = FileFilters.GWS_FILTER.ensureExtension(chooser.getSelectedFile());
            if (file.exists()) {
                int response = JOptionPane.showConfirmDialog(null,
                        MessageFormat.format(bundle.getString("workspace.overwrite.message"), file),
                        bundle.getString("workspace.overwrite.title"),
                        JOptionPane.YES_NO_CANCEL_OPTION);
                if (response == JOptionPane.YES_OPTION) {
                    return file;
                } else if (response == JOptionPane.NO_OPTION) {
                    return selectNewWorkspaceLocation();
                }
            } else {
                return file;
            }
        }
        return null;
    }
}
