/* AbstractInvariantValueAction.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.list.actions;

import be.ugent.caagt.swirl.actions.SimpleAction;

import java.util.ResourceBundle;

import org.grinvin.invariants.InvariantValue;
import org.grinvin.list.graphs.GraphListElement;

/**
 * Abstract implementation for invariant value actions.
 */
public abstract class AbstractInvariantValueAction extends SimpleAction {
    
    //
    protected InvariantValue iv;
    
    //
    public void setInvariantValue(InvariantValue iv) {
        this.iv = iv;
        setEnabled(iv);
    }
    
    //
    protected void setEnabled(InvariantValue value) {
        setEnabled(value != null);
    }
    
    //
    protected GraphListElement gle;
    
    //
    public void setGraphListElement(GraphListElement gle) {
        this.gle = gle;
        setEnabled(gle);
    }
    
    //
    protected void setEnabled(GraphListElement element) {
        setEnabled(element != null);
    }
    
    /**
     * Create an action of this type for the given invariant value and graph list element.
     */
    public AbstractInvariantValueAction(InvariantValue iv, GraphListElement gle, String resourceID) {
        super(ResourceBundle.getBundle("org.grinvin.list.actions.resources"),
                resourceID, null);
        setInvariantValue(iv);
        setGraphListElement(gle);
    }
}
