/* UndoableGraph.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.gred.undoable;

import org.grinvin.graphs.Edge;
import org.grinvin.graphs.Graph;
import org.grinvin.graphs.Vertex;

/**
 * <p>
 * An undoable version of {@link Graph}. Provides methods to restore vertices
 * and edges in the graph.
 * </p>
 */
public interface UndoableGraph extends Graph {
    
    /**
     * Restore a vertex which was previously removed from the graph. The vertex
     * should end up at the same index position as it had before.<p>
     * This method is intended for
     * use by the undo/redo framework and should be called with care. It is supposed
     * to undo a prior removal of that same vertex. Clients are urged to instead
     * use {@link #addNewVertex} whenever possible.
     * @param v Vertex that should be restored. This must be a vertex that was previously
     * removed from the same graph.
     */
    public void restore(Vertex v);
    
    /**
     * Restore a edge which was previously removed from the graph.<p>
     * This method is intended for
     * use by the undo/redo framework and should be called with care. It is supposed
     * to undo a prior removal of that same edge. Clients are urged to instead
     * use {@link #addNewEdge} whenever possible.
     * @param e Edge that should be restored. This must be a edge that was previously
     * removed from the same graph.
     */
    public void restore(Edge e);
    
}
