/* Factory.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.factories;

import org.grinvin.params.ParameterList;

/**
 * An object which can be used to create other objects. This is a common superinterface
 * of several factory classes, each generating their own type of object. The general idea
 * is to first set the parameter values for this factory, by means of {@link #setParameterValues}
 * and then to create a specific object by calling a {@code create...} method, which is
 * specific for each implementation of this interface.
 */
public interface Factory {
    
    /**
     * Return the (current) parameter values.
     */
    public Object[] getParameterValues();
    
    /**
     * Returns the list of parameters accepted by this factory.
     */
    public ParameterList getParameters();
    
    /**
     * Initialize the factory with new parameter values.
     */
    public void setParameterValues(Object[] values) throws FactoryParameterException;
    
}
